/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.ExtensionResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.r4.ActivityDefinitionProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.BasePlanDefinitionProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.r4.QuestionnaireProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.r4.generator.questionnaireitem.QuestionnaireItemGenerator;
import org.opencds.cqf.fhir.cr.questionnaireresponse.r4.QuestionnaireResponseProcessor;
import org.opencds.cqf.fhir.utility.client.Clients;
import org.opencds.cqf.fhir.utility.r4.ContainedHelper;
import org.opencds.cqf.fhir.utility.r4.InputParameterResolver;
import org.opencds.cqf.fhir.utility.r4.PackageHelper;
import org.opencds.cqf.fhir.utility.r4.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanDefinitionProcessor
extends BasePlanDefinitionProcessor<PlanDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(PlanDefinitionProcessor.class);
    private final ActivityDefinitionProcessor activityDefinitionProcessor;
    private final QuestionnaireProcessor questionnaireProcessor;
    private final QuestionnaireResponseProcessor questionnaireResponseProcessor;
    private ExtensionResolver extensionResolver;
    private InputParameterResolver inputParameterResolver;
    private QuestionnaireItemGenerator questionnaireItemGenerator;
    protected OperationOutcome oc;

    public PlanDefinitionProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public PlanDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        super(repository, evaluationSettings);
        this.activityDefinitionProcessor = new ActivityDefinitionProcessor(this.repository, evaluationSettings);
        this.questionnaireProcessor = new QuestionnaireProcessor(this.repository, evaluationSettings);
        this.questionnaireResponseProcessor = new QuestionnaireResponseProcessor(this.repository, evaluationSettings);
    }

    @Override
    public void extractQuestionnaireResponse() {
        if (this.bundle == null) {
            return;
        }
        List questionnaireResponses = ((Bundle)this.bundle).getEntry().stream().filter(entry -> entry.getResource().fhirType().equals(Enumerations.FHIRAllTypes.QUESTIONNAIRERESPONSE.toCode())).map(entry -> (QuestionnaireResponse)entry.getResource()).collect(Collectors.toList());
        if (questionnaireResponses != null && !questionnaireResponses.isEmpty()) {
            for (QuestionnaireResponse questionnaireResponse : questionnaireResponses) {
                try {
                    Bundle extractBundle = (Bundle)this.questionnaireResponseProcessor.extract(questionnaireResponse, this.parameters, this.bundle, this.libraryEngine);
                    this.extractedResources.add(questionnaireResponse);
                    for (Bundle.BundleEntryComponent entry2 : extractBundle.getEntry()) {
                        ((Bundle)this.bundle).addEntry(entry2);
                    }
                }
                catch (Exception e) {
                    this.addOperationOutcomeIssue(String.format("Error encountered extracting %s: %s", questionnaireResponse.getId(), e.getMessage()));
                }
            }
        }
    }

    public Bundle packagePlanDefinition(PlanDefinition thePlanDefinition, boolean theIsPut) {
        Library library;
        CanonicalType libraryCanonical;
        Bundle bundle = new Bundle();
        bundle.setType(Bundle.BundleType.TRANSACTION);
        bundle.addEntry(PackageHelper.createEntry((Resource)thePlanDefinition, (boolean)theIsPut));
        CanonicalType canonicalType = libraryCanonical = thePlanDefinition.hasLibrary() ? (CanonicalType)thePlanDefinition.getLibrary().get(0) : null;
        if (libraryCanonical != null && (library = (Library)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)libraryCanonical)) != null) {
            bundle.addEntry(PackageHelper.createEntry((Resource)library, (boolean)theIsPut));
            if (library.hasRelatedArtifact()) {
                PackageHelper.addRelatedArtifacts((Bundle)bundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)theIsPut);
            }
        }
        if (thePlanDefinition.hasRelatedArtifact()) {
            PackageHelper.addRelatedArtifacts((Bundle)bundle, (List)thePlanDefinition.getRelatedArtifact(), (Repository)this.repository, (boolean)theIsPut);
        }
        return bundle;
    }

    @Override
    public <C extends IPrimitiveType<String>> PlanDefinition resolvePlanDefinition(IIdType theId, C theCanonical, IBaseResource thePlanDefinition) {
        IBaseResource basePlanDefinition = thePlanDefinition;
        if (basePlanDefinition == null) {
            basePlanDefinition = theId != null ? this.repository.read(PlanDefinition.class, theId) : SearchHelper.searchRepositoryByCanonical((Repository)this.repository, theCanonical);
        }
        Objects.requireNonNull(basePlanDefinition, "Couldn't find PlanDefinition " + String.valueOf(theId));
        return PlanDefinitionProcessor.castOrThrow((IBase)basePlanDefinition, PlanDefinition.class, "The planDefinition passed in was not a valid instance of PlanDefinition.class").orElse(null);
    }

    @Override
    public PlanDefinition initApply(PlanDefinition planDefinition) {
        logger.info("Performing $apply operation on {}", (Object)planDefinition.getIdPart());
        this.oc = new OperationOutcome();
        this.oc.setId("apply-outcome-" + planDefinition.getIdPart());
        this.extractQuestionnaireResponse();
        this.questionnaire = new Questionnaire();
        this.questionnaire.setId((IIdType)new IdType(Enumerations.FHIRAllTypes.QUESTIONNAIRE.toCode(), planDefinition.getIdPart()));
        this.questionnaireItemGenerator = QuestionnaireItemGenerator.of(this.repository, this.subjectId, this.parameters, this.bundle, this.libraryEngine);
        this.inputParameterResolver = new InputParameterResolver(this.subjectId, this.encounterId, this.practitionerId, this.parameters, this.useServerData, this.bundle, this.repository);
        this.extensionResolver = new ExtensionResolver(this.subjectId, (IBaseParameters)this.inputParameterResolver.getParameters(), this.bundle, this.libraryEngine);
        return planDefinition;
    }

    @Override
    public IBaseResource applyPlanDefinition(PlanDefinition planDefinition) {
        String canonical = planDefinition.getUrl();
        if (planDefinition.hasVersion()) {
            canonical = String.format("%s|%s", canonical, planDefinition.getVersion());
        }
        RequestGroup requestGroup = new RequestGroup().setStatus(RequestGroup.RequestStatus.DRAFT).setIntent(RequestGroup.RequestIntent.PROPOSAL).addInstantiatesCanonical(canonical).setSubject(new Reference(this.subjectId));
        requestGroup.setId((IIdType)new IdType(requestGroup.fhirType(), planDefinition.getIdElement().getIdPart()));
        if (this.encounterId != null) {
            requestGroup.setEncounter(new Reference(this.encounterId));
        }
        if (this.practitionerId != null) {
            requestGroup.setAuthor(new Reference(this.practitionerId));
        }
        if (this.organizationId != null) {
            requestGroup.setAuthor(new Reference(this.organizationId));
        }
        if (this.userLanguage instanceof CodeableConcept) {
            requestGroup.setLanguage(((CodeableConcept)this.userLanguage).getCodingFirstRep().getCode());
        }
        if (planDefinition.hasExtension()) {
            requestGroup.setExtension(planDefinition.getExtension().stream().filter(e -> !EXCLUDED_EXTENSION_LIST.contains(e.getUrl())).collect(Collectors.toList()));
        }
        String defaultLibraryUrl = planDefinition.getLibrary() == null || planDefinition.getLibrary().isEmpty() ? null : (String)((CanonicalType)planDefinition.getLibrary().get(0)).getValue();
        this.extensionResolver.resolveExtensions(requestGroup.getExtension(), defaultLibraryUrl);
        for (int i = 0; i < planDefinition.getGoal().size(); ++i) {
            Goal goal = this.convertGoal((PlanDefinition.PlanDefinitionGoalComponent)planDefinition.getGoal().get(i));
            if (Boolean.TRUE.equals(this.containResources)) {
                requestGroup.addContained((Resource)goal);
            } else {
                goal.setIdElement(new IdType("Goal", String.valueOf(i + 1)));
                requestGroup.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal").setValue((Type)new Reference((IIdType)goal.getIdElement()));
            }
            this.requestResources.add(goal);
        }
        HashMap<String, PlanDefinition.PlanDefinitionActionComponent> metConditions = new HashMap<String, PlanDefinition.PlanDefinitionActionComponent>();
        for (PlanDefinition.PlanDefinitionActionComponent action : planDefinition.getAction()) {
            requestGroup.addAction(this.resolveAction(defaultLibraryUrl, planDefinition, requestGroup, metConditions, action));
        }
        return Boolean.TRUE.equals(this.containResources) ? ContainedHelper.liftContainedResourcesToParent((DomainResource)requestGroup) : requestGroup;
    }

    public CarePlan transformToCarePlan(IBaseResource rg) {
        RequestGroup requestGroup = (RequestGroup)rg;
        if (!this.oc.getIssue().isEmpty()) {
            requestGroup.addContained((Resource)this.oc);
            requestGroup.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (Type)new Reference("#" + this.oc.getIdPart()));
        }
        CarePlan carePlan = new CarePlan().setInstantiatesCanonical(requestGroup.getInstantiatesCanonical()).setSubject(requestGroup.getSubject()).setStatus(CarePlan.CarePlanStatus.DRAFT).setIntent(CarePlan.CarePlanIntent.PROPOSAL);
        carePlan.setId((IIdType)new IdType(carePlan.fhirType(), requestGroup.getIdElement().getIdPart()));
        if (requestGroup.hasEncounter()) {
            carePlan.setEncounter(requestGroup.getEncounter());
        }
        if (requestGroup.hasAuthor()) {
            carePlan.setAuthor(requestGroup.getAuthor());
        }
        if (requestGroup.getLanguage() != null) {
            carePlan.setLanguage(requestGroup.getLanguage());
        }
        for (IBaseResource goal : this.requestResources) {
            if (!goal.fhirType().equals("Goal")) continue;
            carePlan.addGoal(new Reference((IAnyResource)((Resource)goal)));
        }
        List<Resource> operationOutcomes = this.resolveContainedByType((DomainResource)requestGroup, Enumerations.FHIRAllTypes.OPERATIONOUTCOME.toCode());
        for (Resource operationOutcome : operationOutcomes) {
            carePlan.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (Type)new Reference("#" + operationOutcome.getId()));
        }
        carePlan.addActivity().setReference(new Reference((IAnyResource)requestGroup));
        carePlan.addContained((Resource)requestGroup);
        for (IBaseResource resource : this.extractedResources) {
            carePlan.addSupportingInfo(new Reference((IAnyResource)((Resource)resource)));
            carePlan.addContained((Resource)resource);
        }
        if (((Questionnaire)this.questionnaire).hasItem()) {
            carePlan.addContained((Resource)this.questionnaire);
        }
        return (CarePlan)ContainedHelper.liftContainedResourcesToParent((DomainResource)carePlan);
    }

    @Override
    public IBaseResource transformToBundle(IBaseResource rg) {
        RequestGroup requestGroup = (RequestGroup)rg;
        Bundle resultBundle = new Bundle().setType(Bundle.BundleType.COLLECTION);
        resultBundle.setId(requestGroup.getIdElement().getIdPart());
        if (!this.oc.getIssue().isEmpty()) {
            requestGroup.addContained((Resource)this.oc);
            requestGroup.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (Type)new Reference("#" + this.oc.getIdPart()));
        }
        resultBundle.addEntry().setResource((Resource)requestGroup);
        for (IBaseResource resource : this.requestResources) {
            resultBundle.addEntry().setResource((Resource)resource);
        }
        for (IBaseResource resource : this.extractedResources) {
            resultBundle.addEntry().setResource((Resource)resource);
        }
        if (((Questionnaire)this.questionnaire).hasItem()) {
            resultBundle.addEntry().setResource((Resource)this.questionnaire);
        }
        return resultBundle;
    }

    @Override
    public void addOperationOutcomeIssue(String issue) {
        this.oc.addIssue().setCode(OperationOutcome.IssueType.EXCEPTION).setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(issue);
    }

    private Goal convertGoal(PlanDefinition.PlanDefinitionGoalComponent goal) {
        Goal myGoal = new Goal();
        myGoal.setCategory(Collections.singletonList(goal.getCategory()));
        myGoal.setDescription(goal.getDescription());
        myGoal.setPriority(goal.getPriority());
        myGoal.setStart((Type)goal.getStart());
        myGoal.setLifecycleStatus(Goal.GoalLifecycleStatus.PROPOSED);
        myGoal.setSubject(new Reference(this.subjectId));
        myGoal.setTarget(goal.getTarget().stream().map(target -> {
            Goal.GoalTargetComponent myTarget = new Goal.GoalTargetComponent();
            myTarget.setDetail(target.getDetail());
            myTarget.setMeasure(target.getMeasure());
            myTarget.setDue((Type)target.getDue());
            myTarget.setExtension(target.getExtension());
            return myTarget;
        }).collect(Collectors.toList()));
        return myGoal;
    }

    private RequestGroup.RequestGroupActionComponent resolveAction(String defaultLibraryUrl, PlanDefinition planDefinition, RequestGroup requestGroup, Map<String, PlanDefinition.PlanDefinitionActionComponent> metConditions, PlanDefinition.PlanDefinitionActionComponent action) {
        if (planDefinition.hasExtension("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-questionnaire-generate") && action.hasInput()) {
            for (Object actionInput : action.getInput()) {
                if (!actionInput.hasProfile()) continue;
                ((Questionnaire)this.questionnaire).addItem(this.questionnaireItemGenerator.generateItem((DataRequirement)actionInput, ((Questionnaire)this.questionnaire).getItem().size()));
            }
        }
        if (Boolean.TRUE.equals(this.meetsConditions(defaultLibraryUrl, action))) {
            metConditions.put(action.getId(), action);
            RequestGroup.RequestGroupActionComponent requestAction = this.createRequestAction(action);
            this.extensionResolver.resolveExtensions(requestAction.getExtension(), defaultLibraryUrl);
            if (action.hasAction()) {
                for (PlanDefinition.PlanDefinitionActionComponent containedAction : action.getAction()) {
                    requestAction.addAction(this.resolveAction(defaultLibraryUrl, planDefinition, requestGroup, metConditions, containedAction));
                }
            }
            IBaseResource resource = null;
            if (action.hasDefinitionCanonicalType()) {
                resource = this.resolveDefinition(planDefinition, action);
                if (resource != null) {
                    this.applyAction(requestGroup, resource, action);
                    requestAction.setResource(new Reference(resource.getIdElement()));
                    if (Boolean.TRUE.equals(this.containResources)) {
                        requestGroup.addContained((Resource)resource);
                    } else {
                        this.requestResources.add(resource);
                    }
                }
            } else if (action.hasDefinitionUriType()) {
                UriType definition = action.getDefinitionUriType();
                requestAction.setResource(new Reference(definition.asStringValue()));
            }
            this.resolveDynamicValues(defaultLibraryUrl, (IElement)requestAction, (IBase)resource, action);
            return requestAction;
        }
        return null;
    }

    private RequestGroup.RequestGroupActionComponent createRequestAction(PlanDefinition.PlanDefinitionActionComponent action) {
        RequestGroup.RequestGroupActionComponent requestAction = new RequestGroup.RequestGroupActionComponent().setTitle(action.getTitle()).setDescription(action.getDescription()).setTextEquivalent(action.getTextEquivalent()).setCode(action.getCode()).setDocumentation(action.getDocumentation()).setTiming(action.getTiming()).setType(action.getType());
        requestAction.setId(action.getId());
        if (action.hasExtension()) {
            requestAction.setExtension(action.getExtension());
        }
        if (action.hasCondition()) {
            action.getCondition().forEach(c -> requestAction.addCondition(new RequestGroup.RequestGroupActionConditionComponent().setKind(RequestGroup.ActionConditionKind.fromCode((String)c.getKind().toCode())).setExpression(c.getExpression())));
        }
        if (action.hasPriority()) {
            requestAction.setPriority(RequestGroup.RequestPriority.fromCode((String)action.getPriority().toCode()));
        }
        if (action.hasRelatedAction()) {
            action.getRelatedAction().forEach(ra -> requestAction.addRelatedAction(new RequestGroup.RequestGroupActionRelatedActionComponent().setActionId(ra.getActionId()).setRelationship(RequestGroup.ActionRelationshipType.fromCode((String)ra.getRelationship().toCode())).setOffset(ra.getOffset())));
        }
        if (action.hasSelectionBehavior()) {
            requestAction.setSelectionBehavior(RequestGroup.ActionSelectionBehavior.fromCode((String)action.getSelectionBehavior().toCode()));
        }
        return requestAction;
    }

    private IBaseResource resolveDefinition(PlanDefinition planDefinition, PlanDefinition.PlanDefinitionActionComponent action) {
        logger.debug("Resolving definition {}", action.getDefinitionCanonicalType().getValue());
        CanonicalType definition = action.getDefinitionCanonicalType();
        String resourceName = this.resolveResourceName(definition, (MetadataResource)planDefinition);
        switch (Enumerations.FHIRAllTypes.fromCode((String)Objects.requireNonNull(resourceName))) {
            case PLANDEFINITION: {
                return this.applyNestedPlanDefinition(planDefinition, definition);
            }
            case ACTIVITYDEFINITION: {
                return this.applyActivityDefinition(planDefinition, definition);
            }
            case QUESTIONNAIRE: {
                return this.applyQuestionnaireDefinition(planDefinition, definition);
            }
        }
        throw new FHIRException(String.format("Unknown action definition: %s", definition));
    }

    private IBaseResource applyQuestionnaireDefinition(PlanDefinition planDefinition, CanonicalType definition) {
        Resource result = null;
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            result = referenceToContained ? this.resolveContained((DomainResource)planDefinition, (String)definition.getValue()) : SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)definition);
        }
        catch (Exception e) {
            String message = String.format("ERROR: Questionnaire %s could not be applied and threw exception %s", definition.asStringValue(), e.toString());
            logger.error(message);
            this.addOperationOutcomeIssue(message);
        }
        return result;
    }

    private IBaseResource applyActivityDefinition(PlanDefinition planDefinition, CanonicalType definition) {
        IBaseResource result = null;
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            ActivityDefinition activityDefinition = (ActivityDefinition)(referenceToContained ? this.resolveContained((DomainResource)planDefinition, (String)definition.getValue()) : SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)definition));
            result = this.activityDefinitionProcessor.apply(activityDefinition, this.subjectId, this.encounterId, this.practitionerId, this.organizationId, this.userType, this.userLanguage, this.userTaskContext, this.setting, this.settingContext, this.parameters, this.useServerData, this.bundle, this.libraryEngine);
            result.setId((IIdType)(referenceToContained ? new IdType(result.fhirType(), activityDefinition.getIdPart().replaceFirst("#", "")) : activityDefinition.getIdElement().withResourceType(result.fhirType())));
        }
        catch (Exception e) {
            String message = String.format("ERROR: ActivityDefinition %s could not be applied and threw exception %s", definition.asStringValue(), e.toString());
            logger.error(message);
            this.addOperationOutcomeIssue(message);
        }
        return result;
    }

    private IBaseResource applyNestedPlanDefinition(PlanDefinition planDefinition, CanonicalType definition) {
        RequestGroup result = null;
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            PlanDefinition nextPlanDefinition = (PlanDefinition)(referenceToContained ? this.resolveContained((DomainResource)planDefinition, (String)definition.getValue()) : SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)definition));
            result = (RequestGroup)this.applyPlanDefinition(nextPlanDefinition);
        }
        catch (Exception e) {
            String message = String.format("ERROR: PlanDefinition %s could not be applied and threw exception %s", definition.asStringValue(), e.toString());
            logger.error(message);
            this.addOperationOutcomeIssue(message);
        }
        return result;
    }

    private void applyAction(RequestGroup requestGroup, IBaseResource result, PlanDefinition.PlanDefinitionActionComponent action) {
        if ("Task".equals(result.fhirType())) {
            this.resolveTask(requestGroup, (Task)result, action);
        }
    }

    private void resolveTask(RequestGroup requestGroup, Task task, PlanDefinition.PlanDefinitionActionComponent action) {
        if (action.hasId()) {
            task.setId((IIdType)new IdType(task.fhirType(), action.getId()));
        }
        if (action.hasRelatedAction()) {
            List relatedActions = action.getRelatedAction();
            for (PlanDefinition.PlanDefinitionActionRelatedActionComponent relatedAction : relatedActions) {
                Extension next = new Extension();
                next.setUrl("http://hl7.org/fhir/aphl/StructureDefinition/next");
                if (relatedAction.hasOffset()) {
                    Extension offsetExtension = new Extension();
                    offsetExtension.setUrl("http://hl7.org/fhir/aphl/StructureDefinition/offset");
                    offsetExtension.setValue(relatedAction.getOffset());
                    next.addExtension(offsetExtension);
                }
                Extension target = new Extension();
                Reference targetRef = new Reference((IIdType)new IdType(task.fhirType(), relatedAction.getActionId()));
                target.setUrl("http://hl7.org/fhir/aphl/StructureDefinition/target");
                target.setValue((Type)targetRef);
                next.addExtension(target);
                task.addExtension(next);
            }
        }
        if (action.hasCondition()) {
            List conditionComponents = action.getCondition();
            for (PlanDefinition.PlanDefinitionActionConditionComponent conditionComponent : conditionComponents) {
                Extension condition = new Extension();
                condition.setUrl("http://hl7.org/fhir/aphl/StructureDefinition/condition");
                condition.setValue((Type)conditionComponent.getExpression());
                if (conditionComponent.hasExtension("http://hl7.org/fhir/us/ecr/StructureDefinition/us-ph-alternativeExpression")) {
                    condition.addExtension(conditionComponent.getExtensionByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/us-ph-alternativeExpression"));
                }
                task.addExtension(condition);
            }
        }
        if (action.hasInput()) {
            List dataRequirements = action.getInput();
            for (DataRequirement dataRequirement : dataRequirements) {
                Extension input = new Extension();
                input.setUrl("http://hl7.org/fhir/aphl/StructureDefinition/input");
                input.setValue((Type)dataRequirement);
                task.addExtension(input);
            }
        }
        task.addBasedOn(new Reference((IAnyResource)requestGroup).setType(requestGroup.fhirType()));
        task.setFor(requestGroup.getSubject());
        this.resolvePrepopulateAction(action, requestGroup, task);
    }

    private void resolvePrepopulateAction(PlanDefinition.PlanDefinitionActionComponent action, RequestGroup requestGroup, Task task) {
        if (action.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-prepopulate")) {
            List<Bundle> questionnaireBundles = this.getQuestionnairePackage(action.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-prepopulate"));
            for (Bundle questionnaireBundle : questionnaireBundles) {
                Questionnaire toPopulate = (Questionnaire)questionnaireBundle.getEntryFirstRep().getResource();
                List<Library> libraries = questionnaireBundle.getEntry().stream().filter(e -> e.hasResource() && e.getResource().fhirType().equals(Enumerations.FHIRAllTypes.LIBRARY.toCode())).map(e -> (Library)e.getResource()).collect(Collectors.toList());
                List<ValueSet> valueSets = questionnaireBundle.getEntry().stream().filter(e -> e.hasResource() && e.getResource().fhirType().equals(Enumerations.FHIRAllTypes.VALUESET.toCode())).map(e -> (ValueSet)e.getResource()).collect(Collectors.toList());
                Bundle additionalData = this.bundle == null ? new Bundle().setType(Bundle.BundleType.COLLECTION) : ((Bundle)this.bundle).copy();
                libraries.forEach(library -> additionalData.addEntry(new Bundle.BundleEntryComponent().setResource((Resource)library)));
                valueSets.forEach(valueSet -> additionalData.addEntry(new Bundle.BundleEntryComponent().setResource((Resource)valueSet)));
                Questionnaire populatedQuestionnaire = this.questionnaireProcessor.prePopulate(toPopulate, this.subjectId, this.parameters, (IBaseBundle)additionalData, this.libraryEngine);
                if (Boolean.TRUE.equals(this.containResources)) {
                    requestGroup.addContained((Resource)populatedQuestionnaire);
                } else {
                    this.requestResources.add(populatedQuestionnaire);
                }
                task.setFocus(new Reference((IIdType)new IdType(Enumerations.FHIRAllTypes.QUESTIONNAIRE.toCode(), populatedQuestionnaire.getIdPart())));
                task.setFor(requestGroup.getSubject());
            }
        }
    }

    private List<Bundle> getQuestionnairePackage(Extension prepopulateExtension) {
        Parameters.ParametersParameterComponent prepopulateParameter;
        Bundle bundle = null;
        Extension parameterExtension = prepopulateExtension.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-prepopulate-parameter");
        if (parameterExtension == null) {
            throw new IllegalArgumentException(String.format("Required extension for %s not found.", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-prepopulate-parameter"));
        }
        String parameterName = parameterExtension.getValue().toString();
        Parameters.ParametersParameterComponent parametersParameterComponent = prepopulateParameter = this.parameters != null ? ((Parameters)this.parameters).getParameter(parameterName) : null;
        if (prepopulateParameter == null) {
            throw new IllegalArgumentException(String.format("Parameter not found: %s ", parameterName));
        }
        String orderId = prepopulateParameter.toString();
        Extension questionnaireExtension = prepopulateExtension.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-lookupQuestionnaire");
        if (questionnaireExtension == null) {
            throw new IllegalArgumentException(String.format("Required extension for %s not found.", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-lookupQuestionnaire"));
        }
        if (questionnaireExtension.getValue().hasType(new String[]{Enumerations.FHIRAllTypes.CANONICAL.toCode()})) {
            Resource questionnaire = SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)((CanonicalType)questionnaireExtension.getValue()));
            if (questionnaire != null) {
                bundle = new Bundle().addEntry(new Bundle.BundleEntryComponent().setResource(questionnaire));
            }
        } else if (questionnaireExtension.getValue().hasType(new String[]{Enumerations.FHIRAllTypes.URL.toCode()})) {
            bundle = this.callQuestionnairePackageOperation(((UrlType)questionnaireExtension.getValue()).getValueAsString());
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        return Collections.singletonList(bundle);
    }

    private Bundle callQuestionnairePackageOperation(String url) {
        String baseUrl = null;
        String operation = null;
        if (url.contains("$")) {
            String[] urlSplit = url.split("$");
            baseUrl = urlSplit[0];
            operation = urlSplit[1];
        } else {
            baseUrl = url;
            operation = "questionnaire-package";
        }
        Bundle bundle = null;
        IGenericClient client = Clients.forUrl((FhirContext)this.repository.fhirContext(), (String)baseUrl);
        try {
            Type order = null;
            Type coverage = null;
            bundle = (Bundle)((IOperationUnnamed)client.operation().onType(Enumerations.FHIRAllTypes.QUESTIONNAIRE.toCode())).named("$" + operation).withParameters((IBaseParameters)new Parameters().addParameter("order", order).addParameter("coverage", coverage)).returnResourceType(Bundle.class).execute();
        }
        catch (Exception e) {
            logger.error("Error encountered calling $questionnaire-package operation: %s", (Throwable)e);
        }
        return bundle;
    }

    private CqfExpression getCqfExpression(Expression expression, String defaultLibraryUrl, Extension altExtension) {
        if (expression == null) {
            return null;
        }
        Expression altExpression = null;
        if (altExtension != null && altExtension.hasValue() && altExtension.getValue() instanceof Expression) {
            altExpression = (Expression)altExtension.getValue();
        }
        return new CqfExpression(expression, defaultLibraryUrl, altExpression);
    }

    private void resolveDynamicValues(String defaultLibraryUrl, IElement requestAction, IBase resource, PlanDefinition.PlanDefinitionActionComponent action) {
        if (!action.hasDynamicValue()) {
            return;
        }
        Parameters inputParams = this.inputParameterResolver.resolveInputParameters(action.getInput());
        action.getDynamicValue().forEach(dynamicValue -> {
            if (dynamicValue.hasExpression()) {
                List result = null;
                try {
                    result = this.libraryEngine.resolveExpression(this.subjectId, this.getCqfExpression(dynamicValue.getExpression(), defaultLibraryUrl, dynamicValue.getExtensionByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/us-ph-alternativeExpression")), (IBaseParameters)inputParams, this.bundle);
                    this.resolveDynamicValue(result, dynamicValue.getPath(), requestAction, resource);
                }
                catch (Exception e) {
                    String message = String.format("DynamicValue expression %s encountered exception: %s", dynamicValue.getExpression().getExpression(), e.getMessage());
                    logger.error(message);
                    this.addOperationOutcomeIssue(message);
                }
            }
        });
    }

    private Boolean meetsConditions(String defaultLibraryUrl, PlanDefinition.PlanDefinitionActionComponent action) {
        if (!action.hasCondition()) {
            return true;
        }
        Parameters inputParams = this.inputParameterResolver.resolveInputParameters(action.getInput());
        for (PlanDefinition.PlanDefinitionActionConditionComponent condition : action.getCondition()) {
            if (!condition.hasExpression()) continue;
            IBase result = null;
            try {
                List results = this.libraryEngine.resolveExpression(this.subjectId, this.getCqfExpression(condition.getExpression(), defaultLibraryUrl, condition.getExtensionByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/us-ph-alternativeExpression")), (IBaseParameters)inputParams, this.bundle);
                result = results == null || results.isEmpty() ? null : (IBase)results.get(0);
            }
            catch (Exception e) {
                String message = String.format("Condition expression %s encountered exception: %s", condition.getExpression().getExpression(), e.getMessage());
                logger.error(message);
                this.addOperationOutcomeIssue(message);
            }
            if (result == null) {
                logger.warn("Condition expression {} returned null", (Object)condition.getExpression().getExpression());
                return false;
            }
            if (!(result instanceof BooleanType)) {
                logger.warn("The condition expression {} returned a non-boolean value: {}", (Object)condition.getExpression().getExpression(), (Object)result.getClass().getSimpleName());
                continue;
            }
            if (!((BooleanType)result).booleanValue()) {
                logger.debug("The result of condition expression {} is false", (Object)condition.getExpression().getExpression());
                return false;
            }
            logger.debug("The result of condition expression {} is true", (Object)condition.getExpression().getExpression());
        }
        return true;
    }

    protected String resolveResourceName(CanonicalType canonical, MetadataResource resource) {
        if (canonical.hasValue()) {
            String id = (String)canonical.getValue();
            if (id.contains("/")) {
                return (id = id.replace(id.substring(id.lastIndexOf("/")), "")).contains("/") ? id.substring(id.lastIndexOf("/") + 1) : id;
            }
            if (id.startsWith("#")) {
                return this.resolveContained((DomainResource)resource, id).getResourceType().name();
            }
            return null;
        }
        throw new FHIRException("CanonicalType must have a value for resource name extraction");
    }

    protected Resource resolveContained(DomainResource resource, String id) {
        Optional<Resource> first = resource.getContained().stream().filter(Resource::hasIdElement).filter(x -> x.getIdElement().getIdPart().equals(id)).findFirst();
        return first.orElse(null);
    }

    protected List<Resource> resolveContainedByType(DomainResource resource, String resourceType) {
        return resource.getContained().stream().filter(r -> r.fhirType().equals(resourceType)).collect(Collectors.toList());
    }
}

