/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQuestionnaireProcessor<T> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseQuestionnaireProcessor.class);
    protected final ModelResolver modelResolver;
    protected final EvaluationSettings evaluationSettings;
    protected Repository repository;
    protected LibraryEngine libraryEngine;
    protected String patientId;
    protected IBaseParameters parameters;
    protected IBaseBundle bundle;
    protected String libraryUrl;
    protected static final String subjectType = "Patient";

    protected BaseQuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)repository.fhirContext().getVersion().getVersion());
    }

    public static <T extends IBase> Optional<T> castOrThrow(IBase obj, Class<T> type, String errorMessage) {
        if (obj == null) {
            return Optional.empty();
        }
        if (type.isInstance(obj)) {
            return Optional.of((IBase)type.cast(obj));
        }
        throw new IllegalArgumentException(errorMessage);
    }

    public abstract <CanonicalType extends IPrimitiveType<String>> T resolveQuestionnaire(IIdType var1, CanonicalType var2, IBaseResource var3);

    public <CanonicalType extends IPrimitiveType<String>> T prePopulate(IIdType id, CanonicalType canonical, IBaseResource questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        this.repository = Repositories.proxy((Repository)this.repository, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
        return this.prePopulate(this.resolveQuestionnaire(id, canonical, questionnaire), patientId, parameters, bundle, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <CanonicalType extends IPrimitiveType<String>> T prePopulate(IIdType id, CanonicalType canonical, IBaseResource questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        return this.prePopulate(this.resolveQuestionnaire(id, canonical, questionnaire), patientId, parameters, bundle, libraryEngine);
    }

    public abstract T prePopulate(T var1, String var2, IBaseParameters var3, IBaseBundle var4, LibraryEngine var5);

    public <CanonicalType extends IPrimitiveType<String>> IBaseResource populate(IIdType id, CanonicalType canonical, IBaseResource questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        this.repository = Repositories.proxy((Repository)this.repository, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
        return this.populate(this.resolveQuestionnaire(id, canonical, questionnaire), patientId, parameters, bundle, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseResource populate(IIdType id, CanonicalType canonical, IBaseResource questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        return this.populate(this.resolveQuestionnaire(id, canonical, questionnaire), patientId, parameters, bundle, libraryEngine);
    }

    public abstract IBaseResource populate(T var1, String var2, IBaseParameters var3, IBaseBundle var4, LibraryEngine var5);

    public abstract T generateQuestionnaire(String var1);

    public abstract IBaseBundle packageQuestionnaire(T var1, boolean var2);

    public IBaseBundle packageQuestionnaire(T questionnaire) {
        return this.packageQuestionnaire(questionnaire, false);
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseBundle packageQuestionnaire(IIdType id, CanonicalType canonical, IBaseResource questionnaire, boolean isPut) {
        return this.packageQuestionnaire(this.resolveQuestionnaire(id, canonical, questionnaire), isPut);
    }
}

