/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r4.generator.questionnaireitem;

import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.ExtensionResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.questionnaire.r4.generator.nestedquestionnaireitem.NestedQuestionnaireItemService;
import org.opencds.cqf.fhir.cr.questionnaire.r4.generator.questionnaireitem.QuestionnaireItemService;
import org.opencds.cqf.fhir.utility.r4.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireItemGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(QuestionnaireItemGenerator.class);
    protected static final String NO_PROFILE_ERROR = "No profile defined for input. Unable to generate item.";
    protected static final String ITEM_CREATION_ERROR = "An error occurred during item creation: %s";
    protected static final String CHILD_LINK_ID_FORMAT = "%s.%s";
    protected final Repository repository;
    protected final LibraryEngine libraryEngine;
    protected final String patientId;
    protected final IBaseBundle bundle;
    protected final IBaseParameters parameters;
    protected final QuestionnaireItemService questionnaireItemService;
    protected final NestedQuestionnaireItemService nestedQuestionnaireItemService;
    protected final ExtensionResolver extensionResolver;
    protected Questionnaire.QuestionnaireItemComponent questionnaireItem;

    public static QuestionnaireItemGenerator of(Repository repository, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        QuestionnaireItemService questionnaireItemService = new QuestionnaireItemService();
        NestedQuestionnaireItemService nestedQuestionnaireItemService = NestedQuestionnaireItemService.of(repository, patientId, parameters, bundle, libraryEngine);
        return new QuestionnaireItemGenerator(repository, libraryEngine, patientId, parameters, bundle, questionnaireItemService, nestedQuestionnaireItemService);
    }

    QuestionnaireItemGenerator(Repository repository, LibraryEngine libraryEngine, String patientId, IBaseParameters parameters, IBaseBundle bundle, QuestionnaireItemService questionnaireItemService, NestedQuestionnaireItemService nestedQuestionnaireItemService) {
        this.repository = repository;
        this.libraryEngine = libraryEngine;
        this.patientId = patientId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.questionnaireItemService = questionnaireItemService;
        this.nestedQuestionnaireItemService = nestedQuestionnaireItemService;
        this.extensionResolver = new ExtensionResolver(patientId, parameters, bundle, libraryEngine);
    }

    public Questionnaire.QuestionnaireItemComponent generateItem(DataRequirement actionInput, int itemCount) {
        if (!actionInput.hasProfile()) {
            throw new IllegalArgumentException(NO_PROFILE_ERROR);
        }
        String linkId = String.valueOf(itemCount + 1);
        try {
            StructureDefinition profile = (StructureDefinition)this.getProfileDefinition(actionInput);
            this.questionnaireItem = this.questionnaireItemService.createQuestionnaireItem(actionInput, linkId, profile);
            this.extensionResolver.resolveExtensions(this.questionnaireItem.getExtension(), null);
            this.processElements(profile);
        }
        catch (Exception ex) {
            String message = String.format(ITEM_CREATION_ERROR, ex.getMessage());
            logger.error(message);
            this.questionnaireItem = this.createErrorItem(linkId, message);
        }
        return this.questionnaireItem;
    }

    protected void processElements(StructureDefinition profile) {
        Type extValue;
        int childCount = this.questionnaireItem.getItem().size();
        Resource caseFeature = null;
        if (profile.hasExtension("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression") && (extValue = profile.getExtensionByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression").getValue()) instanceof Expression) {
            IBase result;
            Expression expression = (Expression)extValue;
            List results = this.libraryEngine.getExpressionResult(this.patientId, expression.getExpression(), expression.getLanguage(), expression.getReference(), this.parameters, this.bundle);
            IBase iBase = result = results == null || results.isEmpty() ? null : (IBase)results.get(0);
            if (result instanceof Resource) {
                caseFeature = (Resource)result;
            }
        }
        for (ElementDefinition element : this.getElementsWithNonNullElementType(profile)) {
            this.processElement(profile, element, ++childCount, caseFeature);
        }
    }

    protected void processElement(StructureDefinition profile, ElementDefinition element, int childCount, Resource caseFeature) {
        String childLinkId = String.format(CHILD_LINK_ID_FORMAT, this.questionnaireItem.getLinkId(), childCount);
        try {
            Questionnaire.QuestionnaireItemComponent nestedQuestionnaireItem = this.nestedQuestionnaireItemService.getNestedQuestionnaireItem(profile.getUrl(), element, childLinkId, caseFeature);
            this.questionnaireItem.addItem(nestedQuestionnaireItem);
        }
        catch (Exception ex) {
            String message = String.format(ITEM_CREATION_ERROR, ex.getMessage());
            logger.warn(message);
            this.questionnaireItem.addItem(this.createErrorItem(childLinkId, message));
        }
    }

    protected List<ElementDefinition> getElementsWithNonNullElementType(StructureDefinition profile) {
        List elements = profile.getDifferential().getElement();
        return elements.stream().filter(element -> this.getElementType((ElementDefinition)element) != null).collect(Collectors.toList());
    }

    protected Questionnaire.QuestionnaireItemComponent createErrorItem(String linkId, String errorMessage) {
        return new Questionnaire.QuestionnaireItemComponent().setLinkId(linkId).setType(Questionnaire.QuestionnaireItemType.DISPLAY).setText(errorMessage);
    }

    protected String getElementType(ElementDefinition element) {
        return element.hasType() ? ((ElementDefinition.TypeRefComponent)element.getType().get(0)).getCode() : null;
    }

    protected Resource getProfileDefinition(DataRequirement actionInput) {
        return SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)((CanonicalType)actionInput.getProfile().get(0)));
    }
}

