/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r5.generator.nestedquestionnaireitem;

import java.util.List;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.questionnaire.r5.ItemValueTransformer;

public class ElementHasCqfExpression {
    protected String patientId;
    protected IBaseBundle bundle;
    protected IBaseParameters parameters;
    protected LibraryEngine libraryEngine;

    public ElementHasCqfExpression(String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        this.patientId = patientId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
    }

    public Questionnaire.QuestionnaireItemComponent addProperties(ElementDefinition element, Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        Expression expression = this.getExpression(element);
        List<IBase> results = this.getExpressionResults(expression);
        results.forEach(result -> {
            if (Resource.class.isAssignableFrom(result.getClass())) {
                this.addResourceValue((IBase)result, questionnaireItem);
            } else {
                this.addTypeValue((IBase)result, questionnaireItem);
            }
        });
        return questionnaireItem;
    }

    void addResourceValue(IBase result, Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        IAnyResource resource = (IAnyResource)result;
        Reference reference = new Reference(resource);
        questionnaireItem.addInitial().setValue((DataType)reference);
    }

    void addTypeValue(IBase result, Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        DataType type = ItemValueTransformer.transformValue((DataType)result);
        questionnaireItem.addInitial().setValue(type);
    }

    protected final List<IBase> getExpressionResults(Expression expression) {
        return this.libraryEngine.getExpressionResult(this.patientId, expression.getExpression(), expression.getLanguage(), expression.getReference(), this.parameters, this.bundle);
    }

    protected Expression getExpression(ElementDefinition element) {
        DataType type = element.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expression").getValue();
        return (Expression)type;
    }
}

