/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r4;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Reference;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class MedicationRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public MedicationRequestResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public MedicationRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        MedicationRequest medicationRequest = new MedicationRequest();
        medicationRequest.setStatus(MedicationRequest.MedicationRequestStatus.DRAFT);
        medicationRequest.setIntent(this.activityDefinition.hasIntent() ? MedicationRequest.MedicationRequestIntent.fromCode((String)this.activityDefinition.getIntent().toCode()) : MedicationRequest.MedicationRequestIntent.ORDER);
        medicationRequest.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            medicationRequest.setInstantiatesCanonical(Collections.singletonList(new CanonicalType(this.activityDefinition.getUrl() + (this.activityDefinition.hasVersion() ? String.format("|%s", this.activityDefinition.getVersion()) : ""))));
        }
        if (request.hasEncounterId()) {
            medicationRequest.setEncounter(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            medicationRequest.setRequester(new Reference(request.getPractitionerId()));
        }
        if (this.activityDefinition.hasProduct()) {
            medicationRequest.setMedication(this.activityDefinition.getProduct());
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException(String.format("Missing required ActivityDefinition.product property for %s", "MedicationRequest"));
        }
        if (this.activityDefinition.hasDosage()) {
            medicationRequest.setDosageInstruction(this.activityDefinition.getDosage());
        }
        if (this.activityDefinition.hasDoNotPerform()) {
            medicationRequest.setDoNotPerform(this.activityDefinition.getDoNotPerform());
        }
        return medicationRequest;
    }
}

