/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r4;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Reference;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class ProcedureResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public ProcedureResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public Procedure resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        Procedure procedure = new Procedure();
        procedure.setStatus(Procedure.ProcedureStatus.UNKNOWN);
        procedure.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            procedure.setInstantiatesCanonical(Collections.singletonList(new CanonicalType(this.activityDefinition.getUrl() + (this.activityDefinition.hasVersion() ? String.format("|%s", this.activityDefinition.getVersion()) : ""))));
        }
        if (this.activityDefinition.hasCode()) {
            procedure.setCode(this.activityDefinition.getCode());
        }
        if (this.activityDefinition.hasBodySite()) {
            procedure.setBodySite(this.activityDefinition.getBodySite());
        }
        return procedure;
    }
}

