/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r4;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class ServiceRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public ServiceRequestResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public ServiceRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.setStatus(ServiceRequest.ServiceRequestStatus.DRAFT);
        serviceRequest.setIntent(this.activityDefinition.hasIntent() ? ServiceRequest.ServiceRequestIntent.fromCode((String)this.activityDefinition.getIntent().toCode()) : ServiceRequest.ServiceRequestIntent.ORDER);
        serviceRequest.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            serviceRequest.setInstantiatesCanonical(Collections.singletonList(new CanonicalType(this.activityDefinition.getUrl() + (this.activityDefinition.hasVersion() ? String.format("|%s", this.activityDefinition.getVersion()) : ""))));
        }
        if (request.hasEncounterId()) {
            serviceRequest.setEncounter(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            serviceRequest.setRequester(new Reference(request.getPractitionerId()));
        } else if (request.hasOrganizationId()) {
            serviceRequest.setRequester(new Reference(request.getOrganizationId()));
        }
        if (this.activityDefinition.hasCode()) {
            serviceRequest.setCode(this.activityDefinition.getCode());
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException(String.format("Missing required ActivityDefinition.code property for %s", "ServiceRequest"));
        }
        if (this.activityDefinition.hasBodySite()) {
            serviceRequest.setBodySite(this.activityDefinition.getBodySite());
        }
        if (this.activityDefinition.hasDoNotPerform()) {
            serviceRequest.setDoNotPerform(this.activityDefinition.getDoNotPerform());
        }
        return serviceRequest;
    }
}

