/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cr.common.ICqlOperationRequest;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(ExpressionProcessor.class);
    protected static final String EXCEPTION_MESSAGE_TEMPLATE = "Error encountered evaluating expression (%s) for item (%s): %s";

    public List<IBase> getExpressionResultForItem(ICqlOperationRequest request, CqfExpression expression, String itemLinkId) {
        try {
            return this.getExpressionResult(request, expression);
        }
        catch (Exception ex) {
            String message = String.format(EXCEPTION_MESSAGE_TEMPLATE, expression.getExpression(), itemLinkId, ex.getMessage());
            throw new UnprocessableEntityException(message);
        }
    }

    public List<IBase> getExpressionResult(ICqlOperationRequest request, CqfExpression expression) {
        return this.getExpressionResult(request, expression, null);
    }

    public List<IBase> getExpressionResult(ICqlOperationRequest request, CqfExpression expression, @Nullable IBaseParameters parameters) {
        parameters = parameters == null ? request.getParameters() : parameters;
        Collection result = expression == null ? null : request.getLibraryEngine().resolveExpression(request.getSubjectId().getIdPart(), expression, parameters, request.getData());
        return result == null ? new ArrayList<IBase>() : result.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <E extends IBaseExtension<?, ?>> CqfExpression getCqfExpression(IOperationRequest request, List<E> extensions, String extensionUrl) {
        IBaseExtension extension = extensions.stream().filter(e -> e.getUrl().equals(extensionUrl)).findFirst().orElse(null);
        return extension == null ? null : CqfExpression.of((IBaseExtension)extension, (String)request.getDefaultLibraryUrl());
    }

    public CqfExpression getCqfExpressionForElement(IOperationRequest request, IBaseBackboneElement element) {
        if (element == null) {
            return null;
        }
        String expressionPath = "expression";
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return new CqfExpression(request.resolvePathString((IBase)element, "language"), request.resolvePathString((IBase)element, expressionPath), request.getDefaultLibraryUrl());
            }
            case R4: {
                return CqfExpression.of((Expression)request.resolvePath((IBase)element, expressionPath, Expression.class), (String)request.getDefaultLibraryUrl());
            }
            case R5: {
                return CqfExpression.of((org.hl7.fhir.r5.model.Expression)request.resolvePath((IBase)element, expressionPath, org.hl7.fhir.r5.model.Expression.class), (String)request.getDefaultLibraryUrl());
            }
        }
        return null;
    }

    public CqfExpression getItemInitialExpression(IOperationRequest request, IBaseBackboneElement item) {
        if (!item.hasExtension()) {
            return null;
        }
        String expressionExtensionUrl = request.getFhirVersion() == FhirVersionEnum.DSTU3 ? "http://hl7.org/fhir/StructureDefinition/cqif-cqlExpression" : "http://hl7.org/fhir/StructureDefinition/cqf-expression";
        CqfExpression cqfExpression = this.getCqfExpression(request, item.getExtension(), expressionExtensionUrl);
        return cqfExpression != null ? cqfExpression : this.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
    }
}

