/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.utility.OperationOutcomes;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;

public interface IOperationRequest {
    public String getOperationName();

    public ModelResolver getModelResolver();

    public FhirVersionEnum getFhirVersion();

    public Repository getRepository();

    default public FhirContext getFhirContext() {
        return this.getRepository().fhirContext();
    }

    public String getDefaultLibraryUrl();

    public IBaseOperationOutcome getOperationOutcome();

    public void setOperationOutcome(IBaseOperationOutcome var1);

    default public AdapterFactory getAdapterFactory() {
        return AdapterFactory.forFhirVersion((FhirVersionEnum)this.getFhirVersion());
    }

    default public void logException(String exceptionMessage) {
        if (this.getOperationOutcome() == null) {
            this.setOperationOutcome(OperationOutcomes.newOperationOutcome((FhirVersionEnum)this.getFhirVersion()));
        }
        OperationOutcomes.addExceptionToOperationOutcome((IBaseOperationOutcome)this.getOperationOutcome(), (String)exceptionMessage);
    }

    default public void resolveOperationOutcome(IBaseResource resource) {
        List<IBase> issues = this.resolvePathList((IBase)this.getOperationOutcome(), "issue");
        if (issues != null && !issues.isEmpty()) {
            this.getOperationOutcome().setId(String.format("%s-outcome-%s", this.getOperationName(), resource.getIdElement().getIdPart()));
            this.getModelResolver().setValue((Object)resource, "contained", Collections.singletonList(this.getOperationOutcome()));
            this.getModelResolver().setValue((Object)resource, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(this.getFhirVersion(), ExtensionBuilders.crmiMessagesExtension(this.getOperationOutcome().getIdElement().getIdPart()), true)));
        }
    }

    default public <E extends IBaseExtension<?, ?>> List<E> getExtensions(IBase base) {
        return this.resolvePathList(base, "extension").stream().map(e -> (IBaseExtension)e).collect(Collectors.toList());
    }

    default public List<IBaseExtension<?, ?>> getExtensionsByUrl(IBase base, String url) {
        return this.getExtensions(base).stream().filter(e -> e.getUrl().equals(url)).collect(Collectors.toList());
    }

    default public IBaseExtension<?, ?> getExtensionByUrl(IBase base, String url) {
        return this.getExtensionsByUrl(base, url).stream().findFirst().orElse(null);
    }

    default public boolean hasExtension(IBase base, String url) {
        return this.getExtensions(base).stream().anyMatch(e -> e.getUrl().equals(url));
    }

    default public List<IBaseResource> getContained(IBaseResource base) {
        return this.resolvePathList((IBase)base, "contained", IBaseResource.class);
    }

    default public boolean hasContained(IBaseResource base) {
        return !this.getContained(base).isEmpty();
    }

    default public List<IBase> resolvePathList(IBase base, String path) {
        Object pathResult = this.getModelResolver().resolvePath((Object)base, path);
        return pathResult instanceof List ? (List)pathResult : new ArrayList();
    }

    default public <T extends IBase> List<T> resolvePathList(IBase base, String path, Class<T> clazz) {
        return this.resolvePathList(base, path).stream().map(i -> i).collect(Collectors.toList());
    }

    default public String resolvePathString(IBase base, String path) {
        IBase pathResult = this.resolvePath(base, path);
        if (pathResult instanceof IPrimitiveType) {
            return ((IPrimitiveType)pathResult).getValueAsString();
        }
        return null;
    }

    default public Object resolveRawPath(Object base, String path) {
        return this.getModelResolver().resolvePath(base, path);
    }

    default public IBase resolvePath(IBase base, String path) {
        return (IBase)this.resolveRawPath(base, path);
    }

    default public <T extends IBase> T resolvePath(IBase base, String path, Class<T> clazz) {
        return (T)this.resolvePath(base, path);
    }
}

