/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.iterable.BundleMappingIterable;
import org.opencds.cqf.fhir.utility.monad.Either;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.search.Searches;

public class ResourceResolver {
    final String invalidResourceType = "The resource passed in was not a valid instance of %s.class";
    final String resourceType;
    final Repository repository;
    final Class<? extends IBaseResource> clazz;
    final Class<? extends IBaseBundle> bundleClazz;

    public ResourceResolver(String resourceType, Repository repository) {
        this.resourceType = resourceType;
        this.repository = repository;
        try {
            switch (this.repository.fhirContext().getVersion().getVersion()) {
                case DSTU3: {
                    this.clazz = Class.forName("org.hl7.fhir.dstu3.model." + resourceType);
                    this.bundleClazz = Bundle.class;
                    break;
                }
                case R4: {
                    this.clazz = Class.forName("org.hl7.fhir.r4.model." + resourceType);
                    this.bundleClazz = org.hl7.fhir.r4.model.Bundle.class;
                    break;
                }
                case R5: {
                    this.clazz = Class.forName("org.hl7.fhir.r5.model." + resourceType);
                    this.bundleClazz = org.hl7.fhir.r5.model.Bundle.class;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError();
        }
    }

    protected <C extends IPrimitiveType<String>> IBaseResource resolveByUrl(C url) {
        IBaseBundle result = this.repository.search(this.bundleClazz, this.clazz, Searches.byCanonical((String)((String)url.getValue())));
        Iterator iterator = new BundleMappingIterable(this.repository, result, p -> p.getResource()).iterator();
        return iterator.hasNext() ? (IBaseResource)iterator.next() : null;
    }

    protected IBaseResource resolveById(IIdType id) {
        return this.repository.read(this.clazz, id);
    }

    public <C extends IPrimitiveType<String>, T extends IBaseResource> T resolve(Either3<C, IIdType, T> resource) throws FHIRException {
        IBaseResource baseResource = (IBaseResource)resource.fold(this::resolveByUrl, this::resolveById, Function.identity());
        Objects.requireNonNull(baseResource, String.format("Unable to resolve %s", this.resourceType));
        return (T)((IBaseResource)Resources.castOrThrow((IBase)baseResource, this.clazz, (String)String.format("The resource passed in was not a valid instance of %s.class", this.resourceType)).orElse(null));
    }

    public <T extends IBaseResource> T resolve(Either<IIdType, T> resource) {
        IBaseResource baseResource = (IBaseResource)resource.fold(this::resolveById, Function.identity());
        Objects.requireNonNull(baseResource, String.format("Unable to resolve %s", this.resourceType));
        return (T)((IBaseResource)Resources.castOrThrow((IBase)baseResource, this.clazz, (String)String.format("The resource passed in was not a valid instance of %s.class", this.resourceType)).orElse(null));
    }
}

