/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.inputparameters;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.inputparameters.r4.InputParameterResolver;

public interface IInputParameterResolver {
    public IBaseParameters getParameters();

    public <T extends ICompositeType> IBaseParameters resolveInputParameters(List<T> var1);

    public static <T extends IInputParameterResolver> T createResolver(Repository repository, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IBaseParameters parameters, boolean useServerData, IBaseBundle data) {
        return IInputParameterResolver.createResolver(repository, subjectId, encounterId, practitionerId, parameters, useServerData, data, null, null);
    }

    public static <T extends IInputParameterResolver> T createResolver(Repository repository, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> context, List<IBaseExtension<?, ?>> launchContext) {
        Preconditions.checkNotNull((Object)repository, (Object)"expected non-null value for repository");
        FhirVersionEnum fhirVersion = repository.fhirContext().getVersion().getVersion();
        switch (fhirVersion) {
            case DSTU3: {
                return (T)new org.opencds.cqf.fhir.cr.inputparameters.dstu3.InputParameterResolver(repository, subjectId, encounterId, practitionerId, parameters, useServerData, data, context, launchContext);
            }
            case R4: {
                return (T)new InputParameterResolver(repository, subjectId, encounterId, practitionerId, parameters, useServerData, data, context, launchContext);
            }
            case R5: {
                return (T)new org.opencds.cqf.fhir.cr.inputparameters.r5.InputParameterResolver(repository, subjectId, encounterId, practitionerId, parameters, useServerData, data, context, launchContext);
            }
        }
        return null;
    }
}

