/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.library;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.DataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IDataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.cr.common.PackageProcessor;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.cr.library.evaluate.EvaluateProcessor;
import org.opencds.cqf.fhir.cr.library.evaluate.EvaluateRequest;
import org.opencds.cqf.fhir.cr.library.evaluate.IEvaluateProcessor;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class LibraryProcessor {
    protected final ModelResolver modelResolver;
    protected final FhirVersionEnum fhirVersion;
    protected IPackageProcessor packageProcessor;
    protected IDataRequirementsProcessor dataRequirementsProcessor;
    protected IEvaluateProcessor evaluateProcessor;
    protected Repository repository;
    protected EvaluationSettings evaluationSettings;

    public LibraryProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public LibraryProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null, null, null);
    }

    public LibraryProcessor(Repository repository, EvaluationSettings evaluationSettings, IPackageProcessor packageProcessor, IDataRequirementsProcessor dataRequirementsProcessor, IEvaluateProcessor evaluateProcessor) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.packageProcessor = packageProcessor;
        this.dataRequirementsProcessor = dataRequirementsProcessor;
        this.evaluateProcessor = evaluateProcessor;
    }

    public EvaluationSettings evaluationSettings() {
        return this.evaluationSettings;
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R resolveLibrary(Either3<C, IIdType, R> library) {
        return new ResourceResolver("Library", this.repository).resolve(library);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packageLibrary(Either3<C, IIdType, R> library) {
        return this.packageLibrary(library, false);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packageLibrary(Either3<C, IIdType, R> library, boolean isPut) {
        return this.packageLibrary(library, Parameters.newParameters((FhirContext)this.repository.fhirContext(), (String)"package-parameters", (IBase[])new IBase[]{Parameters.newBooleanPart((FhirContext)this.repository.fhirContext(), (String)"isPut", (boolean)isPut, (IBase[])new IBase[0])}));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packageLibrary(Either3<C, IIdType, R> library, IBaseParameters parameters) {
        return this.packageLibrary((IBaseResource)this.resolveLibrary(library), parameters);
    }

    public IBaseBundle packageLibrary(IBaseResource library, IBaseParameters parameters) {
        IPackageProcessor processor = this.packageProcessor != null ? this.packageProcessor : new PackageProcessor(this.repository);
        return processor.packageResource(library, parameters);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource dataRequirements(Either3<C, IIdType, R> library, IBaseParameters parameters) {
        return this.dataRequirements((IBaseResource)this.resolveLibrary(library), parameters);
    }

    public IBaseResource dataRequirements(IBaseResource library, IBaseParameters parameters) {
        IDataRequirementsProcessor processor = this.dataRequirementsProcessor != null ? this.dataRequirementsProcessor : new DataRequirementsProcessor(this.repository, this.evaluationSettings);
        return processor.getDataRequirements(library, parameters);
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> EvaluateRequest buildEvaluateRequest(Either3<C, IIdType, R> library, String subject, List<String> expression, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine) {
        return new EvaluateRequest((IBaseResource)this.resolveLibrary(library), StringUtils.isBlank((CharSequence)subject) ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)subject), expression, parameters, useServerData, data, prefetchData, libraryEngine, this.modelResolver);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseParameters evaluate(Either3<C, IIdType, R> library, String subject, List<String> expression, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.evaluate(library, subject, expression, parameters, useServerData, data, prefetchData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseParameters evaluate(Either3<C, IIdType, R> library, String subject, List<String> expression, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, Repository dataRepository, Repository contentRepository, Repository terminologyRepository) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.evaluate(library, subject, expression, parameters, useServerData, data, prefetchData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseParameters evaluate(Either3<C, IIdType, R> library, String subject, List<String> expression, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine) {
        IEvaluateProcessor processor = this.evaluateProcessor != null ? this.evaluateProcessor : new EvaluateProcessor(this.repository, this.evaluationSettings);
        return processor.evaluate(this.buildEvaluateRequest(library, subject, expression, parameters, useServerData, data, prefetchData, libraryEngine));
    }
}

