/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.library.evaluate;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.ICqlOperationRequest;
import org.opencds.cqf.fhir.utility.BundleHelper;

public class EvaluateRequest
implements ICqlOperationRequest {
    private final IBaseResource library;
    private final IIdType subjectId;
    private final Set<String> expression;
    private final IBaseParameters parameters;
    private final boolean useServerData;
    private final IBaseBundle data;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private IBaseOperationOutcome operationOutcome;

    public EvaluateRequest(IBaseResource library, IIdType subjectId, List<String> expression, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)library, (Object)"expected non-null value for library");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.library = library;
        this.fhirVersion = library.getStructureFhirVersionEnum();
        this.subjectId = subjectId;
        this.expression = expression == null ? null : new HashSet<String>(expression);
        this.parameters = parameters;
        this.useServerData = useServerData;
        if (prefetchData != null && !prefetchData.isEmpty()) {
            if (data == null) {
                data = BundleHelper.newBundle((FhirVersionEnum)this.fhirVersion);
            }
            this.resolvePrefetchData(data, prefetchData);
        }
        this.data = data;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
    }

    public IBaseResource getLibrary() {
        return this.library;
    }

    public Set<String> getExpression() {
        return this.expression;
    }

    @Override
    public String getOperationName() {
        return "evaluate";
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    public String getSubject() {
        return this.subjectId == null ? null : this.subjectId.getValueAsString();
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.parameters;
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.resolvePathString((IBase)this.library, "url");
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    @Override
    public boolean getUseServerData() {
        return this.useServerData;
    }
}

