/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.common;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(MeasureEvaluator.class);
    protected CqlEngine context;
    protected String measurementPeriodParameterName;
    protected LibraryEngine libraryEngine;

    public MeasureEvaluator(CqlEngine context, String measurementPeriodParameterName, LibraryEngine libraryEngine) {
        this.context = Objects.requireNonNull(context, "context is a required argument");
        this.libraryEngine = libraryEngine;
        this.measurementPeriodParameterName = Objects.requireNonNull(measurementPeriodParameterName, "measurementPeriodParameterName is a required argument");
    }

    public MeasureDef evaluate(MeasureDef measureDef, MeasureEvalType measureEvalType, List<String> subjectIds, @Nullable Interval measurementPeriod, VersionedIdentifier versionedIdentifier) {
        Objects.requireNonNull(measureDef, "measureDef is a required argument");
        Objects.requireNonNull(subjectIds, "subjectIds is a required argument");
        this.setMeasurementPeriod(measurementPeriod);
        ZonedDateTime zonedDateTime = MeasureEvaluator.getZonedTimeZoneForEval(measurementPeriod);
        switch (measureEvalType) {
            case PATIENT: 
            case SUBJECT: {
                return this.evaluate(measureDef, MeasureReportType.INDIVIDUAL, subjectIds, versionedIdentifier, zonedDateTime);
            }
            case SUBJECTLIST: {
                return this.evaluate(measureDef, MeasureReportType.SUBJECTLIST, subjectIds, versionedIdentifier, zonedDateTime);
            }
            case PATIENTLIST: {
                return this.evaluate(measureDef, MeasureReportType.PATIENTLIST, subjectIds, versionedIdentifier, zonedDateTime);
            }
            case POPULATION: {
                return this.evaluate(measureDef, MeasureReportType.SUMMARY, subjectIds, versionedIdentifier, zonedDateTime);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported Measure Evaluation type: %s", measureEvalType.getDisplay()));
    }

    @Nullable
    private static ZonedDateTime getZonedTimeZoneForEval(@Nullable Interval interval) {
        return Optional.ofNullable(interval).map(Interval::getLow).filter(DateTime.class::isInstance).map(DateTime.class::cast).map(DateTime::getZoneOffset).map(zoneOffset -> LocalDateTime.now().atOffset((ZoneOffset)zoneOffset).toZonedDateTime()).orElse(null);
    }

    protected ParameterDef getMeasurementPeriodParameterDef() {
        Library lib = this.context.getState().getCurrentLibrary();
        if (lib.getParameters() == null || lib.getParameters().getDef() == null || lib.getParameters().getDef().isEmpty()) {
            return null;
        }
        for (ParameterDef pd : lib.getParameters().getDef()) {
            if (this.measurementPeriodParameterName == null || !pd.getName().equals(this.measurementPeriodParameterName)) continue;
            return pd;
        }
        return null;
    }

    protected void setMeasurementPeriod(Interval measurementPeriod) {
        ParameterDef pd = this.getMeasurementPeriodParameterDef();
        if (pd == null) {
            logger.warn("Parameter \"{}\" was not found. Unable to validate type.", (Object)this.measurementPeriodParameterName);
            this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)measurementPeriod);
            return;
        }
        if (measurementPeriod == null && pd.getDefault() == null) {
            logger.warn("No default or value supplied for Parameter \"{}\". This may result in incorrect results or errors.", (Object)this.measurementPeriodParameterName);
            return;
        }
        if (measurementPeriod == null) {
            measurementPeriod = (Interval)this.context.getEvaluationVisitor().visitParameterDef(pd, (Object)this.context.getState());
            this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)MeasureEvaluator.cloneIntervalWithUtc(measurementPeriod));
            return;
        }
        IntervalTypeSpecifier intervalTypeSpecifier = (IntervalTypeSpecifier)pd.getParameterTypeSpecifier();
        if (intervalTypeSpecifier == null) {
            logger.debug("No ELM type information available. Unable to validate type of \"{}\"", (Object)this.measurementPeriodParameterName);
            this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)measurementPeriod);
            return;
        }
        NamedTypeSpecifier pointType = (NamedTypeSpecifier)intervalTypeSpecifier.getPointType();
        String targetType = pointType.getName().getLocalPart();
        Interval convertedPeriod = this.convertInterval(measurementPeriod, targetType);
        this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)convertedPeriod);
    }

    private static Interval cloneIntervalWithUtc(Interval interval) {
        Object startAsObject = interval.getStart();
        Object endAsObject = interval.getEnd();
        if (startAsObject instanceof DateTime && endAsObject instanceof DateTime) {
            return new Interval((Object)MeasureEvaluator.cloneDateTimeWithUtc((DateTime)startAsObject), true, (Object)MeasureEvaluator.cloneDateTimeWithUtc((DateTime)endAsObject), true);
        }
        return interval;
    }

    private static DateTime cloneDateTimeWithUtc(DateTime dateTime) {
        DateTime newDateTime = new DateTime(dateTime.getDateTime().withOffsetSameLocal(ZoneOffset.UTC));
        newDateTime.setPrecision(dateTime.getPrecision());
        return newDateTime;
    }

    protected Interval convertInterval(Interval interval, String targetType) {
        String sourceTypeQualified = interval.getPointType().getTypeName();
        String sourceType = sourceTypeQualified.substring(sourceTypeQualified.lastIndexOf(".") + 1, sourceTypeQualified.length());
        if (sourceType.equals(targetType)) {
            return interval;
        }
        if (sourceType.equals("DateTime") && targetType.equals("Date")) {
            logger.debug("A DateTime interval was provided and a Date interval was expected. The DateTime will be truncated.");
            return new Interval((Object)this.truncateDateTime((DateTime)interval.getLow()), interval.getLowClosed(), (Object)this.truncateDateTime((DateTime)interval.getHigh()), interval.getHighClosed());
        }
        throw new IllegalArgumentException(String.format("The interval type of %s did not match the expected type of %s and no conversion was possible.", sourceType, targetType));
    }

    protected Date truncateDateTime(DateTime dateTime) {
        OffsetDateTime odt = dateTime.getDateTime();
        return new Date(odt.getYear(), odt.getMonthValue(), odt.getDayOfMonth());
    }

    protected Pair<String, String> getSubjectTypeAndId(String subjectId) {
        if (subjectId.contains("/")) {
            String[] subjectIdParts = subjectId.split("/");
            return Pair.of((Object)subjectIdParts[0], (Object)subjectIdParts[1]);
        }
        throw new IllegalArgumentException(String.format("Unable to determine Subject type for id: %s. SubjectIds must be in the format {subjectType}/{subjectId} (e.g. Patient/123)", subjectId));
    }

    protected void captureEvaluatedResources(Set<Object> outEvaluatedResources) {
        if (outEvaluatedResources != null && this.context.getState().getEvaluatedResources() != null) {
            outEvaluatedResources.addAll(this.context.getState().getEvaluatedResources());
        }
        this.clearEvaluatedResources();
    }

    private void clearEvaluatedResources() {
        this.context.getState().clearEvaluatedResources();
    }

    protected MeasureDef evaluate(MeasureDef measureDef, MeasureReportType type, List<String> subjectIds, VersionedIdentifier id, ZonedDateTime zonedDateTime) {
        int subjectSize = subjectIds.size();
        logger.info("Evaluating Measure {}, report type {}, with {} subject(s)", new Object[]{measureDef.url(), type.toCode(), subjectSize});
        for (String subjectId : subjectIds) {
            if (subjectId == null) {
                throw new RuntimeException("SubjectId is required in order to calculate.");
            }
            Pair<String, String> subjectInfo = this.getSubjectTypeAndId(subjectId);
            String subjectTypePart = (String)subjectInfo.getLeft();
            String subjectIdPart = (String)subjectInfo.getRight();
            this.context.getState().setContextValue(subjectTypePart, (Object)subjectIdPart);
            EvaluationResult result = this.libraryEngine.getEvaluationResult(id, subjectId, null, null, null, null, zonedDateTime, this.context);
            this.evaluateSubject(measureDef, subjectTypePart, subjectIdPart, subjectSize, type, result);
        }
        return measureDef;
    }

    protected void evaluateSubject(MeasureDef measureDef, String subjectType, String subjectId, int populationSize, MeasureReportType reportType, EvaluationResult evaluationResult) {
        this.evaluateSdes(subjectId, measureDef.sdes(), evaluationResult);
        for (GroupDef groupDef : measureDef.groups()) {
            this.evaluateGroup(measureDef, groupDef, subjectType, subjectId, populationSize, reportType, evaluationResult);
        }
    }

    protected Iterable<Object> evaluatePopulationCriteria(String subjectType, ExpressionResult expressionResult, EvaluationResult evaluationResult, Set<Object> outEvaluatedResources) {
        if (expressionResult != null && !expressionResult.evaluatedResources().isEmpty()) {
            outEvaluatedResources.addAll(expressionResult.evaluatedResources());
        }
        if (expressionResult == null || expressionResult.value() == null) {
            return Collections.emptyList();
        }
        if (expressionResult.value() instanceof Boolean) {
            if (Boolean.TRUE.equals(expressionResult.value())) {
                Object booleanResult = evaluationResult.forExpression(subjectType).value();
                this.clearEvaluatedResources();
                return Collections.singletonList(booleanResult);
            }
            return Collections.emptyList();
        }
        return (Iterable)expressionResult.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateObservationCriteria(Object resource, String criteriaExpression, Set<Object> outEvaluatedResources, boolean isBooleanBasis) {
        Object result;
        ExpressionDef ed = Libraries.resolveExpressionRef((String)criteriaExpression, (Library)this.context.getState().getCurrentLibrary());
        if (!(ed instanceof FunctionDef)) {
            throw new IllegalArgumentException(String.format("Measure observation %s does not reference a function definition", criteriaExpression));
        }
        this.context.getState().pushWindow();
        try {
            if (!isBooleanBasis) {
                this.context.getState().push(new Variable().withName(((OperandDef)((FunctionDef)ed).getOperand().get(0)).getName()).withValue(resource));
            }
            result = this.context.getEvaluationVisitor().visitExpression(ed.getExpression(), (Object)this.context.getState());
        }
        finally {
            this.context.getState().popWindow();
        }
        this.captureEvaluatedResources(outEvaluatedResources);
        return result;
    }

    protected PopulationDef evaluatePopulationMembership(String subjectType, String subjectId, PopulationDef inclusionDef, EvaluationResult evaluationResult) {
        ExpressionResult matchingResult = evaluationResult.forExpression(inclusionDef.expression());
        int i = 0;
        for (Object resource : this.evaluatePopulationCriteria(subjectType, matchingResult, evaluationResult, inclusionDef.getEvaluatedResources())) {
            inclusionDef.addResource(resource);
            ++i;
        }
        if (i > 0) {
            inclusionDef.addSubject(subjectId);
        }
        return inclusionDef;
    }

    protected void evaluateProportion(MeasureDef measureDef, GroupDef groupDef, String subjectType, String subjectId, int populationSize, MeasureReportType reportType, EvaluationResult evaluationResult) {
        PopulationDef initialPopulation = groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION);
        PopulationDef numerator = groupDef.getSingle(MeasurePopulationType.NUMERATOR);
        PopulationDef denominator = groupDef.getSingle(MeasurePopulationType.DENOMINATOR);
        PopulationDef denominatorExclusion = groupDef.getSingle(MeasurePopulationType.DENOMINATOREXCLUSION);
        PopulationDef denominatorException = groupDef.getSingle(MeasurePopulationType.DENOMINATOREXCEPTION);
        PopulationDef numeratorExclusion = groupDef.getSingle(MeasurePopulationType.NUMERATOREXCLUSION);
        PopulationDef dateOfCompliance = groupDef.getSingle(MeasurePopulationType.DATEOFCOMPLIANCE);
        if (initialPopulation == null || denominator == null || numerator == null) {
            throw new NullPointerException("`" + MeasurePopulationType.INITIALPOPULATION.getDisplay() + "`, `" + MeasurePopulationType.NUMERATOR.getDisplay() + "`, `" + MeasurePopulationType.DENOMINATOR.getDisplay() + "` are required Population Definitions for Measure Scoring Type: " + groupDef.measureScoring().toCode());
        }
        if (groupDef.measureScoring().toCode().equals("ratio") && denominatorException != null) {
            throw new IllegalArgumentException("`" + MeasurePopulationType.DENOMINATOREXCEPTION.getDisplay() + "` are not permitted for MeasureScoring type: " + groupDef.measureScoring().toCode());
        }
        if ((initialPopulation = this.evaluatePopulationMembership(subjectType, subjectId, initialPopulation, evaluationResult)).getSubjects().contains(subjectId)) {
            denominator = this.evaluatePopulationMembership(subjectType, subjectId, denominator, evaluationResult);
            numerator = this.evaluatePopulationMembership(subjectType, subjectId, numerator, evaluationResult);
            PopulationDef totalDenominator = groupDef.getSingle(MeasurePopulationType.TOTALDENOMINATOR);
            PopulationDef totalNumerator = groupDef.getSingle(MeasurePopulationType.TOTALNUMERATOR);
            if (denominatorExclusion != null) {
                denominatorExclusion = this.evaluatePopulationMembership(subjectType, subjectId, denominatorExclusion, evaluationResult);
            }
            if (denominatorException != null) {
                denominatorException = this.evaluatePopulationMembership(subjectType, subjectId, denominatorException, evaluationResult);
            }
            if (numeratorExclusion != null) {
                numeratorExclusion = this.evaluatePopulationMembership(subjectType, subjectId, numeratorExclusion, evaluationResult);
            }
            if (measureDef.isBooleanBasis()) {
                if (denominatorExclusion != null) {
                    denominator.getSubjects().removeAll(denominatorExclusion.getSubjects());
                    denominator.getResources().removeAll(denominatorExclusion.getResources());
                    numerator.getSubjects().removeAll(denominatorExclusion.getSubjects());
                    numerator.getResources().removeAll(denominatorExclusion.getResources());
                }
                if (numeratorExclusion != null) {
                    numerator.getSubjects().removeAll(numeratorExclusion.getSubjects());
                    numerator.getResources().removeAll(numeratorExclusion.getResources());
                }
                if (denominatorException != null) {
                    denominatorException.getSubjects().removeAll(numerator.getSubjects());
                    denominatorException.getResources().removeAll(numerator.getResources());
                    denominator.getSubjects().removeAll(denominatorException.getSubjects());
                    denominator.getResources().removeAll(denominatorException.getResources());
                }
                totalDenominator.getSubjects().addAll(denominator.getSubjects());
                totalNumerator.getSubjects().addAll(numerator.getSubjects());
            } else {
                if (denominatorExclusion != null) {
                    denominator.getResources().removeAll(denominatorExclusion.getResources());
                    numerator.getResources().removeAll(denominatorExclusion.getResources());
                }
                if (numeratorExclusion != null) {
                    numerator.getResources().removeAll(numeratorExclusion.getResources());
                }
                if (denominatorException != null) {
                    denominatorException.getResources().removeAll(numerator.getResources());
                    denominator.getResources().removeAll(denominatorException.getResources());
                }
                totalDenominator.getResources().addAll(denominator.getResources());
                totalNumerator.getResources().addAll(numerator.getResources());
            }
            if (reportType.equals((Object)MeasureReportType.INDIVIDUAL) && populationSize == 1 && dateOfCompliance != null) {
                Object doc = this.evaluateDateOfCompliance(dateOfCompliance);
                dateOfCompliance.addResource(doc);
            }
        }
    }

    protected void evaluateContinuousVariable(MeasureDef measureDef, GroupDef groupDef, String subjectType, String subjectId, EvaluationResult evaluationResult) {
        PopulationDef initialPopulation = groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION);
        PopulationDef measurePopulation = groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATION);
        PopulationDef measureObservation = groupDef.getSingle(MeasurePopulationType.MEASUREOBSERVATION);
        PopulationDef measurePopulationExclusion = groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATIONEXCLUSION);
        if (initialPopulation == null || measurePopulation == null) {
            throw new NullPointerException("`" + MeasurePopulationType.INITIALPOPULATION.getDisplay() + "` & `" + MeasurePopulationType.MEASUREPOPULATION.getDisplay() + "` are required Population Definitions for Measure Scoring Type: " + groupDef.measureScoring().toCode());
        }
        if ((initialPopulation = this.evaluatePopulationMembership(subjectType, subjectId, initialPopulation, evaluationResult)).getSubjects().contains(subjectId)) {
            measurePopulation = this.evaluatePopulationMembership(subjectType, subjectId, measurePopulation, evaluationResult);
            if (measurePopulationExclusion != null) {
                measurePopulationExclusion = this.evaluatePopulationMembership(subjectType, subjectId, groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATIONEXCLUSION), evaluationResult);
            }
            if (measureDef.isBooleanBasis()) {
                if (measurePopulationExclusion != null) {
                    measurePopulation.getSubjects().removeAll(measurePopulationExclusion.getSubjects());
                    measurePopulation.getResources().removeAll(measurePopulationExclusion.getResources());
                }
            } else if (measurePopulationExclusion != null) {
                measurePopulation.getResources().removeAll(measurePopulationExclusion.getResources());
            }
            if (measureObservation != null) {
                for (Object resource : measurePopulation.getResources()) {
                    Object observationResult = this.evaluateObservationCriteria(resource, measureObservation.expression(), measureObservation.getEvaluatedResources(), measureDef.isBooleanBasis());
                    measureObservation.addResource(observationResult);
                }
            }
        }
    }

    protected void evaluateCohort(GroupDef groupDef, String subjectType, String subjectId, EvaluationResult evaluationResult) {
        PopulationDef initialPopulation = groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION);
        if (initialPopulation == null) {
            throw new NullPointerException("`" + MeasurePopulationType.INITIALPOPULATION.getDisplay() + "` is a required Population Definition for Measure Scoring Type: " + groupDef.measureScoring().toCode());
        }
        this.evaluatePopulationMembership(subjectType, subjectId, initialPopulation, evaluationResult);
    }

    protected void evaluateGroup(MeasureDef measureDef, GroupDef groupDef, String subjectType, String subjectId, int populationSize, MeasureReportType reportType, EvaluationResult evaluationResult) {
        this.evaluateStratifiers(subjectId, groupDef.stratifiers(), evaluationResult);
        MeasureScoring scoring = groupDef.measureScoring();
        switch (scoring) {
            case PROPORTION: 
            case RATIO: {
                this.evaluateProportion(measureDef, groupDef, subjectType, subjectId, populationSize, reportType, evaluationResult);
                break;
            }
            case CONTINUOUSVARIABLE: {
                this.evaluateContinuousVariable(measureDef, groupDef, subjectType, subjectId, evaluationResult);
                break;
            }
            case COHORT: {
                this.evaluateCohort(groupDef, subjectType, subjectId, evaluationResult);
            }
        }
    }

    protected Object evaluateDateOfCompliance(PopulationDef populationDef) {
        ExpressionDef ref = Libraries.resolveExpressionRef((String)populationDef.expression(), (Library)this.context.getState().getCurrentLibrary());
        return this.context.getEvaluationVisitor().visitExpressionDef(ref, this.context.getState());
    }

    protected void evaluateSdes(String subjectId, List<SdeDef> sdes, EvaluationResult evaluationResult) {
        for (SdeDef sde : sdes) {
            ExpressionResult expressionResult = evaluationResult.forExpression(sde.expression());
            Object result = expressionResult.value();
            if (result instanceof List && ((List)result).size() == 1 && ((List)result).get(0) == null) {
                result = null;
            }
            sde.putResult(subjectId, result, this.context.getState().getEvaluatedResources());
            this.clearEvaluatedResources();
        }
    }

    protected void evaluateStratifiers(String subjectId, List<StratifierDef> stratifierDefs, EvaluationResult evaluationResult) {
        for (StratifierDef sd : stratifierDefs) {
            if (!sd.components().isEmpty()) {
                throw new UnsupportedOperationException("multi-component stratifiers are not yet supported.");
            }
            ExpressionResult expressionResult = evaluationResult.forExpression(sd.expression());
            Object result = expressionResult.value();
            if (result instanceof Iterable) {
                Iterator resultIter = ((Iterable)result).iterator();
                result = !resultIter.hasNext() ? null : resultIter.next();
                if (resultIter.hasNext()) {
                    throw new IllegalArgumentException("stratifiers may not return multiple values");
                }
            }
            if (result != null) {
                sd.putResult(subjectId, result, this.context.getState().getEvaluatedResources());
            }
            this.clearEvaluatedResources();
        }
    }
}

