/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.cr.measure.enumeration.CareGapsStatusCode;

public class R4CareGapStatusEvaluator {
    public Map<String, CareGapsStatusCode> getGroupGapStatus(Measure measure, MeasureReport measureReport) {
        HashMap<String, CareGapsStatusCode> groupStatus = new HashMap<String, CareGapsStatusCode>();
        DateTimeType reportDate = measureReport.getDateElement();
        for (MeasureReport.MeasureReportGroupComponent group : measureReport.getGroup()) {
            String groupId = group.getId();
            CareGapsStatusCode gapStatus = this.getGapStatus(measure, group, reportDate);
            groupStatus.put(groupId, gapStatus);
        }
        return groupStatus;
    }

    private CareGapsStatusCode getGapStatus(Measure measure, MeasureReport.MeasureReportGroupComponent measureReportGroup, DateTimeType reportDate) {
        MutablePair inNumerator = new MutablePair((Object)"numerator", (Object)false);
        MutablePair inDenominator = new MutablePair((Object)"denominator", (Object)false);
        measureReportGroup.getPopulation().forEach(arg_0 -> R4CareGapStatusEvaluator.lambda$getGapStatus$0((Pair)inNumerator, (Pair)inDenominator, arg_0));
        boolean isPositive = true;
        if (this.groupHasImprovementNotation(measureReportGroup)) {
            isPositive = this.groupImprovementNotationIsPositive(measureReportGroup);
        } else if (measure.hasImprovementNotation()) {
            isPositive = measure.getImprovementNotation().hasCoding("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase");
        }
        if (Boolean.FALSE.equals(inDenominator.getValue())) {
            return CareGapsStatusCode.NOT_APPLICABLE;
        }
        if (Boolean.TRUE.equals(inDenominator.getValue()) && (isPositive && !((Boolean)inNumerator.getValue()).booleanValue() || !isPositive && ((Boolean)inNumerator.getValue()).booleanValue())) {
            return this.getOpenOrProspectiveStatus(measureReportGroup, reportDate);
        }
        return CareGapsStatusCode.CLOSED_GAP;
    }

    private CareGapsStatusCode getOpenOrProspectiveStatus(MeasureReport.MeasureReportGroupComponent measureReportGroup, DateTimeType reportDate) {
        if (this.hasDateOfComplianceExt(measureReportGroup)) {
            boolean reportWithinDOC;
            Period dateOfCompliance = this.getDateOfComplianceExt(measureReportGroup);
            boolean reportBeforeEndOfDOC = reportDate.before(dateOfCompliance.getEndElement());
            boolean reportAfterStartOfDOC = reportDate.after(dateOfCompliance.getStartElement());
            boolean reportBeforeStartOfDOC = reportDate.before(dateOfCompliance.getStartElement());
            boolean bl = reportWithinDOC = reportAfterStartOfDOC && reportBeforeEndOfDOC;
            if (reportWithinDOC || reportBeforeStartOfDOC) {
                return CareGapsStatusCode.PROSPECTIVE_GAP;
            }
        }
        return CareGapsStatusCode.OPEN_GAP;
    }

    private boolean hasDateOfComplianceExt(MeasureReport.MeasureReportGroupComponent measureReportGroup) {
        Extension ext = measureReportGroup.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression");
        return ext != null && !ext.getValue().isEmpty();
    }

    private Period getDateOfComplianceExt(MeasureReport.MeasureReportGroupComponent measureReportGroup) {
        Extension ext = measureReportGroup.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression");
        Type extValue = ext.getValue();
        assert (extValue instanceof Period);
        return (Period)extValue;
    }

    private boolean groupHasImprovementNotation(MeasureReport.MeasureReportGroupComponent groupComponent) {
        return groupComponent.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-improvementNotation") != null;
    }

    private boolean groupImprovementNotationIsPositive(MeasureReport.MeasureReportGroupComponent groupComponent) {
        CodeableConcept code = (CodeableConcept)groupComponent.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-improvementNotation").getValue();
        return code.hasCoding("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase");
    }

    private static /* synthetic */ void lambda$getGapStatus$0(Pair inNumerator, Pair inDenominator, MeasureReport.MeasureReportGroupPopulationComponent population) {
        if (population.hasCode() && population.getCode().hasCoding("http://terminology.hl7.org/CodeSystem/measure-population", (String)inNumerator.getKey()) && population.getCount() == 1) {
            inNumerator.setValue((Object)true);
        }
        if (population.hasCode() && population.getCode().hasCoding("http://terminology.hl7.org/CodeSystem/measure-population", (String)inDenominator.getKey()) && population.getCount() == 1) {
            inDenominator.setValue((Object)true);
        }
    }
}

