/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureProcessor;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.monad.Eithers;
import org.opencds.cqf.fhir.utility.r4.Parameters;

public class R4CollectDataService {
    private final Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;

    public R4CollectDataService(Repository repository, MeasureEvaluationOptions measureEvaluationOptions) {
        this.repository = repository;
        this.measureEvaluationOptions = measureEvaluationOptions;
    }

    public org.hl7.fhir.r4.model.Parameters collectData(IdType measureId, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String subject, String practitioner) {
        org.hl7.fhir.r4.model.Parameters parameters = new org.hl7.fhir.r4.model.Parameters();
        R4RepositorySubjectProvider subjectProvider = new R4RepositorySubjectProvider();
        R4MeasureProcessor processor = new R4MeasureProcessor(this.repository, this.measureEvaluationOptions, subjectProvider);
        List<String> subjectList = this.getSubjects(subject, practitioner, subjectProvider);
        if (!subjectList.isEmpty()) {
            for (String patient : subjectList) {
                List<String> subjects = Collections.singletonList(patient);
                this.addReports(processor, measureId, periodStart, periodEnd, subjects, parameters);
            }
        } else {
            this.addReports(processor, measureId, periodStart, periodEnd, subjectList, parameters);
        }
        return parameters;
    }

    private void addReports(R4MeasureProcessor processor, IdType measureId, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, List<String> subjects, org.hl7.fhir.r4.model.Parameters parameters) {
        MeasureReport report = processor.evaluateMeasure((Either3<CanonicalType, IdType, Measure>)Eithers.forMiddle3((Object)measureId), periodStart, periodEnd, MeasureEvalType.SUBJECT.toCode(), subjects, null, null, null);
        report.setType(MeasureReport.MeasureReportType.DATACOLLECTION);
        report.setGroup(null);
        String subjectId = null;
        subjectId = !subjects.isEmpty() ? subjects.get(0).replace("Patient/", "") : "no-subjectId";
        parameters.addParameter(Parameters.part((String)("measureReport-" + subjectId), (Resource)report, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (!report.getEvaluatedResource().isEmpty()) {
            this.populateEvaluatedResources(report, parameters, subjectId);
        }
    }

    private List<String> getSubjects(String subject, String practitioner, R4RepositorySubjectProvider subjectProvider) {
        if (StringUtils.isNotBlank((CharSequence)practitioner)) {
            if (!practitioner.contains("/")) {
                practitioner = "Practitioner/".concat(practitioner);
            }
            subject = practitioner;
        }
        return subjectProvider.getSubjects(this.repository, MeasureEvalType.SUBJECT, subject).collect(Collectors.toList());
    }

    protected void populateEvaluatedResources(MeasureReport measureReport, org.hl7.fhir.r4.model.Parameters parameters, String subject) {
        measureReport.getEvaluatedResource().forEach(evaluatedResource -> {
            IIdType resourceId = evaluatedResource.getReferenceElement();
            if (resourceId.getResourceType() == null) {
                return;
            }
            Ids.simple((IIdType)resourceId);
            Class resourceType = ((IBaseResource)this.repository.fhirContext().getResourceDefinition(resourceId.getResourceType()).newInstance()).getClass();
            IBaseResource resource = this.repository.read(resourceType, resourceId);
            if (resource instanceof Resource) {
                Resource resourceBase = (Resource)resource;
                parameters.addParameter(Parameters.part((String)("resource-" + subject), (Resource)resourceBase, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
            }
        });
    }
}

