/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Quantity;
import org.opencds.cqf.fhir.cr.measure.common.BaseMeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;

public class R4MeasureReportScorer
extends BaseMeasureReportScorer<MeasureReport> {
    @Override
    public void score(MeasureDef measureDef, MeasureReport measureReport) {
        if (measureDef == null) {
            throw new IllegalArgumentException("MeasureDef is required in order to score a Measure.");
        }
        if (measureReport.getGroup().isEmpty()) {
            return;
        }
        for (MeasureReport.MeasureReportGroupComponent mrgc : measureReport.getGroup()) {
            this.scoreGroup(this.getGroupMeasureScoring(mrgc, measureDef), mrgc, this.getGroupDef(measureDef, mrgc).isPositiveImprovementNotation());
        }
    }

    protected GroupDef getGroupDef(MeasureDef measureDef, MeasureReport.MeasureReportGroupComponent mrgc) {
        List<GroupDef> groupDefs = measureDef.groups();
        if (groupDefs.size() == 1) {
            return groupDefs.get(0);
        }
        return groupDefs.stream().filter(t -> t.id().equals(mrgc.getId())).findFirst().orElse(null);
    }

    protected MeasureScoring checkMissingScoringType(MeasureScoring measureScoring) {
        if (measureScoring == null) {
            throw new IllegalArgumentException("Measure does not have a scoring methodology defined. Add a \"scoring\" property to the measure definition or the group definition.");
        }
        return measureScoring;
    }

    protected void groupHasValidId(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Measure resources with more than one group component require a unique group.id() defined to score appropriately.");
        }
    }

    protected MeasureScoring getGroupMeasureScoring(MeasureReport.MeasureReportGroupComponent mrgc, MeasureDef measureDef) {
        MeasureScoring groupScoringType = null;
        if (measureDef.groups().size() == 1) {
            groupScoringType = measureDef.groups().get(0).measureScoring();
        } else {
            for (GroupDef groupDef : measureDef.groups()) {
                MeasureScoring groupDefMeasureScoring = groupDef.measureScoring();
                this.groupHasValidId(mrgc.getId());
                this.groupHasValidId(groupDef.id());
                if (!groupDef.id().equals(mrgc.getId())) continue;
                groupScoringType = groupDefMeasureScoring;
            }
        }
        return this.checkMissingScoringType(groupScoringType);
    }

    protected void scoreGroup(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupComponent mrgc, boolean isIncreaseImprovementNotation) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getGroupExtensionCount(mrgc, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-numerator-membership"), this.getGroupExtensionCount(mrgc, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-denominator-membership"));
                if (score == null) break;
                if (isIncreaseImprovementNotation) {
                    mrgc.setMeasureScore(new Quantity(score.doubleValue()));
                    break;
                }
                mrgc.setMeasureScore(new Quantity(1.0 - score));
                break;
            }
        }
        for (MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent : mrgc.getStratifier()) {
            this.scoreStratifier(measureScoring, stratifierComponent);
        }
    }

    protected void scoreStratum(MeasureScoring measureScoring, MeasureReport.StratifierGroupComponent stratum) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getStratumPopulationCount(stratum, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-numerator-membership"), this.getStratumPopulationCount(stratum, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-denominator-membership"));
                if (score == null) break;
                stratum.setMeasureScore(new Quantity(score.doubleValue()));
                break;
            }
        }
    }

    protected Integer getGroupExtensionCount(MeasureReport.MeasureReportGroupComponent mrgc, String extUrl) {
        Optional<Extension> ext = mrgc.getExtension().stream().filter(x -> x.getUrl().equals(extUrl)).findFirst();
        return ext.map(extension -> Integer.valueOf(extension.getValue().toString())).orElse(null);
    }

    protected Integer getStratumPopulationCount(MeasureReport.StratifierGroupComponent sgc, String extUrl) {
        List pop = sgc.getExtension();
        Extension ext = pop.stream().filter(x -> x.getUrl().equals(extUrl)).findFirst().orElse(null);
        if (ext != null) {
            return Integer.valueOf(ext.getValue().toString());
        }
        return null;
    }

    protected void scoreStratifier(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent) {
        for (MeasureReport.StratifierGroupComponent sgc : stratifierComponent.getStratum()) {
            this.scoreStratum(measureScoring, sgc);
        }
    }
}

