/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.opencds.cqf.fhir.cr.questionnaire.populate.IPopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItem;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItemWithContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateProcessor
implements IPopulateProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(PopulateProcessor.class);
    private final ProcessItem processItem;
    private final ProcessItemWithContext processItemWithContext;

    public PopulateProcessor() {
        this(new ProcessItem(), new ProcessItemWithContext());
    }

    private PopulateProcessor(ProcessItem processItem, ProcessItemWithContext processItemWithExtension) {
        this.processItem = processItem;
        this.processItemWithContext = processItemWithExtension;
    }

    @Override
    public IBaseResource populate(PopulateRequest request) {
        logger.info("Performing $populate operation on Questionnaire/{}", (Object)request.getQuestionnaire().getIdElement().getIdPart());
        return this.processResponse(request, this.processItems(request, request.getItems((IBase)request.getQuestionnaire())));
    }

    @Override
    public IBaseResource processResponse(PopulateRequest request, List<IBaseBackboneElement> items) {
        IBaseResource response = this.createQuestionnaireResponse(request);
        response.setId(request.getQuestionnaire().getIdElement().getIdPart() + "-" + request.getSubjectId().getIdPart());
        request.getModelResolver().setValue((Object)response, "item", items);
        request.resolveOperationOutcome(response);
        request.getModelResolver().setValue((Object)response, "contained", Collections.singletonList(request.getQuestionnaire()));
        logger.info("$populate operation completed");
        return response;
    }

    public List<IBaseBackboneElement> processItems(PopulateRequest request, List<IBaseBackboneElement> items) {
        ArrayList<IBaseBackboneElement> responseItems = new ArrayList<IBaseBackboneElement>();
        items.forEach(item -> {
            logger.info("Processing item {}", (Object)request.getItemLinkId((IBaseBackboneElement)item));
            IBaseExtension populationContextExt = item.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext")).findFirst().orElse(null);
            if (populationContextExt != null) {
                responseItems.addAll(this.processItemWithContext(request, (IBaseBackboneElement)item));
            } else {
                List<IBaseBackboneElement> childItems = request.getItems((IBase)item);
                if (!childItems.isEmpty()) {
                    IBaseBackboneElement responseItem = this.processItem.createResponseItem(request.getFhirVersion(), (IBaseBackboneElement)item);
                    List<IBaseBackboneElement> responseChildItems = this.processItems(request, childItems);
                    request.getModelResolver().setValue((Object)responseItem, "item", responseChildItems);
                    responseItems.add(responseItem);
                } else {
                    IBaseBackboneElement responseItem = this.processItem(request, (IBaseBackboneElement)item);
                    responseItems.add(responseItem);
                }
            }
        });
        return responseItems;
    }

    protected List<IBaseBackboneElement> processItemWithContext(PopulateRequest request, IBaseBackboneElement item) {
        try {
            return this.processItemWithContext.processContextItem(request, item);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            return new ArrayList<IBaseBackboneElement>();
        }
    }

    protected IBaseBackboneElement processItem(PopulateRequest request, IBaseBackboneElement item) {
        try {
            return this.processItem.processItem(request, item);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            return this.processItem.createResponseItem(request.getFhirVersion(), item);
        }
    }

    protected IBaseResource createQuestionnaireResponse(PopulateRequest request) {
        switch (request.getFhirVersion()) {
            case R4: {
                return new org.hl7.fhir.r4.model.QuestionnaireResponse().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS).setQuestionnaire("#" + ((Questionnaire)request.getQuestionnaire()).getIdPart()).setSubject(new org.hl7.fhir.r4.model.Reference(request.getSubjectId()));
            }
            case R5: {
                return new QuestionnaireResponse().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS).setQuestionnaire("#" + ((org.hl7.fhir.r5.model.Questionnaire)request.getQuestionnaire()).getIdPart()).setSubject(new Reference(request.getSubjectId()));
            }
        }
        return null;
    }
}

