/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.CodeMap;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.IExtractProcessor;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ItemPair;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ProcessDefinitionItem;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ProcessItem;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ResponseBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractProcessor
implements IExtractProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(ExtractProcessor.class);
    protected final ProcessItem itemProcessor;
    protected final ProcessDefinitionItem definitionItemProcessor;

    public ExtractProcessor() {
        this(new ProcessItem(), new ProcessDefinitionItem());
    }

    private ExtractProcessor(ProcessItem processItem, ProcessDefinitionItem processDefinitionItem) {
        this.itemProcessor = processItem;
        this.definitionItemProcessor = processDefinitionItem;
    }

    @Override
    public IBaseBundle extract(ExtractRequest request) {
        List<IBaseResource> resources = this.processItems(request);
        return this.createBundle(request, resources);
    }

    @Override
    public List<IBaseResource> processItems(ExtractRequest request) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        IBaseReference subject = (IBaseReference)request.resolvePath((IBase)request.getQuestionnaireResponse(), "subject");
        IBaseExtension<?, ?> extractionContextExt = request.getItemExtractionContext();
        if (extractionContextExt != null) {
            this.processDefinitionItem(request, new ItemPair(null, null), resources, subject);
        } else {
            Map<String, List<IBaseCoding>> questionnaireCodeMap = CodeMap.create(request);
            request.getItems((IBase)request.getQuestionnaireResponse()).forEach(item -> {
                IBaseBackboneElement questionnaireItem = request.getQuestionnaireItem((IBaseBackboneElement)item);
                ItemPair itemPair = new ItemPair(questionnaireItem, (IBaseBackboneElement)item);
                if (!request.getItems((IBase)item).isEmpty()) {
                    this.processGroupItem(request, itemPair, questionnaireCodeMap, resources, subject);
                } else {
                    this.processItem(request, itemPair, questionnaireCodeMap, resources, subject);
                }
            });
        }
        return resources;
    }

    protected IBaseBundle createBundle(ExtractRequest request, List<IBaseResource> resources) {
        switch (request.getFhirVersion()) {
            case R4: {
                return ResponseBundle.createBundleR4(request.getExtractId(), resources);
            }
            case R5: {
                return ResponseBundle.createBundleR5(request.getExtractId(), resources);
            }
        }
        return null;
    }

    protected void processGroupItem(ExtractRequest request, ItemPair item, Map<String, List<IBaseCoding>> questionnaireCodeMap, List<IBaseResource> resources, IBaseReference subject) {
        IBaseReference groupSubject;
        List subjectItems = request.getItems((IBase)item.getResponseItem()).stream().filter(child -> child.getExtension().stream().anyMatch(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse-isSubject"))).collect(Collectors.toList());
        IBaseReference iBaseReference = groupSubject = !subjectItems.isEmpty() ? (IBaseReference)request.resolvePath((IBase)request.resolvePathList((IBase)subjectItems.get(0), "answer", IBaseBackboneElement.class).get(0), "value") : (IBaseReference)SerializationUtils.clone((Serializable)subject);
        if (request.isDefinitionItem(item)) {
            this.processDefinitionItem(request, item, resources, groupSubject);
        } else {
            request.getItems((IBase)item.getResponseItem()).forEach(childResponseItem -> {
                if (childResponseItem.getExtension().stream().noneMatch(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse-isSubject"))) {
                    ItemPair childItem = new ItemPair(request.getQuestionnaireItem((IBaseBackboneElement)childResponseItem, request.getItems((IBase)item.getItem())), (IBaseBackboneElement)childResponseItem);
                    if (!request.getItems((IBase)childResponseItem).isEmpty()) {
                        this.processGroupItem(request, childItem, questionnaireCodeMap, resources, groupSubject);
                    } else {
                        this.processObservationItem(request, childItem, questionnaireCodeMap, resources, groupSubject);
                    }
                }
            });
        }
    }

    protected void processItem(ExtractRequest request, ItemPair item, Map<String, List<IBaseCoding>> questionnaireCodeMap, List<IBaseResource> resources, IBaseReference subject) {
        if (request.isDefinitionItem(item)) {
            this.processDefinitionItem(request, item, resources, subject);
        } else {
            this.processObservationItem(request, item, questionnaireCodeMap, resources, subject);
        }
    }

    protected void processObservationItem(ExtractRequest request, ItemPair item, Map<String, List<IBaseCoding>> questionnaireCodeMap, List<IBaseResource> resources, IBaseReference subject) {
        try {
            this.itemProcessor.processItem(request, item.getResponseItem(), item.getItem(), questionnaireCodeMap, resources, subject);
        }
        catch (Exception e) {
            request.logException(e.getMessage());
            throw e;
        }
    }

    protected void processDefinitionItem(ExtractRequest request, ItemPair item, List<IBaseResource> resources, IBaseReference subject) {
        try {
            this.definitionItemProcessor.processDefinitionItem(request, item, resources, subject);
        }
        catch (Exception e) {
            request.logException(e.getMessage());
            throw e;
        }
    }
}

