/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.elm.requirements.fhir.DataRequirementsProcessor;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.conv30_50.VersionConvertor_30_50;
import org.hl7.fhir.convertors.conv40_50.VersionConvertor_40_50;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.cql2elm.content.RepositoryFhirLibrarySourceProvider;
import org.opencds.cqf.fhir.cql.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlFhirParametersConverter;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Libraries;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.LibraryAdapter;
import org.opencds.cqf.fhir.utility.visitor.IKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.utility.visitor.VisitorHelper;

public class DataRequirementsVisitor
implements IKnowledgeArtifactVisitor {
    protected DataRequirementsProcessor dataRequirementsProcessor = new DataRequirementsProcessor();
    protected EvaluationSettings evaluationSettings;

    public DataRequirementsVisitor(EvaluationSettings evaluationSettings) {
        this.evaluationSettings = evaluationSettings;
    }

    public IBase visit(KnowledgeArtifactAdapter adapter, Repository repository, IBaseParameters drParameters) {
        LibraryAdapter library;
        FhirVersionEnum fhirVersion = adapter.get().getStructureFhirVersionEnum();
        Optional parameters = VisitorHelper.getResourceParameter((String)"parameters", (IBaseParameters)drParameters, IBaseParameters.class);
        List artifactVersion = VisitorHelper.getListParameter((String)"artifactVersion", (IBaseParameters)drParameters, IPrimitiveType.class).map(l -> l.stream().map(t -> (String)t.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        List checkArtifactVersion = VisitorHelper.getListParameter((String)"checkArtifactVersion", (IBaseParameters)drParameters, IPrimitiveType.class).map(l -> l.stream().map(t -> (String)t.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        List forceArtifactVersion = VisitorHelper.getListParameter((String)"forceArtifactVersion", (IBaseParameters)drParameters, IPrimitiveType.class).map(l -> l.stream().map(t -> (String)t.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        IBaseResource primaryLibrary = adapter.getPrimaryLibrary(repository);
        if (primaryLibrary != null) {
            LibraryManager libraryManager = this.createLibraryManager(repository);
            CqlTranslator translator = this.translateLibrary(primaryLibrary, libraryManager);
            CqlFhirParametersConverter cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter((FhirContext)repository.fhirContext());
            Map evaluationParameters = parameters.isPresent() ? cqlFhirParametersConverter.toCqlParameters((IBaseParameters)parameters.get()) : null;
            Library r5Library = this.dataRequirementsProcessor.gatherDataRequirements(libraryManager, translator.getTranslatedLibrary(), this.evaluationSettings.getCqlOptions().getCqlCompilerOptions(), null, evaluationParameters, true, true);
            library = this.convertAndCreateAdapter(fhirVersion, r5Library);
        } else {
            library = AdapterFactory.forFhirContext((FhirContext)repository.fhirContext()).createLibrary((IBaseResource)repository.fhirContext().getResourceDefinition("Library").newInstance());
            library.setName("EffectiveDataRequirements");
            library.setStatus(adapter.getStatus());
            library.setType("module-definition");
        }
        HashSet<String> gatheredResources = new HashSet<String>();
        List relatedArtifacts = this.stripInvalid(library);
        this.recursiveGather(adapter.get(), gatheredResources, relatedArtifacts, repository, forceArtifactVersion, forceArtifactVersion, artifactVersion, checkArtifactVersion, forceArtifactVersion);
        library.setRelatedArtifact(relatedArtifacts);
        return library.get();
    }

    private <T extends ICompositeType & IBaseHasExtensions> List<T> stripInvalid(LibraryAdapter library) {
        return library.getRelatedArtifact().stream().filter(r -> {
            IBase resourcePath = library.resolvePath((IBase)r, "resource");
            String reference = library.fhirContext().getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3) ? ((Reference)resourcePath).getReference() : (String)((IPrimitiveType)resourcePath).getValue();
            return reference.split("/").length > 2;
        }).map(r -> r).collect(Collectors.toList());
    }

    private LibraryAdapter convertAndCreateAdapter(FhirVersionEnum fhirVersion, Library r5Library) {
        AdapterFactory adapterFactory = AdapterFactory.forFhirVersion((FhirVersionEnum)fhirVersion);
        switch (fhirVersion) {
            case DSTU3: {
                VersionConvertor_30_50 versionConvertor3050 = new VersionConvertor_30_50(new BaseAdvisor_30_50());
                return adapterFactory.createLibrary((IBaseResource)versionConvertor3050.convertResource((Resource)r5Library));
            }
            case R4: {
                VersionConvertor_40_50 versionConvertor4050 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
                return adapterFactory.createLibrary((IBaseResource)versionConvertor4050.convertResource((Resource)r5Library));
            }
            case R5: {
                return adapterFactory.createLibrary((IBaseResource)r5Library);
            }
        }
        throw new IllegalArgumentException(String.format("FHIR version %s is not supported.", fhirVersion.toString()));
    }

    protected CqlTranslator getTranslator(InputStream cqlStream, LibraryManager libraryManager) {
        CqlTranslator translator;
        try {
            translator = CqlTranslator.fromStream((InputStream)cqlStream, (LibraryManager)libraryManager);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Errors occurred translating library: %s", e.getMessage()));
        }
        return translator;
    }

    protected CqlTranslator translateLibrary(IBaseResource library, LibraryManager libraryManager) {
        CqlTranslator translator = this.getTranslator(new ByteArrayInputStream((byte[])Libraries.getContent((IBaseResource)library, (String)"text/cql").get()), libraryManager);
        if (!translator.getErrors().isEmpty()) {
            throw new IllegalArgumentException(((CqlCompilerException)translator.getErrors().get(0)).getMessage());
        }
        return translator;
    }

    protected static LibrarySourceProvider buildLibrarySource(Repository repository) {
        AdapterFactory adapterFactory = AdapterFactory.forFhirContext((FhirContext)repository.fhirContext());
        return new RepositoryFhirLibrarySourceProvider(repository, adapterFactory, new LibraryVersionSelector(adapterFactory));
    }

    protected LibraryManager createLibraryManager(Repository repository) {
        LibrarySourceProvider librarySourceProvider = DataRequirementsVisitor.buildLibrarySource(repository);
        ArrayList<LibrarySourceProvider> sourceProviders = new ArrayList<LibrarySourceProvider>(Arrays.asList(librarySourceProvider, librarySourceProvider));
        ModelManager modelManager = this.evaluationSettings.getModelCache() != null ? new ModelManager(this.evaluationSettings.getModelCache()) : new ModelManager();
        LibraryManager libraryManager = new LibraryManager(modelManager, this.evaluationSettings.getCqlOptions().getCqlCompilerOptions(), this.evaluationSettings.getLibraryCache());
        libraryManager.getLibrarySourceLoader().clearProviders();
        for (LibrarySourceProvider provider : sourceProviders) {
            libraryManager.getLibrarySourceLoader().registerProvider(provider);
        }
        return libraryManager;
    }

    protected <T extends ICompositeType & IBaseHasExtensions> void recursiveGather(IDomainResource resource, Set<String> gatheredResources, List<T> relatedArtifacts, Repository repository, List<String> capability, List<String> include, List<String> artifactVersion, List<String> checkArtifactVersion, List<String> forceArtifactVersion) throws PreconditionFailedException {
        if (resource == null) {
            return;
        }
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        KnowledgeArtifactAdapter adapter = AdapterFactory.forFhirVersion((FhirVersionEnum)fhirVersion).createKnowledgeArtifactAdapter(resource);
        if (!gatheredResources.contains(adapter.getCanonical())) {
            gatheredResources.add(adapter.getCanonical());
            VisitorHelper.findUnsupportedCapability((KnowledgeArtifactAdapter)adapter, capability);
            VisitorHelper.processCanonicals((KnowledgeArtifactAdapter)adapter, artifactVersion, checkArtifactVersion, forceArtifactVersion);
            String reference = adapter.hasVersion() ? adapter.getUrl().concat(String.format("|%s", adapter.getVersion())) : adapter.getUrl();
            boolean addArtifact = relatedArtifacts.stream().noneMatch(ra -> KnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)ra).equals(reference));
            if (addArtifact) {
                relatedArtifacts.add(KnowledgeArtifactAdapter.newRelatedArtifact((FhirVersionEnum)fhirVersion, (String)"depends-on", (String)reference, (String)adapter.getDescriptor()));
            }
            adapter.combineComponentsAndDependencies().stream().filter(ra -> StringUtils.isNotBlank((CharSequence)ra.getReference()) && StringUtils.isNotBlank((CharSequence)Canonicals.getResourceType((String)ra.getReference()))).filter(ra -> {
                try {
                    RuntimeResourceDefinition resourceDef = repository.fhirContext().getResourceDefinition(Canonicals.getResourceType((String)ra.getReference()));
                    return resourceDef != null;
                }
                catch (DataFormatException e) {
                    if (e.getMessage().contains("1684")) {
                        return false;
                    }
                    throw new DataFormatException(e.getMessage());
                }
            }).map(ra -> SearchHelper.searchRepositoryByCanonicalWithPaging((Repository)repository, (String)ra.getReference())).map(searchBundle -> (IDomainResource)BundleHelper.getEntryResourceFirstRep((IBaseBundle)searchBundle)).forEach(component -> this.recursiveGather((IDomainResource)component, gatheredResources, relatedArtifacts, repository, capability, include, artifactVersion, checkArtifactVersion, forceArtifactVersion));
        }
    }
}

