/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CanonicalType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.opencds.cqf.fhir.cr.inputparameters.IInputParameterResolver;
import org.opencds.cqf.fhir.utility.adapter.QuestionnaireAdapter;

public class ApplyRequest
implements ICpgRequest {
    private final IBaseResource activityDefinition;
    private final IIdType subjectId;
    private final IIdType encounterId;
    private final IIdType practitionerId;
    private final IIdType organizationId;
    private final IBaseDatatype userType;
    private final IBaseDatatype userLanguage;
    private final IBaseDatatype userTaskContext;
    private final IBaseDatatype setting;
    private final IBaseDatatype settingContext;
    private final IBaseParameters parameters;
    private final Boolean useServerData;
    private final IBaseBundle data;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final String defaultLibraryUrl;
    private final IInputParameterResolver inputParameterResolver;
    private IBaseOperationOutcome operationOutcome;

    public ApplyRequest(IBaseResource activityDefinition, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IIdType organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, boolean useServerData, IBaseBundle data, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)activityDefinition, (Object)"expected non-null value for activityDefinition");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.activityDefinition = activityDefinition;
        this.subjectId = subjectId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        this.organizationId = organizationId;
        this.userType = userType;
        this.userLanguage = userLanguage;
        this.userTaskContext = userTaskContext;
        this.setting = setting;
        this.settingContext = settingContext;
        this.parameters = parameters;
        this.useServerData = useServerData;
        this.data = data;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.fhirVersion = activityDefinition.getStructureFhirVersionEnum();
        this.defaultLibraryUrl = this.resolveDefaultLibraryUrl();
        this.inputParameterResolver = IInputParameterResolver.createResolver(libraryEngine.getRepository(), this.subjectId, this.encounterId, this.practitionerId, this.parameters, this.useServerData, this.data);
    }

    public IBaseResource getActivityDefinition() {
        return this.activityDefinition;
    }

    @Override
    public String getOperationName() {
        return "apply";
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IIdType getPractitionerId() {
        return this.practitionerId;
    }

    @Override
    public IIdType getEncounterId() {
        return this.encounterId;
    }

    @Override
    public IIdType getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public IBaseDatatype getUserType() {
        return this.userType;
    }

    @Override
    public IBaseDatatype getUserLanguage() {
        return this.userLanguage;
    }

    @Override
    public IBaseDatatype getUserTaskContext() {
        return this.userTaskContext;
    }

    @Override
    public IBaseDatatype getSetting() {
        return this.setting;
    }

    @Override
    public IBaseDatatype getSettingContext() {
        return this.settingContext;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public boolean getUseServerData() {
        return this.useServerData;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.inputParameterResolver.getParameters();
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    protected final String resolveDefaultLibraryUrl() {
        switch (this.fhirVersion) {
            case DSTU3: {
                return ((org.hl7.fhir.dstu3.model.ActivityDefinition)this.activityDefinition).hasLibrary() ? ((Reference)((org.hl7.fhir.dstu3.model.ActivityDefinition)this.activityDefinition).getLibrary().get(0)).getReference() : null;
            }
            case R4: {
                return ((ActivityDefinition)this.activityDefinition).hasLibrary() ? ((CanonicalType)((ActivityDefinition)this.activityDefinition).getLibrary().get(0)).getValueAsString() : null;
            }
            case R5: {
                return ((org.hl7.fhir.r5.model.ActivityDefinition)this.activityDefinition).hasLibrary() ? ((org.hl7.fhir.r5.model.CanonicalType)((org.hl7.fhir.r5.model.ActivityDefinition)this.activityDefinition).getLibrary().get(0)).getValueAsString() : null;
            }
        }
        return null;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return null;
    }

    @Override
    public QuestionnaireAdapter getQuestionnaireAdapter() {
        return null;
    }
}

