/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import java.util.Collections;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.Type;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class CommunicationResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public CommunicationResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public Communication resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        Communication communication = new Communication();
        communication.setStatus(Communication.CommunicationStatus.UNKNOWN);
        communication.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasCode()) {
            communication.setReasonCode(Collections.singletonList(this.activityDefinition.getCode()));
        }
        if (this.activityDefinition.hasRelatedArtifact()) {
            for (RelatedArtifact artifact : this.activityDefinition.getRelatedArtifact()) {
                if (!artifact.hasUrl()) continue;
                Attachment attachment = new Attachment().setUrl(artifact.getUrl());
                if (artifact.hasDisplay()) {
                    attachment.setTitle(artifact.getDisplay());
                }
                Communication.CommunicationPayloadComponent payload = new Communication.CommunicationPayloadComponent();
                payload.setContent((Type)(artifact.hasDisplay() ? attachment.setTitle(artifact.getDisplay()) : attachment));
                communication.setPayload(Collections.singletonList(payload));
            }
        }
        return communication;
    }
}

