/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r5;

import com.google.common.base.Preconditions;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class CommunicationRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public CommunicationRequestResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public CommunicationRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        CommunicationRequest communicationRequest = new CommunicationRequest();
        communicationRequest.setStatus(Enumerations.RequestStatus.DRAFT);
        communicationRequest.setSubject(new Reference(request.getSubjectId()));
        if (request.hasEncounterId()) {
            communicationRequest.setEncounter(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            communicationRequest.setRequester(new Reference(request.getPractitionerId()));
        }
        if (this.activityDefinition.hasDoNotPerform()) {
            communicationRequest.setDoNotPerform(this.activityDefinition.getDoNotPerform());
        }
        if (this.activityDefinition.hasCode()) {
            communicationRequest.addPayload().setContent((DataType)this.activityDefinition.getCode());
        }
        return communicationRequest;
    }
}

