/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.visitor.PackageVisitor;

public class PackageProcessor
implements IPackageProcessor {
    protected final Repository repository;
    protected final FhirVersionEnum fhirVersion;
    protected final PackageVisitor packageVisitor;

    public PackageProcessor(Repository repository) {
        this.repository = repository;
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.packageVisitor = new PackageVisitor(this.repository.fhirContext());
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource) {
        return this.packageResource(resource, "POST");
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource, String method) {
        return this.packageResource(resource, Parameters.newParameters((FhirContext)this.repository.fhirContext(), (String)"package-parameters", (IBase[])new IBase[]{Parameters.newBooleanPart((FhirContext)this.repository.fhirContext(), (String)"isPut", (boolean)method.equals("PUT"), (IBase[])new IBase[0])}));
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource, IBaseParameters parameters) {
        return (IBaseBundle)this.packageVisitor.visit(AdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion).createKnowledgeArtifactAdapter((IDomainResource)resource), this.repository, parameters);
    }
}

