/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.inputparameters.r5;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.inputparameters.BaseInputParameterResolver;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Constants;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputParameterResolver
extends BaseInputParameterResolver {
    private static final Logger logger = LoggerFactory.getLogger(InputParameterResolver.class);
    private final Parameters parameters;

    public InputParameterResolver(Repository repository, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> context, List<IBaseExtension<?, ?>> launchContext) {
        super(repository, subjectId, encounterId, practitionerId, useServerData, data);
        this.parameters = this.resolveParameters(parameters, context, launchContext);
    }

    protected final Parameters resolveParameters(IBaseParameters baseParameters, List<? extends IBaseBackboneElement> context, List<IBaseExtension<?, ?>> launchContext) {
        Practitioner practitioner;
        Encounter encounter;
        Class subjectClass;
        Object subject;
        Parameters params = org.opencds.cqf.fhir.utility.r5.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
        if (baseParameters != null) {
            params.getParameter().addAll(((Parameters)baseParameters).getParameter());
        }
        if ((subject = this.readRepository(subjectClass = this.fhirContext().getResourceDefinition(this.subjectId.getResourceType()).getImplementingClass(), this.subjectId)) != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"%subject", (Resource)((Resource)subject), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.encounterId != null && !this.encounterId.isEmpty() && (encounter = this.readRepository(Encounter.class, this.encounterId)) != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"%encounter", (Resource)encounter, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.practitionerId != null && !this.practitionerId.isEmpty() && (practitioner = this.readRepository(Practitioner.class, this.practitionerId)) != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"%practitioner", (Resource)practitioner, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (launchContext != null && !launchContext.isEmpty()) {
            this.resolveLaunchContext(params, context, launchContext);
        }
        return params;
    }

    protected boolean validateContext(Constants.SDC_QUESTIONNAIRE_LAUNCH_CONTEXT_CODE code, String type) {
        switch (code) {
            case PATIENT: {
                return type.equals(ResourceType.Patient.name());
            }
            case ENCOUNTER: {
                return type.equals(ResourceType.Encounter.name());
            }
            case LOCATION: {
                return type.equals(ResourceType.Location.name());
            }
            case USER: {
                return type.equals(ResourceType.Patient.name()) || type.equals(ResourceType.Practitioner.name()) || type.equals(ResourceType.PractitionerRole.name()) || type.equals(ResourceType.RelatedPerson.name());
            }
            case STUDY: {
                return type.equals(ResourceType.ResearchStudy.name());
            }
        }
        return false;
    }

    protected void resolveLaunchContext(Parameters params, List<? extends IBaseBackboneElement> contexts, List<IBaseExtension<?, ?>> launchContexts) {
        launchContexts.stream().map(e -> (Extension)e).forEach(launchContext -> {
            Resource resource;
            String name = ((Coding)launchContext.getExtensionByUrl("name").getValue()).getCode();
            String type = launchContext.getExtensionByUrl("type").getValueAsPrimitive().getValueAsString();
            if (!this.validateContext(Constants.SDC_QUESTIONNAIRE_LAUNCH_CONTEXT_CODE.valueOf((String)name.toUpperCase()), type)) {
                throw new IllegalArgumentException(String.format("Unsupported launch context for %s: %s", name, type));
            }
            List<Parameters.ParametersParameterComponent> content = this.getContent(contexts, name);
            if (content == null || content.isEmpty()) {
                throw new IllegalArgumentException(String.format("Missing content for context: %s", name));
            }
            List<IBaseResource> value = this.getValue(type, content);
            if (!value.isEmpty()) {
                resource = (Resource)(value.size() == 1 ? value.get(0) : BundleHelper.newBundle((FhirVersionEnum)FhirVersionEnum.R5));
                if (value.size() > 1) {
                    value.forEach(v -> ((Bundle)resource).addEntry(new Bundle.BundleEntryComponent().setResource((Resource)v)));
                }
            } else {
                throw new IllegalArgumentException(String.format("Unable to retrieve resource for context: %s", name));
            }
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)("%" + name), (Resource)resource, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
            String cqlParameterName = name.substring(0, 1).toUpperCase().concat(name.substring(1));
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)cqlParameterName, (Resource)resource, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        });
    }

    private List<Parameters.ParametersParameterComponent> getContent(List<? extends IBaseBackboneElement> contexts, String name) {
        return contexts == null ? null : contexts.stream().map(c -> (Parameters.ParametersParameterComponent)c).filter(c -> c.getPart().stream().filter(p -> p.getName().equals("name")).anyMatch(p -> ((StringType)p.getValue()).getValueAsString().equals(name))).flatMap(c -> c.getPart().stream().filter(p -> p.getName().equals("content"))).collect(Collectors.toList());
    }

    private List<IBaseResource> getValue(String type, List<Parameters.ParametersParameterComponent> content) {
        return content.stream().map(p -> {
            if (p.getValue() instanceof Reference) {
                return this.readRepository(this.fhirContext().getResourceDefinition(type).getImplementingClass(), ((Reference)p.getValue()).getReferenceElement());
            }
            return p.getResource();
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public <T extends ICompositeType> IBaseParameters resolveInputParameters(List<T> dataRequirement) {
        List dataRequirements = dataRequirement.stream().map(i -> (DataRequirement)i).collect(Collectors.toList());
        Parameters params = org.opencds.cqf.fhir.utility.r5.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
        if (this.parameters != null) {
            params.getParameter().addAll(this.parameters.getParameter());
        }
        for (DataRequirement req : dataRequirements) {
            if (!req.hasId()) continue;
            Parameters.ParametersParameterComponent parameter = org.opencds.cqf.fhir.utility.r5.Parameters.part((String)("%" + String.format("%s", req.getId())), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
            if (req.hasCodeFilter()) {
                for (DataRequirement.DataRequirementCodeFilterComponent filter : req.getCodeFilter()) {
                    if (filter == null || !filter.hasPath() || !filter.hasValueSet()) continue;
                    Bundle valueSets = (Bundle)this.repository.search(Bundle.class, ValueSet.class, Searches.byCanonical((String)filter.getValueSet()));
                    if (valueSets.hasEntry()) {
                        ValueSet valueSet = (ValueSet)valueSets.getEntryFirstRep().getResource();
                        ArrayList codes = valueSet.hasExpansion() ? valueSet.getExpansion().getContains().stream().map(c -> new Coding(c.getSystem(), c.getCode(), c.getDisplay())).collect(Collectors.toList()) : new ArrayList();
                        Searches.SearchBuilder searchBuilder = Searches.builder();
                        codes.forEach(c -> searchBuilder.withTokenParam("code", c.getCode()));
                        Class resourceType = this.fhirContext().getResourceDefinition(req.getType().toCode()).getImplementingClass();
                        Bundle searchResults = (Bundle)this.repository.search(Bundle.class, resourceType, searchBuilder.build(), null);
                        if (searchResults.hasEntry()) {
                            parameter.setResource((Resource)(searchResults.getEntry().size() > 1 ? searchResults : ((Bundle.BundleEntryComponent)searchResults.getEntry().get(0)).getResource()));
                        }
                    }
                    logger.debug("Could not find ValueSet with url {} on the local server.", (Object)filter.getValueSet());
                }
            }
            params.addParameter(parameter);
        }
        return params;
    }
}

