/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.CareGapsProperties;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePeriodValidator;
import org.opencds.cqf.fhir.cr.measure.constant.HtmlConstants;
import org.opencds.cqf.fhir.cr.measure.enumeration.CareGapsStatusCode;
import org.opencds.cqf.fhir.cr.measure.r4.R4CareGapStatusEvaluator;
import org.opencds.cqf.fhir.cr.measure.r4.R4CareGapsParameters;
import org.opencds.cqf.fhir.cr.measure.r4.R4MultiMeasureService;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4MeasureServiceUtils;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.builder.BundleBuilder;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.CompositionBuilder;
import org.opencds.cqf.fhir.utility.builder.CompositionSectionComponentBuilder;
import org.opencds.cqf.fhir.utility.builder.DetectedIssueBuilder;
import org.opencds.cqf.fhir.utility.builder.NarrativeSettings;

public class R4CareGapsBundleBuilder {
    private static final Map<String, CodeableConceptSettings> CARE_GAPS_CODES = ImmutableMap.of((Object)"http://loinc.org/96315-7", (Object)new CodeableConceptSettings().add("http://loinc.org", "96315-7", "Gaps in care report"), (Object)"http://terminology.hl7.org/CodeSystem/v3-ActCode/CAREGAP", (Object)new CodeableConceptSettings().add("http://terminology.hl7.org/CodeSystem/v3-ActCode", "CAREGAP", "Care Gaps"));
    private final Repository repository;
    private final Map<String, Resource> configuredResources;
    private static final FhirContext fhirContext = FhirContext.forCached((FhirVersionEnum)FhirVersionEnum.R4);
    private final CareGapsProperties careGapsProperties;
    private final String serverBase;
    private final R4MeasureServiceUtils r4MeasureServiceUtils;
    private final R4MultiMeasureService r4MultiMeasureService;

    public R4CareGapsBundleBuilder(CareGapsProperties careGapsProperties, Repository repository, MeasureEvaluationOptions measureEvaluationOptions, String serverBase, Map<String, Resource> configuredResources, MeasurePeriodValidator measurePeriodValidator) {
        this.repository = repository;
        this.careGapsProperties = careGapsProperties;
        this.serverBase = serverBase;
        this.configuredResources = configuredResources;
        this.r4MeasureServiceUtils = new R4MeasureServiceUtils(repository);
        this.r4MultiMeasureService = new R4MultiMeasureService(repository, measureEvaluationOptions, serverBase, measurePeriodValidator);
    }

    public List<Parameters.ParametersParameterComponent> makePatientBundles(List<String> subjects, R4CareGapsParameters r4CareGapsParameters, List<IdType> measureId) {
        String reporter = "Organization".concat("/" + this.careGapsProperties.getCareGapsReporter());
        ArrayList<Parameters.ParametersParameterComponent> paramResults = new ArrayList<Parameters.ParametersParameterComponent>();
        for (String subject : subjects) {
            Bundle result = this.r4MultiMeasureService.evaluate(measureId, null, null, r4CareGapsParameters.getPeriodStart(), r4CareGapsParameters.getPeriodEnd(), MeasureEvalType.SUBJECT.toCode(), subject, null, null, null, null, null, null, reporter);
            Patient patient = (Patient)this.repository.read(Patient.class, (IIdType)new IdType(subject));
            Bundle bundle = this.makePatientBundle(result, r4CareGapsParameters.getStatus(), patient, r4CareGapsParameters.isNotDocument());
            if (bundle == null || !bundle.hasEntry()) continue;
            paramResults.add(this.initializePatientParameter(patient).setResource((Resource)bundle));
        }
        return paramResults;
    }

    @Nullable
    public Bundle makePatientBundle(Bundle bundle, List<String> statuses, Patient patient, boolean notDocument) {
        HashMap<String, Resource> evalPlusSDE = new HashMap<String, Resource>();
        ArrayList<DetectedIssue> detectedIssues = new ArrayList<DetectedIssue>();
        ArrayList<MeasureReport> measureReports = new ArrayList<MeasureReport>();
        R4CareGapStatusEvaluator gapEvaluator = new R4CareGapStatusEvaluator();
        Composition composition = this.getComposition(patient, notDocument);
        for (Bundle.BundleEntryComponent entry : bundle.getEntry()) {
            MeasureReport mr = (MeasureReport)entry.getResource();
            this.addProfile(mr);
            this.addResourceId(mr);
            Measure measure = this.r4MeasureServiceUtils.resolveByUrl(mr.getMeasure());
            Map<String, CareGapsStatusCode> gapStatus = gapEvaluator.getGroupGapStatus(measure, mr);
            Map<String, CareGapsStatusCode> filteredGapStatus = this.filteredGapStatus(gapStatus, statuses);
            if (filteredGapStatus.isEmpty()) continue;
            if (!notDocument) {
                measureReports.add(mr);
                this.populateEvaluatedResources(mr, evalPlusSDE);
                this.populateSDEResources(mr, evalPlusSDE);
            }
            for (Map.Entry<String, CareGapsStatusCode> item : filteredGapStatus.entrySet()) {
                String groupId = item.getKey();
                CareGapsStatusCode careGapsStatusCode = item.getValue();
                DetectedIssue issue = this.getDetectedIssue(patient, mr, groupId, careGapsStatusCode, measure, notDocument);
                detectedIssues.add(issue);
                if (notDocument) continue;
                composition.addSection(this.getSection(measure, mr, issue, careGapsStatusCode));
            }
        }
        if (!detectedIssues.isEmpty()) {
            return this.addBundleEntries(this.serverBase, composition, detectedIssues, measureReports, evalPlusSDE, notDocument);
        }
        return null;
    }

    private Map<String, CareGapsStatusCode> filteredGapStatus(Map<String, CareGapsStatusCode> careGapStatusPerGroupId, List<String> statuses) {
        HashMap<String, CareGapsStatusCode> filtered = new HashMap<String, CareGapsStatusCode>();
        for (Map.Entry<String, CareGapsStatusCode> entry : careGapStatusPerGroupId.entrySet()) {
            String groupId = entry.getKey();
            CareGapsStatusCode careGapsStatusCode = entry.getValue();
            if (!statuses.contains(careGapsStatusCode.toString())) continue;
            filtered.put(groupId, careGapsStatusCode);
        }
        return filtered;
    }

    private Bundle.BundleEntryComponent getBundleEntry(String serverBase, Resource resource) {
        return new Bundle.BundleEntryComponent().setResource(resource).setFullUrl(R4MeasureServiceUtils.getFullUrl(serverBase, (IBaseResource)resource));
    }

    private Composition.SectionComponent getSection(Measure measure, MeasureReport measureReport, DetectedIssue detectedIssue, CareGapsStatusCode gapStatus) {
        String narrative = String.format(HtmlConstants.HTML_DIV_PARAGRAPH_CONTENT, gapStatus == CareGapsStatusCode.CLOSED_GAP ? "No detected issues." : String.format("Issues detected.  See %s for details.", Ids.simple((IBaseResource)detectedIssue)));
        return (Composition.SectionComponent)new CompositionSectionComponentBuilder(Composition.SectionComponent.class).withTitle(measure.hasTitle() ? measure.getTitle() : measure.getUrl()).withFocus(Ids.simple((IBaseResource)measureReport)).withText(new NarrativeSettings(narrative)).withEntry(Ids.simple((IBaseResource)detectedIssue)).build();
    }

    @Nullable
    private Composition getComposition(Patient patient, boolean notDocument) {
        Composition composition = null;
        if (!notDocument) {
            composition = (Composition)((CompositionBuilder)new CompositionBuilder(Composition.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-composition-deqm")).withType(CARE_GAPS_CODES.get("http://loinc.org/96315-7")).withStatus(Composition.CompositionStatus.FINAL.toString()).withTitle("Care Gap Report for " + Ids.simplePart((IBaseResource)patient)).withSubject(Ids.simple((IBaseResource)patient)).withAuthor(Ids.simple((IBaseResource)((IBaseResource)this.configuredResources.get("care_gaps_composition_section_author")))).build();
        }
        return composition;
    }

    private boolean isMultiRateMeasure(MeasureReport measureReport) {
        return measureReport.getGroup().size() > 1;
    }

    private DetectedIssue getDetectedIssue(Patient patient, MeasureReport measureReport, String measureReportGroupId, CareGapsStatusCode careGapsStatusCode, Measure measure, boolean notDocument) {
        DetectedIssue detectedIssue = (DetectedIssue)((DetectedIssueBuilder)((DetectedIssueBuilder)new DetectedIssueBuilder(DetectedIssue.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-detectedissue-deqm")).withStatus(DetectedIssue.DetectedIssueStatus.FINAL.toString()).withCode(CARE_GAPS_CODES.get("http://terminology.hl7.org/CodeSystem/v3-ActCode/CAREGAP")).withPatient(Ids.simple((IBaseResource)patient)).withEvidenceDetail(Ids.simple((IBaseResource)measureReport)).withModifierExtension((Pair)new ImmutablePair((Object)"http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-gapStatus", (Object)new CodeableConceptSettings().add("http://hl7.org/fhir/us/davinci-deqm/CodeSystem/gaps-status", careGapsStatusCode.toString(), careGapsStatusCode.toDisplayString())))).build();
        detectedIssue.setIdentified((Type)measureReport.getPeriod());
        detectedIssue.setImplicated(Collections.singletonList(new Reference(Ids.simple((IBaseResource)measure))));
        if (measureReportGroupId != null && this.isMultiRateMeasure(measureReport)) {
            Extension groupIdExt = new Extension();
            groupIdExt.setUrl("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-detectedissue-mr-group-id-deqm");
            groupIdExt.setValue((Type)new StringType(measureReportGroupId));
            detectedIssue.setExtension(Collections.singletonList(groupIdExt));
        }
        if (notDocument) {
            detectedIssue.setContained(Collections.singletonList(measureReport));
            detectedIssue.getEvidenceFirstRep().setDetail(Collections.singletonList(new Reference("#" + measureReport.getId())));
        }
        return detectedIssue;
    }

    private void populateEvaluatedResources(MeasureReport measureReport, Map<String, Resource> resources) {
        measureReport.getEvaluatedResource().forEach(evaluatedResource -> {
            IIdType resourceId = evaluatedResource.getReferenceElement();
            if (resourceId.getResourceType() == null || resources.containsKey(Ids.simple((IIdType)resourceId))) {
                return;
            }
            Class resourceType = ((IBaseResource)fhirContext.getResourceDefinition(resourceId.getResourceType()).newInstance()).getClass();
            IBaseResource resource = this.repository.read(resourceType, resourceId);
            if (resource instanceof Resource) {
                Resource resourceBase = (Resource)resource;
                resources.put(Ids.simple((IIdType)resourceId), resourceBase);
            }
        });
    }

    private void populateSDEResources(MeasureReport measureReport, Map<String, Resource> resources) {
        if (measureReport.hasExtension()) {
            for (Extension extension : measureReport.getExtension()) {
                Class resourceType;
                IBaseResource resource;
                IdType sdeId;
                Reference sdeRef;
                if (!extension.hasUrl() || !extension.getUrl().equals("http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.supplementalDataElement.reference") || (sdeRef = extension.hasValue() && extension.getValue() instanceof Reference ? (Reference)extension.getValue() : null) == null || !sdeRef.hasReference() || sdeRef.getReference().startsWith("#") || resources.containsKey(Ids.simple((IIdType)(sdeId = new IdType(sdeRef.getReference())))) || !((resource = this.repository.read(resourceType = ((IBaseResource)fhirContext.getResourceDefinition(sdeId.getResourceType()).newInstance()).getClass(), (IIdType)sdeId)) instanceof Resource)) continue;
                Resource resourceBase = (Resource)resource;
                resources.put(Ids.simple((IIdType)sdeId), resourceBase);
            }
        }
    }

    private Bundle makeNewBundle() {
        return (Bundle)((BundleBuilder)new BundleBuilder(Bundle.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-bundle-deqm")).withType(Bundle.BundleType.DOCUMENT.toString()).build();
    }

    private Bundle addBundleEntries(String serverBase, Composition composition, List<DetectedIssue> detectedIssues, List<MeasureReport> measureReports, Map<String, Resource> evalPlusSDEs, boolean notDocument) {
        Bundle reportBundle = this.makeNewBundle();
        if (notDocument) {
            detectedIssues.forEach(detectedIssue -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)detectedIssue)));
        } else {
            reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)composition));
            measureReports.forEach(report -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)report)));
            detectedIssues.forEach(detectedIssue -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)detectedIssue)));
            this.configuredResources.values().forEach(resource -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)resource)));
            evalPlusSDEs.values().forEach(resource -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)resource)));
        }
        return reportBundle;
    }

    private void addProfile(MeasureReport measureReport) {
        if (measureReport.hasMeta()) {
            measureReport.getMeta().addProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/indv-measurereport-deqm");
        } else {
            measureReport.setMeta(new Meta().addProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/indv-measurereport-deqm"));
        }
    }

    private void addResourceId(MeasureReport measureReport) {
        if (Strings.isNullOrEmpty((String)measureReport.getId())) {
            IIdType id = Ids.newId(MeasureReport.class, (String)UUID.randomUUID().toString());
            measureReport.setId(id);
        }
    }

    private Parameters.ParametersParameterComponent initializePatientParameter(Patient patient) {
        Parameters.ParametersParameterComponent patientParameter = ((Parameters.ParametersParameterComponent)Resources.newBackboneElement(Parameters.ParametersParameterComponent.class)).setName("return");
        patientParameter.setId("subject-" + Ids.simplePart((IBaseResource)patient));
        return patientParameter;
    }
}

