/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.CareGapsProperties;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePeriodValidator;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.enumeration.CareGapsStatusCode;
import org.opencds.cqf.fhir.cr.measure.r4.R4CareGapsBundleBuilder;
import org.opencds.cqf.fhir.cr.measure.r4.R4CareGapsParameters;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureBasisDef;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4MeasureServiceUtils;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4CareGapsProcessor {
    private static final Logger ourLog = LoggerFactory.getLogger(R4CareGapsProcessor.class);
    private final Repository repository;
    private final CareGapsProperties careGapsProperties;
    private final Map<String, Resource> configuredResources = new HashMap<String, Resource>();
    private final R4MeasureServiceUtils r4MeasureServiceUtils;
    private final R4CareGapsBundleBuilder r4CareGapsBundleBuilder;

    public R4CareGapsProcessor(CareGapsProperties careGapsProperties, Repository repository, MeasureEvaluationOptions measureEvaluationOptions, String serverBase, MeasurePeriodValidator measurePeriodValidator) {
        this.repository = repository;
        this.careGapsProperties = careGapsProperties;
        this.r4MeasureServiceUtils = new R4MeasureServiceUtils(repository);
        this.r4CareGapsBundleBuilder = new R4CareGapsBundleBuilder(careGapsProperties, repository, measureEvaluationOptions, serverBase, this.configuredResources, measurePeriodValidator);
    }

    public Parameters getCareGapsReport(@Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String subject, List<String> status, List<Either3<IdType, String, CanonicalType>> measure, boolean notDocument) {
        R4CareGapsParameters r4CareGapsParams = this.setCareGapParameters(periodStart, periodEnd, subject, status, measure, notDocument);
        this.checkConfigurationReferences();
        this.checkValidStatusCode(r4CareGapsParams.getStatus());
        List<Measure> measures = this.resolveMeasure(r4CareGapsParams.getMeasure());
        this.measureCompatibilityCheck(measures);
        List<String> subjects = this.getSubjects(r4CareGapsParams.getSubject());
        Parameters result = this.initializeResult();
        List<Parameters.ParametersParameterComponent> components = this.r4CareGapsBundleBuilder.makePatientBundles(subjects, r4CareGapsParams, measures.stream().map(Resource::getIdElement).collect(Collectors.toList()));
        return result.setParameter(components);
    }

    protected R4CareGapsParameters setCareGapParameters(@Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String subject, List<String> status, List<Either3<IdType, String, CanonicalType>> measure, boolean notDocument) {
        R4CareGapsParameters r4CareGapsParams = new R4CareGapsParameters();
        r4CareGapsParams.setMeasure(measure);
        r4CareGapsParams.setPeriodStart(periodStart);
        r4CareGapsParams.setPeriodEnd(periodEnd);
        r4CareGapsParams.setStatus(status);
        r4CareGapsParams.setSubject(subject);
        r4CareGapsParams.setNotDocument(notDocument);
        return r4CareGapsParams;
    }

    protected List<Measure> resolveMeasure(List<Either3<IdType, String, CanonicalType>> measure) {
        return measure.stream().map(x -> (Measure)x.fold(id -> (Measure)this.repository.read(Measure.class, (IIdType)id), this.r4MeasureServiceUtils::resolveByIdentifier, canonical -> this.r4MeasureServiceUtils.resolveByUrl(canonical.asStringValue()))).collect(Collectors.toList());
    }

    protected List<String> getSubjects(String subject) {
        R4RepositorySubjectProvider subjectProvider = new R4RepositorySubjectProvider();
        List<String> subjects = subjectProvider.getSubjects(this.repository, null, subject).collect(Collectors.toList());
        if (!subjects.isEmpty()) {
            ourLog.info(String.format("care-gaps report requested for: %s subjects.", subjects.size()));
        } else {
            ourLog.info("care-gaps report requested for: 0 subjects.");
        }
        return subjects;
    }

    protected void addConfiguredResource(String id, String key) {
        Resource resource = (Resource)this.repository.read(Organization.class, (IIdType)new IdType("Organization", id));
        Preconditions.checkNotNull((Object)resource, (Object)String.format("The %s Resource is configured as the %s but the Resource could not be read.", this.careGapsProperties.getCareGapsReporter(), key));
        this.configuredResources.put(key, resource);
    }

    protected void checkMeasureImprovementNotation(Measure measure) {
        if (!measure.hasImprovementNotation()) {
            ourLog.warn("Measure '{}' does not specify an improvement notation, defaulting to: '{}'.", (Object)measure.getId(), (Object)"increase");
        }
    }

    protected Parameters initializeResult() {
        return (Parameters)Resources.newResource(Parameters.class, (String)("care-gaps-report-" + String.valueOf(UUID.randomUUID())));
    }

    protected void checkValidStatusCode(List<String> statuses) {
        this.r4MeasureServiceUtils.listThrowIllegalArgumentIfEmpty(statuses, "status");
        for (String status : statuses) {
            if (CareGapsStatusCode.CLOSED_GAP.toString().equals(status) || CareGapsStatusCode.OPEN_GAP.toString().equals(status) || CareGapsStatusCode.NOT_APPLICABLE.toString().equals(status) || CareGapsStatusCode.PROSPECTIVE_GAP.toString().equals(status)) continue;
            throw new IllegalArgumentException(String.format("CareGap status parameter: %s, is not an accepted value", status));
        }
    }

    protected void measureCompatibilityCheck(List<Measure> measures) {
        for (Measure measure : measures) {
            this.checkMeasureScoringType(measure);
            this.checkMeasureImprovementNotation(measure);
            this.checkMeasureBasis(measure);
            this.checkMeasureGroupComponents(measure);
        }
    }

    protected void checkMeasureBasis(Measure measure) {
        R4MeasureBasisDef measureDef = new R4MeasureBasisDef();
        if (!measureDef.isBooleanBasis(measure)) {
            throw new IllegalArgumentException(String.format("CareGaps can't process Measure: %s, it is not Boolean basis.", measure.getIdPart()));
        }
    }

    protected void checkMeasureGroupComponents(Measure measure) {
        if (measure.getGroup().size() > 1) {
            for (Measure.MeasureGroupComponent group : measure.getGroup()) {
                if (measure.getGroup().size() <= 1 || group.getId() != null && !group.getId().isEmpty()) continue;
                throw new IllegalArgumentException("Multi-rate Measure resources require unique 'id' for GroupComponents to be populated.");
            }
        }
    }

    protected void checkMeasureScoringType(Measure measure) {
        List<MeasureScoring> scoringTypes = this.r4MeasureServiceUtils.getMeasureScoringDef(measure);
        for (MeasureScoring measureScoringType : scoringTypes) {
            if (MeasureScoring.PROPORTION.equals((Object)measureScoringType) || MeasureScoring.RATIO.equals((Object)measureScoringType)) continue;
            throw new IllegalArgumentException(String.format("MeasureScoring type: %s, is not an accepted Type for care-gaps service", measureScoringType.getDisplay()));
        }
    }

    protected void checkConfigurationReferences() {
        this.careGapsProperties.validateRequiredProperties();
        this.addConfiguredResource(this.careGapsProperties.getCareGapsReporter(), "care_gaps_reporter");
        this.addConfiguredResource(this.careGapsProperties.getCareGapsCompositionSectionAuthor(), "care_gaps_composition_section_author");
    }
}

