/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.cr.measure.common.CodeDef;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierComponentDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureBasisDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4MeasureDefBuilder
implements MeasureDefBuilder<Measure> {
    private static final Logger ourLog = LoggerFactory.getLogger(R4MeasureDefBuilder.class);

    @Override
    public MeasureDef build(Measure measure) {
        this.checkId((Resource)measure);
        ArrayList<SdeDef> sdes = new ArrayList<SdeDef>();
        for (Measure.MeasureSupplementalDataComponent s : measure.getSupplementalData()) {
            this.checkId((Element)s);
            SdeDef sdeDef = new SdeDef(s.getId(), this.conceptToConceptDef(s.getCode()), s.getCriteria().getExpression());
            sdes.add(sdeDef);
        }
        MeasureScoring measureLevelMeasureScoring = this.getMeasureScoring(measure);
        boolean measureLevelImpNotation = this.measureIsIncreaseImprovementNotation(measure);
        ArrayList<GroupDef> groups = new ArrayList<GroupDef>();
        for (Measure.MeasureGroupComponent group : measure.getGroup()) {
            MeasureScoring groupMeasureScoringCode = this.getGroupMeasureScoring(measureLevelMeasureScoring, group);
            if (groupMeasureScoringCode == null) {
                throw new IllegalArgumentException("MeasureScoring must be specified on Group or Measure");
            }
            boolean groupIsIncreaseImprovementNotation = this.groupIsIncreaseImprovementNotation(measureLevelImpNotation, group);
            ArrayList<PopulationDef> populations = new ArrayList<PopulationDef>();
            for (Measure.MeasureGroupPopulationComponent pop : group.getPopulation()) {
                this.checkId((Element)pop);
                MeasurePopulationType populationType = MeasurePopulationType.fromCode(pop.getCode().getCodingFirstRep().getCode());
                populations.add(new PopulationDef(pop.getId(), this.conceptToConceptDef(pop.getCode()), populationType, pop.getCriteria().getExpression()));
            }
            if (this.checkPopulationForCode(populations, MeasurePopulationType.TOTALDENOMINATOR) == null) {
                populations.add(new PopulationDef("totalDenominator", this.totalConceptDefCreator(MeasurePopulationType.TOTALDENOMINATOR), MeasurePopulationType.TOTALDENOMINATOR, null));
            }
            if (this.checkPopulationForCode(populations, MeasurePopulationType.TOTALNUMERATOR) == null) {
                populations.add(new PopulationDef("totalNumerator", this.totalConceptDefCreator(MeasurePopulationType.TOTALNUMERATOR), MeasurePopulationType.TOTALNUMERATOR, null));
            }
            if (group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression") != null && this.checkPopulationForCode(populations, MeasurePopulationType.DATEOFCOMPLIANCE) == null) {
                Expression expressionType = (Expression)group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression").getValue();
                if (!expressionType.hasExpression()) {
                    throw new IllegalArgumentException(String.format("no expression was listed for extension: %s", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression"));
                }
                String expression = expressionType.getExpression();
                populations.add(new PopulationDef("dateOfCompliance", this.totalConceptDefCreator(MeasurePopulationType.DATEOFCOMPLIANCE), MeasurePopulationType.DATEOFCOMPLIANCE, expression));
            }
            ArrayList<StratifierDef> stratifiers = new ArrayList<StratifierDef>();
            for (Measure.MeasureGroupStratifierComponent mgsc : group.getStratifier()) {
                this.checkId((Element)mgsc);
                ArrayList<StratifierComponentDef> components = new ArrayList<StratifierComponentDef>();
                for (Measure.MeasureGroupStratifierComponentComponent scc : mgsc.getComponent()) {
                    this.checkId((Element)scc);
                    StratifierComponentDef scd = new StratifierComponentDef(scc.getId(), this.conceptToConceptDef(scc.getCode()), scc.hasCriteria() ? scc.getCriteria().getExpression() : null);
                    components.add(scd);
                }
                StratifierDef stratifierDef = new StratifierDef(mgsc.getId(), this.conceptToConceptDef(mgsc.getCode()), mgsc.getCriteria().getExpression(), components);
                stratifiers.add(stratifierDef);
            }
            GroupDef groupDef = new GroupDef(group.getId(), this.conceptToConceptDef(group.getCode()), stratifiers, populations, groupMeasureScoringCode, groupIsIncreaseImprovementNotation);
            groups.add(groupDef);
        }
        R4MeasureBasisDef measureBasisDef = new R4MeasureBasisDef();
        return new MeasureDef(measure.getId(), measure.getUrl(), measure.getVersion(), groups, sdes, measureBasisDef.isBooleanBasis(measure));
    }

    private PopulationDef checkPopulationForCode(List<PopulationDef> populations, MeasurePopulationType measurePopType) {
        return populations.stream().filter(e -> e.code().first().code().equals(measurePopType.toCode())).findAny().orElse(null);
    }

    private ConceptDef totalConceptDefCreator(MeasurePopulationType measurePopulationType) {
        return new ConceptDef(Collections.singletonList(new CodeDef(measurePopulationType.getSystem(), measurePopulationType.toCode())), null);
    }

    private ConceptDef conceptToConceptDef(CodeableConcept codeable) {
        if (codeable == null) {
            return null;
        }
        ArrayList<CodeDef> codes = new ArrayList<CodeDef>();
        for (Coding c : codeable.getCoding()) {
            codes.add(this.codeToCodeDef(c));
        }
        return new ConceptDef(codes, codeable.getText());
    }

    private CodeDef codeToCodeDef(Coding coding) {
        return new CodeDef(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay());
    }

    private void checkId(Element e) {
        if (e.getId() == null || StringUtils.isBlank((CharSequence)e.getId())) {
            throw new NullPointerException("id is required on all Elements of type: " + e.fhirType());
        }
    }

    private void checkId(Resource r) {
        if (r.getId() == null || StringUtils.isBlank((CharSequence)r.getId())) {
            throw new NullPointerException("id is required on all Resources of type: " + r.fhirType());
        }
    }

    private MeasureScoring getMeasureScoring(Measure measure) {
        return MeasureScoring.fromCode(measure.getScoring().getCodingFirstRep().getCode());
    }

    private MeasureScoring getGroupMeasureScoring(MeasureScoring measureLevelScoring, Measure.MeasureGroupComponent group) {
        Extension scoringExtension = group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring");
        if (scoringExtension != null) {
            CodeableConcept coding = (CodeableConcept)scoringExtension.getValue();
            return MeasureScoring.fromCode(coding.getCodingFirstRep().getCode());
        }
        return measureLevelScoring;
    }

    private boolean isIncreaseImprovementNotation(CodeableConcept improvementNotationValue) {
        return improvementNotationValue.hasCoding("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase");
    }

    public boolean measureIsIncreaseImprovementNotation(Measure measure) {
        if (measure.hasImprovementNotation()) {
            return this.isIncreaseImprovementNotation(measure.getImprovementNotation());
        }
        return true;
    }

    public boolean groupIsIncreaseImprovementNotation(boolean measureImprovementNotationIsIncrease, Measure.MeasureGroupComponent group) {
        Extension improvementNotationExt = group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-improvementNotation");
        if (improvementNotationExt != null) {
            CodeableConcept code = (CodeableConcept)improvementNotationExt.getValue();
            return this.isIncreaseImprovementNotation(code);
        }
        return measureImprovementNotationIsIncrease;
    }
}

