/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Patient;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.SubjectProvider;
import org.opencds.cqf.fhir.utility.iterable.BundleIterator;
import org.opencds.cqf.fhir.utility.iterable.BundleMappingIterable;
import org.opencds.cqf.fhir.utility.search.Searches;

public class R4RepositorySubjectProvider
implements SubjectProvider {
    @Override
    public Stream<String> getSubjects(Repository repository, MeasureEvalType measureEvalType, String subjectId) {
        return this.getSubjects(repository, measureEvalType, Collections.singletonList(subjectId));
    }

    @Override
    public Stream<String> getSubjects(Repository repository, MeasureEvalType measureEvalType, List<String> subjectIds) {
        if (subjectIds == null || subjectIds.isEmpty() || subjectIds.get(0) == null || subjectIds.get(0).isEmpty()) {
            Bundle bundle = (Bundle)repository.search(Bundle.class, Patient.class, Searches.ALL);
            return new BundleMappingIterable(repository, (IBaseBundle)bundle, x -> x.getResource().getIdElement().toUnqualifiedVersionless().getValue()).toStream();
        }
        ArrayList subjects = new ArrayList();
        subjectIds.forEach(subjectId -> {
            if (subjectId.indexOf("/") == -1) {
                subjectId = "Patient/".concat((String)subjectId);
            }
            if (subjectId.startsWith("Patient")) {
                IdType id = new IdType(subjectId);
                Patient r = (Patient)repository.read(Patient.class, (IIdType)id);
                if (r == null) {
                    throw new ResourceNotFoundException((IIdType)id);
                }
                subjects.add(r.getIdElement().toUnqualifiedVersionless().getValue());
            } else if (subjectId.startsWith("Practitioner")) {
                this.addPractitionerSubjectIds((String)subjectId, repository, subjects);
            } else if (subjectId.startsWith("Group")) {
                IdType id = new IdType(subjectId);
                Group r = (Group)repository.read(Group.class, (IIdType)id);
                if (r == null) {
                    throw new ResourceNotFoundException((IIdType)id);
                }
                if (r.getType().equals((Object)Group.GroupType.PERSON)) {
                    for (Group.GroupMemberComponent gmc : r.getMember()) {
                        IIdType ref = gmc.getEntity().getReferenceElement();
                        subjects.add(ref.getResourceType() + "/" + ref.getIdPart());
                    }
                } else if (r.getType().equals((Object)Group.GroupType.PRACTITIONER)) {
                    List<String> practitionerGroupMembers = this.getMembersInGroup(r);
                    for (String practitioner : practitionerGroupMembers) {
                        this.addPractitionerSubjectIds(practitioner, repository, subjects);
                    }
                }
            } else {
                throw new IllegalArgumentException(String.format("Unsupported subjectId: %s", subjectIds));
            }
        });
        return subjects.stream();
    }

    private List<String> getMembersInGroup(Group group) {
        ArrayList<String> members = new ArrayList<String>();
        for (Group.GroupMemberComponent gmc : group.getMember()) {
            IIdType ref = gmc.getEntity().getReferenceElement();
            members.add(ref.getResourceType() + "/" + ref.getIdPart());
        }
        return members;
    }

    public void addPractitionerSubjectIds(String practitioner, Repository repository, List<String> patients) {
        HashMap<String, List<ReferenceParam>> map = new HashMap<String, List<ReferenceParam>>();
        map.put("general-practitioner", Collections.singletonList(new ReferenceParam((String)(practitioner.startsWith("Practitioner/") ? practitioner : "Practitioner/" + practitioner))));
        Bundle bundle = (Bundle)repository.search(Bundle.class, Patient.class, map);
        BundleIterator iterator = new BundleIterator(repository, (IBaseBundle)bundle);
        while (iterator.hasNext()) {
            IBaseResource patient = iterator.next().getResource();
            String refString = patient.getIdElement().getResourceType() + "/" + patient.getIdElement().getIdPart();
            patients.add(refString);
        }
    }
}

