/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.opencds.cqf.fhir.cr.inputparameters.IInputParameterResolver;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Constants;
import org.opencds.cqf.fhir.utility.adapter.QuestionnaireAdapter;

public class ApplyRequest
implements ICpgRequest {
    private static final String ACTIVITY_DEFINITION = "ActivityDefinition";
    private final IBaseResource planDefinition;
    private final IIdType subjectId;
    private final IIdType encounterId;
    private final IIdType practitionerId;
    private final IIdType organizationId;
    private final IBaseDatatype userType;
    private final IBaseDatatype userLanguage;
    private final IBaseDatatype userTaskContext;
    private final IBaseDatatype setting;
    private final IBaseDatatype settingContext;
    private final IBaseParameters parameters;
    private final boolean useServerData;
    private IBaseBundle data;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final String defaultLibraryUrl;
    private final IInputParameterResolver inputParameterResolver;
    private final Collection<IBaseResource> requestResources;
    private final Collection<IBaseResource> extractedResources;
    private IBaseOperationOutcome operationOutcome;
    private IBaseResource questionnaire;
    private QuestionnaireAdapter questionnaireAdapter;
    private Boolean containResources;

    public ApplyRequest(IBaseResource planDefinition, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IIdType organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, boolean useServerData, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine, ModelResolver modelResolver, IInputParameterResolver inputParameterResolver) {
        Preconditions.checkNotNull((Object)planDefinition, (Object)"expected non-null value for planDefinition");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.planDefinition = planDefinition;
        this.fhirVersion = planDefinition.getStructureFhirVersionEnum();
        this.subjectId = subjectId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        this.organizationId = organizationId;
        this.userType = userType;
        this.userLanguage = userLanguage;
        this.userTaskContext = userTaskContext;
        this.setting = setting;
        this.settingContext = settingContext;
        this.parameters = parameters;
        this.useServerData = useServerData;
        if (prefetchData != null && !prefetchData.isEmpty()) {
            if (data == null) {
                data = BundleHelper.newBundle((FhirVersionEnum)this.fhirVersion);
            }
            this.resolvePrefetchData(data, prefetchData);
        }
        this.data = data;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.inputParameterResolver = inputParameterResolver != null ? inputParameterResolver : IInputParameterResolver.createResolver(libraryEngine.getRepository(), this.subjectId, this.encounterId, this.practitionerId, this.parameters, this.useServerData, this.data);
        this.defaultLibraryUrl = this.resolveDefaultLibraryUrl();
        this.requestResources = new ArrayList<IBaseResource>();
        this.extractedResources = new ArrayList<IBaseResource>();
        this.containResources = false;
    }

    public ApplyRequest copy(IBaseResource planDefinition) {
        return new ApplyRequest(planDefinition, this.subjectId, this.encounterId, this.practitionerId, this.organizationId, this.userType, this.userLanguage, this.userTaskContext, this.setting, this.settingContext, this.parameters, this.useServerData, this.data, null, this.libraryEngine, this.modelResolver, this.inputParameterResolver).setQuestionnaire(this.questionnaire);
    }

    public org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest toActivityRequest(IBaseResource activityDefinition) {
        return new org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest(activityDefinition, this.getSubjectId(), this.getEncounterId(), this.getPractitionerId(), this.getOrganizationId(), this.getUserType(), this.getUserLanguage(), this.getUserTaskContext(), this.getSetting(), this.getSettingContext(), this.getParameters(), this.getUseServerData(), this.getData(), this.libraryEngine, this.modelResolver);
    }

    public GenerateRequest toGenerateRequest(IBaseResource profile) {
        return new GenerateRequest(profile, false, true, this.modelResolver).setDefaultLibraryUrl(this.defaultLibraryUrl).setQuestionnaire(this.questionnaire);
    }

    public PopulateRequest toPopulateRequest() {
        ArrayList context = new ArrayList();
        List launchContextExts = this.getQuestionnaireAdapter().getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext");
        launchContextExts.forEach(lc -> {
            String code = lc.getExtension().stream().map(c -> (IBaseExtension)c).filter(c -> c.getUrl().equals("name")).map(c -> this.resolvePathString((IBase)c.getValue(), "code")).findFirst().orElse(null);
            String value = null;
            switch (Constants.SDC_QUESTIONNAIRE_LAUNCH_CONTEXT_CODE.valueOf((String)code.toUpperCase())) {
                case PATIENT: {
                    value = this.subjectId.getValue();
                    break;
                }
                case ENCOUNTER: {
                    value = this.encounterId.getValue();
                    break;
                }
                case USER: {
                    value = this.practitionerId.getValue();
                    break;
                }
            }
            context.add((IBaseBackboneElement)org.opencds.cqf.fhir.utility.Parameters.newPart((FhirContext)this.getFhirContext(), (String)"context", (IBase[])new IBase[]{org.opencds.cqf.fhir.utility.Parameters.newStringPart((FhirContext)this.getFhirContext(), (String)"name", (String)code, (IBase[])new IBase[0]), org.opencds.cqf.fhir.utility.Parameters.newPart((FhirContext)this.getFhirContext(), (String)"Reference", (String)"content", (Object)value, (IBase[])new IBase[0])}));
        });
        return new PopulateRequest(this.questionnaire, this.subjectId, context, null, this.parameters, this.data, this.useServerData, this.libraryEngine, this.modelResolver);
    }

    public IBaseResource getPlanDefinition() {
        return this.planDefinition;
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IIdType getPractitionerId() {
        return this.practitionerId;
    }

    @Override
    public IIdType getEncounterId() {
        return this.encounterId;
    }

    @Override
    public IIdType getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public IBaseDatatype getUserType() {
        return this.userType;
    }

    @Override
    public IBaseDatatype getUserLanguage() {
        return this.userLanguage;
    }

    @Override
    public IBaseDatatype getUserTaskContext() {
        return this.userTaskContext;
    }

    @Override
    public IBaseDatatype getSetting() {
        return this.setting;
    }

    @Override
    public IBaseDatatype getSettingContext() {
        return this.settingContext;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public boolean getUseServerData() {
        return this.useServerData;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.inputParameterResolver.getParameters();
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    @Override
    public String getOperationName() {
        return "apply";
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public QuestionnaireAdapter getQuestionnaireAdapter() {
        if (this.questionnaireAdapter == null && this.questionnaire != null) {
            this.questionnaireAdapter = (QuestionnaireAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)this.questionnaire);
        }
        return this.questionnaireAdapter;
    }

    public ApplyRequest setQuestionnaire(IBaseResource questionnaire) {
        this.questionnaire = questionnaire;
        return this;
    }

    public ApplyRequest setData(IBaseBundle bundle) {
        this.data = bundle;
        return this;
    }

    public void setContainResources(Boolean value) {
        this.containResources = value;
    }

    public Boolean getContainResources() {
        return this.containResources;
    }

    public Collection<IBaseResource> getRequestResources() {
        return this.requestResources;
    }

    public Collection<IBaseResource> getExtractedResources() {
        return this.extractedResources;
    }

    public <T extends ICompositeType> IBaseParameters resolveInputParameters(List<T> input) {
        return this.inputParameterResolver.resolveInputParameters(input);
    }

    public IBaseParameters transformRequestParameters(IBaseResource resource) {
        switch (this.fhirVersion) {
            case DSTU3: {
                return this.transformRequestParametersDstu3(resource);
            }
            case R4: {
                return this.transformRequestParametersR4(resource);
            }
            case R5: {
                return this.transformRequestParametersR5(resource);
            }
        }
        return null;
    }

    protected IBaseParameters transformRequestParametersDstu3(IBaseResource resource) {
        String resourceParameter = resource.fhirType().equals(ACTIVITY_DEFINITION) ? "activityDefinition" : "planDefinition";
        Parameters params = org.opencds.cqf.fhir.utility.dstu3.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(org.opencds.cqf.fhir.utility.dstu3.Parameters.part((String)resourceParameter, (org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)resource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])).addParameter(org.opencds.cqf.fhir.utility.dstu3.Parameters.part((String)"subject", (String)this.getSubjectId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (this.hasEncounterId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.dstu3.Parameters.part((String)"encounter", (String)this.getEncounterId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasPractitionerId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.dstu3.Parameters.part((String)"practitioner", (String)this.getPractitionerId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasOrganizationId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.dstu3.Parameters.part((String)"organization", (String)this.getOrganizationId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getParameters() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.dstu3.Parameters.part((String)"parameters", (org.hl7.fhir.dstu3.model.Resource)((Parameters)this.getParameters()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getData() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.dstu3.Parameters.part((String)"data", (org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)this.getData()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }

    protected IBaseParameters transformRequestParametersR4(IBaseResource resource) {
        String resourceParameter = resource.fhirType().equals(ACTIVITY_DEFINITION) ? "activityDefinition" : "planDefinition";
        org.hl7.fhir.r4.model.Parameters params = org.opencds.cqf.fhir.utility.r4.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)resourceParameter, (org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)resource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])).addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"subject", (String)this.getSubjectId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (this.hasEncounterId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"encounter", (String)this.getEncounterId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasPractitionerId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"practitioner", (String)this.getPractitionerId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasOrganizationId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"organization", (String)this.getOrganizationId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getParameters() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"parameters", (org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Parameters)this.getParameters()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getData() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"data", (org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)this.getData()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }

    protected IBaseParameters transformRequestParametersR5(IBaseResource resource) {
        String resourceParameter = resource.fhirType().equals(ACTIVITY_DEFINITION) ? "activityDefinition" : "planDefinition";
        org.hl7.fhir.r5.model.Parameters params = org.opencds.cqf.fhir.utility.r5.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)resourceParameter, (Resource)((Resource)resource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])).addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"subject", (String)this.getSubjectId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (this.hasEncounterId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"encounter", (String)this.getEncounterId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasPractitionerId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"practitioner", (String)this.getPractitionerId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasOrganizationId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"organization", (String)this.getOrganizationId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getParameters() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"parameters", (Resource)((org.hl7.fhir.r5.model.Parameters)this.getParameters()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getData() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"data", (Resource)((Resource)this.getData()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }

    protected final String resolveDefaultLibraryUrl() {
        switch (this.fhirVersion) {
            case DSTU3: {
                return ((org.hl7.fhir.dstu3.model.PlanDefinition)this.planDefinition).hasLibrary() ? ((Reference)((org.hl7.fhir.dstu3.model.PlanDefinition)this.planDefinition).getLibrary().get(0)).getReference() : null;
            }
            case R4: {
                return ((org.hl7.fhir.r4.model.PlanDefinition)this.planDefinition).hasLibrary() ? ((org.hl7.fhir.r4.model.CanonicalType)((org.hl7.fhir.r4.model.PlanDefinition)this.planDefinition).getLibrary().get(0)).getValueAsString() : null;
            }
            case R5: {
                return ((PlanDefinition)this.planDefinition).hasLibrary() ? ((CanonicalType)((PlanDefinition)this.planDefinition).getLibrary().get(0)).getValueAsString() : null;
            }
        }
        return null;
    }
}

