/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.DataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IDataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.cr.common.PackageProcessor;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IGenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.IPopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class QuestionnaireProcessor {
    protected static final String SUBJECT_TYPE = "Patient";
    protected final ResourceResolver questionnaireResolver;
    protected final ResourceResolver structureDefResolver;
    protected final ModelResolver modelResolver;
    protected final EvaluationSettings evaluationSettings;
    protected final FhirVersionEnum fhirVersion;
    protected Repository repository;
    protected IGenerateProcessor generateProcessor;
    protected IPackageProcessor packageProcessor;
    protected IDataRequirementsProcessor dataRequirementsProcessor;
    protected IPopulateProcessor populateProcessor;

    public QuestionnaireProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public QuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null, null, null, null);
    }

    public QuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings, IGenerateProcessor generateProcessor, IPackageProcessor packageProcessor, IDataRequirementsProcessor dataRequirementsProcessor, IPopulateProcessor populateProcessor) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.questionnaireResolver = new ResourceResolver("Questionnaire", this.repository);
        this.structureDefResolver = new ResourceResolver("StructureDefinition", this.repository);
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.generateProcessor = generateProcessor;
        this.packageProcessor = packageProcessor;
        this.dataRequirementsProcessor = dataRequirementsProcessor;
        this.populateProcessor = populateProcessor;
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> R resolveQuestionnaire(Either3<C, IIdType, R> questionnaire) {
        return this.questionnaireResolver.resolve(questionnaire);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> R resolveStructureDefinition(Either3<C, IIdType, R> structureDef) {
        return this.structureDefResolver.resolve(structureDef);
    }

    public IBaseResource generateQuestionnaire(String id) {
        return this.generateQuestionnaire(null, id);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile) {
        return this.generateQuestionnaire(profile, false, true);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, boolean supportedOnly, boolean requiredOnly) {
        return this.generateQuestionnaire(profile, supportedOnly, requiredOnly, (IBaseResource)null, null, null);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, boolean supportedOnly, boolean requiredOnly, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint, String id) {
        return this.generateQuestionnaire(profile, supportedOnly, requiredOnly, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint), id);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, boolean supportedOnly, boolean requiredOnly, Repository contentRepository, Repository terminologyRepository, String id) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)true, null, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.generateQuestionnaire(profile, supportedOnly, requiredOnly, id);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, boolean supportedOnly, boolean requiredOnly, String id) {
        GenerateRequest request = new GenerateRequest((IBaseResource)this.resolveStructureDefinition(profile), supportedOnly, requiredOnly, this.modelResolver);
        return this.generateQuestionnaire(request, id);
    }

    public IBaseResource generateQuestionnaire(GenerateRequest request, String id) {
        IGenerateProcessor processor = this.generateProcessor != null ? this.generateProcessor : new GenerateProcessor(this.repository);
        return request == null ? processor.generate(id) : processor.generate(request, id);
    }

    public <C extends IPrimitiveType<String>> IBaseBundle packageQuestionnaire(Either3<C, IIdType, IBaseResource> questionnaire) {
        return this.packageQuestionnaire(questionnaire, false);
    }

    public <C extends IPrimitiveType<String>> IBaseBundle packageQuestionnaire(Either3<C, IIdType, IBaseResource> questionnaire, boolean isPut) {
        return this.packageQuestionnaire(questionnaire, Parameters.newParameters((FhirContext)this.repository.fhirContext(), (String)"package-parameters", (IBase[])new IBase[]{Parameters.newBooleanPart((FhirContext)this.repository.fhirContext(), (String)"isPut", (boolean)isPut, (IBase[])new IBase[0])}));
    }

    public <C extends IPrimitiveType<String>> IBaseBundle packageQuestionnaire(Either3<C, IIdType, IBaseResource> questionnaire, IBaseParameters parameters) {
        return this.packageQuestionnaire(this.resolveQuestionnaire(questionnaire), parameters);
    }

    public IBaseBundle packageQuestionnaire(IBaseResource questionnaire, IBaseParameters parameters) {
        IPackageProcessor processor = this.packageProcessor != null ? this.packageProcessor : new PackageProcessor(this.repository);
        return processor.packageResource(questionnaire, parameters);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource dataRequirements(Either3<C, IIdType, R> questionnaire, IBaseParameters parameters) {
        return this.dataRequirements((IBaseResource)this.resolveQuestionnaire(questionnaire), parameters);
    }

    public IBaseResource dataRequirements(IBaseResource questionnaire, IBaseParameters parameters) {
        IDataRequirementsProcessor processor = this.dataRequirementsProcessor != null ? this.dataRequirementsProcessor : new DataRequirementsProcessor(this.repository);
        return processor.getDataRequirements(questionnaire, parameters);
    }

    public PopulateRequest buildPopulateRequest(IBaseResource questionnaire, String subjectId, List<? extends IBaseBackboneElement> context, IBaseExtension<?, ?> launchContext, IBaseParameters parameters, IBaseBundle data, boolean useServerData, LibraryEngine libraryEngine) {
        if (StringUtils.isBlank((CharSequence)subjectId)) {
            throw new IllegalArgumentException("Missing required parameter: 'subject'");
        }
        return new PopulateRequest(questionnaire, Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)subjectId, (String)SUBJECT_TYPE)), context, launchContext, parameters, data, useServerData, libraryEngine != null ? libraryEngine : new LibraryEngine(this.repository, this.evaluationSettings), this.modelResolver);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource populate(Either3<C, IIdType, R> questionnaire, String subjectId, List<? extends IBaseBackboneElement> context, IBaseExtension<?, ?> launchContext, IBaseParameters parameters, IBaseBundle data, boolean useServerData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.populate(questionnaire, subjectId, context, launchContext, parameters, data, useServerData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource populate(Either3<C, IIdType, R> questionnaire, String subjectId, List<? extends IBaseBackboneElement> context, IBaseExtension<?, ?> launchContext, IBaseParameters parameters, IBaseBundle data, boolean useServerData, Repository dataRepository, Repository contentRepository, Repository terminologyRepository) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.populate(questionnaire, subjectId, context, launchContext, parameters, data, useServerData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource populate(Either3<C, IIdType, R> questionnaire, String subjectId, List<? extends IBaseBackboneElement> context, IBaseExtension<?, ?> launchContext, IBaseParameters parameters, IBaseBundle data, boolean useServerData, LibraryEngine libraryEngine) {
        return this.populate((IBaseResource)this.resolveQuestionnaire(questionnaire), subjectId, context, launchContext, parameters, data, useServerData, libraryEngine);
    }

    public IBaseResource populate(IBaseResource questionnaire, String subjectId, List<? extends IBaseBackboneElement> context, IBaseExtension<?, ?> launchContext, IBaseParameters parameters, IBaseBundle data, boolean useServerData, LibraryEngine libraryEngine) {
        return this.populate(this.buildPopulateRequest(questionnaire, subjectId, context, launchContext, parameters, data, useServerData, libraryEngine));
    }

    public IBaseResource populate(PopulateRequest request) {
        IPopulateProcessor processor = this.populateProcessor != null ? this.populateProcessor : new PopulateProcessor();
        return processor.populate(request);
    }
}

