/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.utility.CqfExpression;

public class ElementHasCaseFeature {
    public IBaseBackboneElement addProperties(GenerateRequest request, CqfExpression caseFeature, ICompositeType element, IBaseBackboneElement questionnaireItem) {
        String elementPath = request.resolvePathString((IBase)element, "path");
        String path = elementPath.substring(elementPath.indexOf(".")).replaceAll("\\[[^\\[]*\\]", "");
        String expression = caseFeature.getName();
        ICompositeType expressionType = this.createExpression(request.getFhirVersion(), "%" + String.format("%s%s", expression, path), caseFeature.getLibraryUrl(), null);
        if (expressionType != null) {
            IBaseExtension initialExpressionExt = questionnaireItem.addExtension();
            initialExpressionExt.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            initialExpressionExt.setValue((IBaseDatatype)expressionType);
        }
        return questionnaireItem;
    }

    private ICompositeType createExpression(FhirVersionEnum fhirVersion, String expression, String libraryRef, String name) {
        switch (fhirVersion) {
            case R4: {
                Expression r4Expression = new Expression().setLanguage("text/cql-expression").setExpression(expression).setName(name);
                if (StringUtils.isNotBlank((CharSequence)libraryRef)) {
                    r4Expression.setReference(libraryRef);
                }
                return r4Expression;
            }
            case R5: {
                org.hl7.fhir.r5.model.Expression r5Expression = new org.hl7.fhir.r5.model.Expression().setLanguage("text/cql-expression").setExpression(expression).setName(name);
                if (StringUtils.isNotBlank((CharSequence)libraryRef)) {
                    r5Expression.setReference(libraryRef);
                }
                return r5Expression;
            }
        }
        return null;
    }
}

