/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate.r5;

import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ElementHasCaseFeature;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ElementHasDefaultValue;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IElementProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.r5.QuestionnaireTypeIsChoice;
import org.opencds.cqf.fhir.utility.CqfExpression;

public class ElementProcessor
implements IElementProcessor {
    protected static final String ITEM_TYPE_ERROR = "Unable to determine type for element: %s";
    protected final QuestionnaireTypeIsChoice questionnaireTypeIsChoice;
    protected final ElementHasDefaultValue elementHasDefaultValue;
    protected final ElementHasCaseFeature elementHasCaseFeature;

    public ElementProcessor(Repository repository) {
        this.questionnaireTypeIsChoice = new QuestionnaireTypeIsChoice(repository);
        this.elementHasDefaultValue = new ElementHasDefaultValue();
        this.elementHasCaseFeature = new ElementHasCaseFeature();
    }

    @Override
    public IBaseBackboneElement processElement(GenerateRequest request, ICompositeType baseElement, String elementType, String childLinkId, CqfExpression caseFeature, Boolean isGroup) {
        ElementDefinition element = (ElementDefinition)baseElement;
        Questionnaire.QuestionnaireItemType itemType = Boolean.TRUE.equals(isGroup) ? Questionnaire.QuestionnaireItemType.GROUP : this.parseItemType(elementType, element.hasBinding());
        Questionnaire.QuestionnaireItemComponent item = this.initializeQuestionnaireItem(itemType, request.getProfileAdapter().getUrl(), element, childLinkId);
        item.setRequired(element.hasMin() && element.getMin() > 0);
        item.setRepeats(element.hasMax() && !element.getMax().equals("1"));
        if (itemType == Questionnaire.QuestionnaireItemType.GROUP) {
            return item;
        }
        if (itemType == Questionnaire.QuestionnaireItemType.QUESTION) {
            this.questionnaireTypeIsChoice.addProperties(element, item);
        }
        if (element.hasFixedOrPattern()) {
            this.elementHasDefaultValue.addProperties(request, (IBaseDatatype)element.getFixedOrPattern(), (IBaseBackboneElement)item);
        } else if (element.hasDefaultValue()) {
            this.elementHasDefaultValue.addProperties(request, (IBaseDatatype)element.getDefaultValue(), (IBaseBackboneElement)item);
        } else if (caseFeature != null) {
            this.elementHasCaseFeature.addProperties(request, caseFeature, baseElement, (IBaseBackboneElement)item);
        }
        return item;
    }

    protected Questionnaire.QuestionnaireItemComponent initializeQuestionnaireItem(Questionnaire.QuestionnaireItemType itemType, String profileUrl, ElementDefinition element, String childLinkId) {
        String definition = profileUrl + "#" + element.getPath();
        return new Questionnaire.QuestionnaireItemComponent().setType(itemType).setDefinition(definition).setLinkId(childLinkId).setText(this.getElementText(element));
    }

    public Questionnaire.QuestionnaireItemType parseItemType(String elementType, Boolean hasBinding) {
        if (Boolean.TRUE.equals(hasBinding)) {
            return Questionnaire.QuestionnaireItemType.QUESTION;
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Unable to determine item type.");
        }
        switch (elementType) {
            case "code": 
            case "coding": 
            case "CodeableConcept": {
                return Questionnaire.QuestionnaireItemType.QUESTION;
            }
            case "uri": 
            case "url": 
            case "canonical": {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case "BackboneElement": {
                return Questionnaire.QuestionnaireItemType.GROUP;
            }
            case "Quantity": {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
            case "Reference": {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case "oid": 
            case "uuid": 
            case "base64Binary": {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case "positiveInt": 
            case "unsignedInt": {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case "instant": {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
        }
        return Questionnaire.QuestionnaireItemType.fromCode((String)elementType);
    }

    public String getElementText(ElementDefinition element) {
        return element.hasLabel() ? element.getLabel() : this.getElementDescription(element);
    }

    protected String getElementDescription(ElementDefinition element) {
        return element.hasShort() ? element.getShort() : element.getPath();
    }
}

