/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;
import org.opencds.cqf.fhir.cr.inputparameters.IInputParameterResolver;
import org.opencds.cqf.fhir.utility.adapter.QuestionnaireAdapter;

public class PopulateRequest
implements IQuestionnaireRequest {
    private final IBaseResource questionnaire;
    private final IIdType subjectId;
    private final List<? extends IBaseBackboneElement> context;
    private final List<IBaseExtension<?, ?>> launchContext;
    private final IBaseParameters parameters;
    private final IBaseBundle data;
    private final boolean useServerData;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final String defaultLibraryUrl;
    private final IInputParameterResolver inputParameterResolver;
    private final QuestionnaireAdapter questionnaireAdapter;
    private IBaseOperationOutcome operationOutcome;

    public PopulateRequest(IBaseResource questionnaire, IIdType subjectId, List<? extends IBaseBackboneElement> context, IBaseExtension<?, ?> launchContext, IBaseParameters parameters, IBaseBundle data, boolean useServerData, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)questionnaire, (Object)"expected non-null value for questionnaire");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.questionnaire = questionnaire;
        this.subjectId = subjectId;
        this.context = context;
        this.parameters = parameters;
        this.data = data;
        this.useServerData = useServerData;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.launchContext = this.getExtensionsByUrl((IBase)this.questionnaire, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext");
        if (launchContext != null) {
            this.launchContext.add(launchContext);
        }
        this.fhirVersion = questionnaire.getStructureFhirVersionEnum();
        this.defaultLibraryUrl = this.resolveDefaultLibraryUrl();
        this.questionnaireAdapter = (QuestionnaireAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)this.questionnaire);
        this.inputParameterResolver = IInputParameterResolver.createResolver(libraryEngine.getRepository(), this.subjectId, null, null, this.parameters, this.useServerData, this.data, this.context, this.launchContext);
    }

    @Override
    public String getOperationName() {
        return "populate";
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public QuestionnaireAdapter getQuestionnaireAdapter() {
        return this.questionnaireAdapter;
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public boolean getUseServerData() {
        return this.useServerData;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.inputParameterResolver.getParameters();
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    protected final String resolveDefaultLibraryUrl() {
        IBaseExtension libraryExt = this.getExtensions((IBase)this.questionnaire).stream().filter(e -> e.getUrl().equals(this.fhirVersion == FhirVersionEnum.DSTU3 ? "http://hl7.org/fhir/StructureDefinition/cqif-library" : "http://hl7.org/fhir/StructureDefinition/cqf-library")).findFirst().orElse(null);
        return libraryExt == null ? null : (String)((IPrimitiveType)libraryExt.getValue()).getValue();
    }

    public void addContextParameter(String name, IBaseResource resource) {
        this.getAdapterFactory().createParameters(this.getParameters()).addParameter(name, resource);
    }
}

