/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ItemPair;
import org.opencds.cqf.fhir.utility.adapter.QuestionnaireAdapter;

public class ExtractRequest
implements IQuestionnaireRequest {
    private final IBaseResource questionnaireResponse;
    private final IBaseResource questionnaire;
    private final IIdType subjectId;
    private final IBaseParameters parameters;
    private final IBaseBundle data;
    private final boolean useServerData;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirContext fhirContext;
    private final FhirVersionEnum fhirVersion;
    private final String defaultLibraryUrl;
    private IBaseOperationOutcome operationOutcome;
    private QuestionnaireAdapter questionnaireAdapter;

    public ExtractRequest(IBaseResource questionnaireResponse, IBaseResource questionnaire, IIdType subjectId, IBaseParameters parameters, IBaseBundle bundle, boolean useServerData, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)questionnaireResponse, (Object)"expected non-null value for questionnaireResponse");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.questionnaireResponse = questionnaireResponse;
        this.questionnaire = questionnaire;
        this.subjectId = subjectId;
        this.parameters = parameters;
        this.data = bundle;
        this.useServerData = useServerData;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.fhirContext = this.libraryEngine.getRepository().fhirContext();
        this.fhirVersion = this.questionnaireResponse.getStructureFhirVersionEnum();
        this.defaultLibraryUrl = "";
    }

    public IBaseResource getQuestionnaireResponse() {
        return this.questionnaireResponse;
    }

    public boolean hasQuestionnaire() {
        return this.questionnaire != null;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public QuestionnaireAdapter getQuestionnaireAdapter() {
        if (this.questionnaireAdapter == null && this.questionnaire != null) {
            this.questionnaireAdapter = (QuestionnaireAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)this.questionnaire);
        }
        return this.questionnaireAdapter;
    }

    public IBaseBackboneElement getQuestionnaireItem(IBaseBackboneElement item) {
        return this.hasQuestionnaire() ? this.getQuestionnaireItem(item, this.getItems((IBase)this.getQuestionnaire())) : null;
    }

    public IBaseBackboneElement getQuestionnaireItem(IBaseBackboneElement item, List<IBaseBackboneElement> qItems) {
        return qItems != null ? (IBaseBackboneElement)qItems.stream().filter(i -> this.getItemLinkId((IBaseBackboneElement)i).equals(this.getItemLinkId(item))).findFirst().orElse(null) : null;
    }

    public boolean isDefinitionItem(ItemPair item) {
        return this.hasExtension((IBase)(item.getItem() == null ? item.getResponseItem() : item.getItem()), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext") || StringUtils.isNotBlank((CharSequence)this.resolvePathString((IBase)(item.getItem() == null ? item.getResponseItem() : item.getItem()), "definition"));
    }

    public IBaseExtension<?, ?> getItemExtractionContext() {
        IBaseExtension qrExt = this.getExtensions((IBase)this.questionnaireResponse).stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext")).findFirst().orElse(null);
        if (qrExt != null) {
            return qrExt;
        }
        return this.questionnaire == null ? null : (IBaseExtension)this.getExtensions((IBase)this.questionnaire).stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext")).findFirst().orElse(null);
    }

    public String getExtractId() {
        return "extract-" + this.questionnaireResponse.getIdElement().getIdPart();
    }

    @Override
    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Override
    public String getOperationName() {
        return "extract";
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public boolean getUseServerData() {
        return this.useServerData;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.parameters;
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }
}

