/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import ca.uhn.fhir.context.BaseRuntimeChildDatatypeDefinition;
import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildCompositeDatatypeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ItemPair;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionItem {
    protected static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionItem.class);
    final ExpressionProcessor expressionProcessor;

    public ProcessDefinitionItem() {
        this(new ExpressionProcessor());
    }

    public ProcessDefinitionItem(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    public void processDefinitionItem(ExtractRequest request, ItemPair item, List<IBaseResource> resources, IBaseReference subject) {
        String linkId = request.getItemLinkId(item.getResponseItem());
        ImmutablePair<String, List<IBaseResource>> context = this.getContext(request, linkId, this.getContextExtension(request, item));
        String resourceType = (String)context.left;
        List contextResource = (List)context.right;
        String definition = this.getDefinition(request, item.getResponseItem(), item.getItem());
        if (resourceType == null && (contextResource == null || contextResource.isEmpty())) {
            if (definition == null) {
                throw new IllegalArgumentException(String.format("Unable to retrieve definition for item: %s", linkId));
            }
            resourceType = this.getDefinitionType(definition);
        }
        if (contextResource != null && contextResource.size() > 1) {
            contextResource.forEach(r -> this.processResource(request, (IBaseResource)r, false, definition, item, resources, subject));
        } else {
            boolean isCreatedResource = true;
            IBaseResource resource = null;
            if (contextResource != null && !contextResource.isEmpty()) {
                resource = (IBaseResource)contextResource.get(0);
                isCreatedResource = false;
            } else {
                resource = (IBaseResource)this.newValue(request, resourceType);
            }
            this.processResource(request, resource, isCreatedResource, definition, item, resources, subject);
        }
    }

    private IBaseExtension<?, ?> getContextExtension(ExtractRequest request, ItemPair item) {
        Object element = request.hasExtension((IBase)item.getItem(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext") ? item.getItem() : (request.hasExtension((IBase)item.getResponseItem(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext") ? item.getResponseItem() : request.getQuestionnaire());
        return request.getExtensionByUrl((IBase)element, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext");
    }

    private ImmutablePair<String, List<IBaseResource>> getContext(ExtractRequest request, String linkId, IBaseExtension<?, ?> contextExtension) {
        String resourceType = null;
        List context = null;
        if (contextExtension != null) {
            CqfExpression contextExpression;
            IBaseDatatype contextValue = contextExtension.getValue();
            if (contextValue instanceof IPrimitiveType) {
                resourceType = ((IPrimitiveType)contextValue).getValueAsString();
            } else if (contextValue instanceof ICompositeType && (contextExpression = CqfExpression.of(contextExtension, (String)request.getDefaultLibraryUrl())) != null) {
                try {
                    context = this.expressionProcessor.getExpressionResultForItem(request, contextExpression, linkId).stream().map(r -> (IBaseResource)r).collect(Collectors.toList());
                }
                catch (Exception e) {
                    String message = String.format("Error encountered processing item %s: Error resolving context expression %s: %s", linkId, contextExpression.getExpression(), e.getMessage());
                    logger.error(message);
                    throw new IllegalArgumentException(message);
                }
            }
        }
        return new ImmutablePair(resourceType, context);
    }

    private void processResource(ExtractRequest request, IBaseResource resource, boolean isCreatedResource, String definition, ItemPair item, List<IBaseResource> resources, IBaseReference subject) {
        BaseRuntimeElementDefinition resourceDefinition = request.getFhirContext().getElementDefinition(resource.getClass());
        if (isCreatedResource) {
            String linkId = request.getItemLinkId(item.getResponseItem());
            String id = request.getExtractId();
            if (StringUtils.isNotBlank((CharSequence)linkId)) {
                id = id.concat(String.format("-%s", linkId));
            }
            resource.setId((IIdType)new IdType(resource.fhirType(), id));
            this.resolveMeta(resource, definition);
            this.resolveSubject(request, resource, subject, resourceDefinition);
            this.resolveAuthored(request, linkId, resource, resourceDefinition);
        }
        this.processChildren(request, resourceDefinition, resource, request.getItems((IBase)(item.getResponseItem() == null ? request.getQuestionnaireResponse() : item.getResponseItem())), request.getItems((IBase)(item.getItem() == null ? request.getQuestionnaire() : item.getItem())));
        resources.add(resource);
    }

    private void resolveSubject(ExtractRequest request, IBaseResource resource, IBaseReference subject, BaseRuntimeElementDefinition<?> resourceDefinition) {
        String subjectPath = this.getSubjectPath(resourceDefinition);
        if (subjectPath != null) {
            request.getModelResolver().setValue((Object)resource, subjectPath, (Object)subject);
        }
    }

    private void resolveAuthored(ExtractRequest request, String linkId, IBaseResource resource, BaseRuntimeElementDefinition<?> resourceDefinition) {
        List<BaseRuntimeChildDatatypeDefinition> dateDefs;
        IPrimitiveType dateAuthored;
        IBase authorValue;
        String authorPath = this.getAuthorPath(resourceDefinition);
        if (authorPath != null && (authorValue = request.resolvePath((IBase)request.getQuestionnaireResponse(), "author")) != null) {
            request.getModelResolver().setValue((Object)resource, authorPath, (Object)authorValue);
        }
        if ((dateAuthored = request.resolvePath((IBase)request.getQuestionnaireResponse(), "authored", IPrimitiveType.class)) != null && (dateDefs = this.getDateDefs(resourceDefinition)) != null && !dateDefs.isEmpty()) {
            dateDefs.forEach(dateDef -> {
                try {
                    IBase authoredValue = (IBase)dateDef.getDatatype().getConstructor(String.class).newInstance(dateAuthored.getValueAsString());
                    request.getModelResolver().setValue((Object)resource, dateDef.getElementName(), (Object)authoredValue);
                }
                catch (Exception ex) {
                    String message = String.format("Error encountered processing item %s: Error setting property (%s) on resource type (%s): %s", linkId, dateDef.getElementName(), resource.fhirType(), ex.getMessage());
                    logger.error(message);
                    request.logException(message);
                }
            });
        }
    }

    private void processChildren(ExtractRequest request, BaseRuntimeElementDefinition<?> resourceDefinition, IBaseResource resource, List<IBaseBackboneElement> items, List<IBaseBackboneElement> questionnaireItems) {
        items.forEach(childItem -> {
            IBaseBackboneElement questionnaireItem = questionnaireItems.stream().filter(i -> request.getItemLinkId((IBaseBackboneElement)i).equals(request.getItemLinkId((IBaseBackboneElement)childItem))).findFirst().orElse(null);
            String childDefinition = this.getDefinition(request, (IBaseBackboneElement)childItem, questionnaireItem);
            if (childDefinition != null) {
                String path = childDefinition.split("#")[1];
                path = path.replace(resource.fhirType() + ".", "");
                List<IBaseBackboneElement> children = request.getItems((IBase)childItem);
                if (!children.isEmpty()) {
                    this.processChildren(request, resourceDefinition, resource, children, request.getItems((IBase)resource));
                } else {
                    this.processChild(request, resourceDefinition, resource, (IBaseBackboneElement)childItem, path);
                }
            }
        });
    }

    private void processChild(ExtractRequest request, BaseRuntimeElementDefinition<?> resourceDefinition, IBaseResource resource, IBaseBackboneElement childItem, String path) {
        IBase answerValue;
        List<IBaseBackboneElement> answers = request.resolvePathList((IBase)childItem, "answer", IBaseBackboneElement.class);
        IBase iBase = answerValue = answers.isEmpty() ? null : request.resolvePath((IBase)answers.get(0), "value");
        if (answerValue != null) {
            BaseRuntimeDeclaredChildDefinition pathDefinition = (BaseRuntimeDeclaredChildDefinition)resourceDefinition.getChildByName(path);
            if (pathDefinition instanceof RuntimeChildChoiceDefinition) {
                List choices = ((RuntimeChildChoiceDefinition)pathDefinition).getChoices();
                if (!choices.contains(answerValue.getClass())) {
                    answerValue = ItemValueTransformer.transformValueToResource(request.getFhirVersion(), answerValue);
                }
            } else if (pathDefinition instanceof RuntimeChildCompositeDatatypeDefinition && !pathDefinition.getField().getType().equals(answerValue.getClass())) {
                answerValue = ItemValueTransformer.transformValueToResource(request.getFhirVersion(), answerValue);
            }
            request.getModelResolver().setValue((Object)resource, path, (Object)answerValue);
        }
    }

    private String getDefinition(ExtractRequest request, IBaseBackboneElement responseItem, IBaseBackboneElement questionnaireItem) {
        String definition = request.resolvePathString((IBase)questionnaireItem, "definition");
        if (definition == null) {
            definition = request.resolvePathString((IBase)responseItem, "definition");
        }
        return definition;
    }

    private String getDefinitionType(String definition) {
        if (!definition.contains("#")) {
            throw new IllegalArgumentException(String.format("Unable to determine resource type from item definition: %s", definition));
        }
        return definition.split("#")[1];
    }

    private String getSubjectPath(BaseRuntimeElementDefinition<?> definition) {
        if (definition.getChildByName("subject") != null) {
            return "subject";
        }
        return definition.getChildByName("patient") != null ? "patient" : null;
    }

    private String getAuthorPath(BaseRuntimeElementDefinition<?> definition) {
        if (definition.getChildByName("recorder") != null) {
            return "recorder";
        }
        return definition.getName().equals("Observation") ? "performer" : null;
    }

    private List<BaseRuntimeChildDatatypeDefinition> getDateDefs(BaseRuntimeElementDefinition<?> definition) {
        ArrayList<BaseRuntimeChildDefinition> results = new ArrayList<BaseRuntimeChildDefinition>();
        results.add(definition.getChildByName("onset"));
        results.add(definition.getChildByName("issued"));
        results.add(definition.getChildByName("effective"));
        results.add(definition.getChildByName("recordDate"));
        return results.stream().filter(BaseRuntimeChildDatatypeDefinition.class::isInstance).map(d -> (BaseRuntimeChildDatatypeDefinition)d).collect(Collectors.toList());
    }

    private void resolveMeta(IBaseResource resource, String definition) {
        IBaseMetaType meta = resource.getMeta();
        if (definition != null && !definition.isEmpty()) {
            meta.addProfile(definition.split("#")[0]);
        }
    }

    private IBase newValue(ExtractRequest request, String type) {
        try {
            return (IBase)Class.forName(String.format("org.hl7.fhir.%s.model.%s", request.getFhirVersion().toString().toLowerCase(), type)).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

