/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract.r5;

import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;

public class ObservationResolver {
    public IBaseResource resolve(ExtractRequest request, IBaseBackboneElement baseAnswer, IBaseBackboneElement baseItem, String linkId, IBaseReference subject, Map<String, List<IBaseCoding>> questionnaireCodeMap, IBaseExtension<?, ?> categoryExt) {
        QuestionnaireResponse questionnaireResponse = (QuestionnaireResponse)request.getQuestionnaireResponse();
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent answer = (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent)baseAnswer;
        Questionnaire.QuestionnaireItemComponent item = (Questionnaire.QuestionnaireItemComponent)baseItem;
        Observation obs = new Observation();
        obs.setId(request.getExtractId() + "." + linkId);
        obs.setBasedOn(questionnaireResponse.getBasedOn());
        obs.setPartOf(questionnaireResponse.getPartOf());
        obs.setStatus(Enumerations.ObservationStatus.FINAL);
        CodeableConcept qrCategoryCode = categoryExt == null ? new CodeableConcept().addCoding(new Coding().setSystem("http://hl7.org/fhir/observation-category").setCode("survey")) : (CodeableConcept)categoryExt.getValue();
        obs.setCategory(Collections.singletonList(qrCategoryCode));
        obs.setCode(new CodeableConcept().setCoding(questionnaireCodeMap.get(linkId).stream().map(c -> (Coding)c).collect(Collectors.toList())));
        obs.setSubject((Reference)subject);
        obs.setEncounter(questionnaireResponse.getEncounter());
        DateTimeType authoredDate = new DateTimeType((questionnaireResponse.hasAuthored() ? questionnaireResponse.getAuthored().toInstant() : Instant.now()).toString());
        obs.setEffective((DataType)authoredDate);
        obs.setIssuedElement(new InstantType((BaseDateTimeType)authoredDate));
        obs.setPerformer(Collections.singletonList(questionnaireResponse.getAuthor()));
        switch (answer.getValue().fhirType()) {
            case "Coding": {
                obs.setValue((DataType)new CodeableConcept().addCoding(answer.getValueCoding()));
                break;
            }
            case "date": {
                obs.setValue((DataType)new DateTimeType((Date)((DateType)answer.getValue()).getValue()));
                break;
            }
            case "decimal": 
            case "integer": {
                if (item.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-unit")) {
                    obs.setValue((DataType)this.getQuantity(answer, item));
                    break;
                }
                obs.setValue(answer.getValue());
                break;
            }
            default: {
                obs.setValue(answer.getValue());
            }
        }
        obs.setDerivedFrom(Collections.singletonList(new Reference((IAnyResource)questionnaireResponse)));
        Extension linkIdExtension = new Extension();
        linkIdExtension.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/derivedFromLinkId");
        Extension innerLinkIdExtension = new Extension();
        innerLinkIdExtension.setUrl("text");
        innerLinkIdExtension.setValue((DataType)new StringType(linkId));
        linkIdExtension.setExtension(Collections.singletonList(innerLinkIdExtension));
        obs.addExtension(linkIdExtension);
        return obs;
    }

    protected Quantity getQuantity(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent answer, Questionnaire.QuestionnaireItemComponent item) {
        Coding unit = (Coding)item.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-unit").getValue();
        Quantity quantity = new Quantity().setUnit(unit.getDisplay()).setSystem(unit.getSystem()).setCode(unit.getCode());
        if (answer.hasValueDecimalType()) {
            quantity.setValueElement(answer.getValueDecimalType());
        }
        if (answer.hasValueIntegerType()) {
            quantity.setValue((long)((Integer)answer.getValueIntegerType().getValue()).intValue());
        }
        return quantity;
    }
}

