/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r5;

import com.google.common.base.Preconditions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.Reference;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class MedicationRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public MedicationRequestResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public MedicationRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        MedicationRequest medicationRequest = new MedicationRequest();
        medicationRequest.setStatus(MedicationRequest.MedicationrequestStatus.DRAFT);
        medicationRequest.setIntent(this.activityDefinition.hasIntent() ? MedicationRequest.MedicationRequestIntent.fromCode((String)this.activityDefinition.getIntent().toCode()) : MedicationRequest.MedicationRequestIntent.ORDER);
        medicationRequest.setSubject(new Reference(request.getSubjectId()));
        if (request.hasEncounterId()) {
            medicationRequest.setEncounter(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            medicationRequest.setRequester(new Reference(request.getPractitionerId()));
        }
        if (this.activityDefinition.hasProductCodeableConcept()) {
            medicationRequest.setMedication(new CodeableReference(this.activityDefinition.getProductCodeableConcept()));
        } else if (this.activityDefinition.hasProductReference()) {
            medicationRequest.setMedication(new CodeableReference(this.activityDefinition.getProductReference()));
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException(String.format("Missing required ActivityDefinition.product property for %s", "MedicationRequest"));
        }
        if (this.activityDefinition.hasDosage()) {
            this.activityDefinition.getDosage().forEach(arg_0 -> ((MedicationRequest)medicationRequest).addDosageInstruction(arg_0));
        }
        if (this.activityDefinition.hasDoNotPerform()) {
            medicationRequest.setDoNotPerform(this.activityDefinition.getDoNotPerform());
        }
        return medicationRequest;
    }
}

