/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r5;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class ServiceRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public ServiceRequestResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public ServiceRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.setStatus(Enumerations.RequestStatus.DRAFT);
        serviceRequest.setIntent(this.activityDefinition.hasIntent() ? Enumerations.RequestIntent.fromCode((String)this.activityDefinition.getIntent().toCode()) : Enumerations.RequestIntent.ORDER);
        serviceRequest.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            serviceRequest.setInstantiatesCanonical(Collections.singletonList(new CanonicalType(this.activityDefinition.getUrl() + (this.activityDefinition.hasVersion() ? String.format("|%s", this.activityDefinition.getVersion()) : ""))));
        }
        if (request.hasEncounterId()) {
            serviceRequest.setEncounter(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            serviceRequest.setRequester(new Reference(request.getPractitionerId()));
        } else if (request.hasOrganizationId()) {
            serviceRequest.setRequester(new Reference(request.getOrganizationId()));
        }
        if (this.activityDefinition.hasCode()) {
            serviceRequest.setCode(new CodeableReference(this.activityDefinition.getCode()));
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException(String.format("Missing required ActivityDefinition.code property for %s", "ServiceRequest"));
        }
        if (this.activityDefinition.hasBodySite()) {
            serviceRequest.setBodySite(this.activityDefinition.getBodySite());
        }
        if (this.activityDefinition.hasDoNotPerform()) {
            serviceRequest.setDoNotPerform(this.activityDefinition.getDoNotPerform());
        }
        return serviceRequest;
    }
}

