/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;

public interface ICqlOperationRequest
extends IOperationRequest {
    public IIdType getSubjectId();

    public IBaseParameters getParameters();

    public boolean getUseServerData();

    public IBaseBundle getData();

    public LibraryEngine getLibraryEngine();

    @Override
    default public Repository getRepository() {
        return this.getLibraryEngine().getRepository();
    }

    default public void resolvePrefetchData(IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData) {
        IAdapterFactory factory = this.getAdapterFactory();
        prefetchData.stream().map(arg_0 -> ((IAdapterFactory)factory).createParametersParameters(arg_0)).map(p -> p.getPartValues("data")).filter(IBaseBundle.class::isInstance).flatMap(b -> BundleHelper.getEntryResources((IBaseBundle)((IBaseBundle)b)).stream()).forEach(r -> BundleHelper.addEntry((IBaseBundle)data, (IBaseBackboneElement)BundleHelper.newEntryWithResource((IBaseResource)r)));
    }
}

