/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.cr.common.ICqlOperationRequest;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;

public interface IQuestionnaireRequest
extends ICqlOperationRequest {
    public IBaseResource getQuestionnaire();

    public IQuestionnaireAdapter getQuestionnaireAdapter();

    default public void addQuestionnaireItem(IBaseBackboneElement item) {
        this.getModelResolver().setValue((Object)this.getQuestionnaire(), "item", Collections.singletonList(item));
    }

    default public <T extends IBaseExtension<?, ?>> void addLaunchContextExtensions(List<T> launchContextExts) {
        if (launchContextExts != null && !launchContextExts.isEmpty()) {
            launchContextExts.forEach(e -> {
                boolean exists;
                String code = e.getExtension().stream().map(c -> (IBaseExtension)c).filter(c -> c.getUrl().equals("name")).map(c -> this.resolvePathString((IBase)c.getValue(), "code")).findFirst().orElse(null);
                if (StringUtils.isNotBlank((CharSequence)code) && !(exists = this.getQuestionnaireAdapter().getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext").stream().anyMatch(lc -> lc.getExtension().stream().map(c -> (IBaseExtension)c).anyMatch(c -> c.getUrl().equals("name") && this.resolvePathString((IBase)c.getValue(), "code").equals(code))))) {
                    this.getQuestionnaireAdapter().addExtension(e);
                }
            });
        }
    }

    default public void addCqlLibraryExtension() {
        this.addCqlLibraryExtension(null);
    }

    default public void addCqlLibraryExtension(String library) {
        String libraryRef;
        String string = libraryRef = StringUtils.isNotBlank((CharSequence)library) ? library : this.getDefaultLibraryUrl();
        if (StringUtils.isNotBlank((CharSequence)libraryRef) && this.getExtensionsByUrl((IBase)this.getQuestionnaire(), "http://hl7.org/fhir/StructureDefinition/cqf-library").stream().noneMatch(e -> ((IPrimitiveType)e.getValue()).getValueAsString().equals(libraryRef))) {
            IBaseExtension libraryExt = ((IDomainResource)this.getQuestionnaire()).addExtension();
            libraryExt.setUrl("http://hl7.org/fhir/StructureDefinition/cqf-library");
            libraryExt.setValue((IBaseDatatype)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)this.getFhirVersion(), (String)libraryRef));
        }
    }

    default public List<IBaseBackboneElement> getItems(IBase base) {
        return this.resolvePathList(base, "item", IBaseBackboneElement.class);
    }

    default public boolean hasItems(IBase base) {
        return !this.getItems(base).isEmpty();
    }

    default public String getItemLinkId(IBaseBackboneElement item) {
        return this.resolvePathString((IBase)item, "linkId");
    }
}

