/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.library.evaluate;

import ca.uhn.fhir.context.FhirContext;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cr.library.evaluate.EvaluateRequest;
import org.opencds.cqf.fhir.cr.library.evaluate.IEvaluateProcessor;
import org.opencds.cqf.fhir.utility.Parameters;

public class EvaluateProcessor
implements IEvaluateProcessor {
    protected Repository repository;
    protected EvaluationSettings evaluationSettings;

    public EvaluateProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this.repository = repository;
        this.evaluationSettings = evaluationSettings;
    }

    @Override
    public IBaseParameters evaluate(EvaluateRequest request) {
        try {
            return request.getLibraryEngine().evaluate(request.getDefaultLibraryUrl(), request.getSubject(), request.getParameters(), request.getData(), null, request.getExpression());
        }
        catch (Exception e) {
            request.logException(e.getMessage());
            return Parameters.newParameters((FhirContext)this.repository.fhirContext(), (IBase[])new IBase[]{Parameters.newPart((FhirContext)this.repository.fhirContext(), (String)"evaluation error", (IBaseResource)request.getOperationOutcome(), (IBase[])new IBase[0])});
        }
    }
}

