/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverter;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;

public class MeasureOperationParameterConverter {
    protected IAdapterFactory adapterFactory;
    protected FhirTypeConverter fhirTypeConverter;

    public MeasureOperationParameterConverter(IAdapterFactory adapterFactory, FhirTypeConverter fhirTypeConverter) {
        this.adapterFactory = adapterFactory;
        this.fhirTypeConverter = fhirTypeConverter;
    }

    public void addMeasurementPeriod(IBaseParameters parameters, String periodStart, String periodEnd) {
        Objects.requireNonNull(parameters);
        if (periodStart == null || periodEnd == null) {
            return;
        }
        ICompositeType measurementPeriodFhir = this.fhirTypeConverter.toFhirPeriod(new Interval((Object)new Date(periodStart), true, (Object)new Date(periodEnd), true));
        this.addChild(parameters, "Measurement Period", (IBaseDatatype)measurementPeriodFhir);
    }

    public void addProductLine(IBaseParameters parameters, String productLine) {
        Objects.requireNonNull(parameters);
        if (productLine == null) {
            return;
        }
        IPrimitiveType productLineFhir = this.fhirTypeConverter.toFhirString(productLine);
        this.addChild(parameters, "Product Line", (IBaseDatatype)productLineFhir);
    }

    protected void addChild(IBaseParameters parameters, String name, IBaseDatatype value) {
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters(x)).collect(Collectors.toList());
        IParametersParameterComponentAdapter part = parts.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (part == null) {
            part = this.adapterFactory.createParametersParameters(parametersAdapter.addParameter());
        }
        part.setName(name);
        part.setResource(null);
        part.setValue(value);
    }
}

