/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.dstu3;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.cr.measure.common.CriteriaResult;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureInfo;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3MeasureReportScorer;

public class Dstu3MeasureReportBuilder
implements MeasureReportBuilder<Measure, MeasureReport, DomainResource> {
    protected static final String POPULATION_SUBJECT_SET = "POPULATION_SUBJECT_SET";
    protected static final String EXT_POPULATION_DESCRIPTION_URL = "http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.population.description";
    protected static final String EXT_SDE_REFERENCE_URL = "http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.supplementalDataElement.reference";
    protected static final String POPULATION_BASIS_URL = "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis";
    protected MeasureReportScorer<MeasureReport> measureReportScorer = new Dstu3MeasureReportScorer();
    protected Measure measure = null;
    protected MeasureReport report = null;
    protected HashMap<String, Reference> evaluatedResourceReferences = null;

    protected void reset() {
        this.measure = null;
        this.report = null;
        this.evaluatedResourceReferences = null;
    }

    @Override
    public MeasureReport build(Measure measure, MeasureDef measureDef, MeasureReportType measureReportType, Interval measurementPeriod, List<String> subjectIds) {
        this.reset();
        this.measure = measure;
        this.report = this.createMeasureReport(measure, measureDef, measureReportType, subjectIds, measurementPeriod);
        this.buildGroups(measure, measureDef);
        this.processSdes(measure, measureDef, subjectIds);
        this.measureReportScorer.score(measure.getUrl(), measureDef, this.report);
        if (measureReportType == MeasureReportType.INDIVIDUAL) {
            ListResource references = this.createReferenceList("evaluated-resources-references", this.getEvaluatedResourceReferences().values());
            this.report.addContained((Resource)references);
            this.report.setEvaluatedResources(new Reference("#" + references.getId()));
        }
        return this.report;
    }

    protected void buildGroups(Measure measure, MeasureDef measureDef) {
        if (measure.getGroup().size() != measureDef.groups().size()) {
            throw new IllegalArgumentException("The Measure has a different number of groups defined than the MeasureDef");
        }
        for (int i = 0; i < measure.getGroup().size(); ++i) {
            Measure.MeasureGroupComponent mgc = (Measure.MeasureGroupComponent)measure.getGroup().get(i);
            String groupKey = this.getKey("group", mgc.getId(), null, i);
            this.buildGroup(measureDef, groupKey, mgc, this.report.addGroup(), measureDef.groups().get(i));
        }
    }

    protected void buildGroup(MeasureDef measureDef, String groupKey, Measure.MeasureGroupComponent measureGroup, MeasureReport.MeasureReportGroupComponent reportGroup, GroupDef groupDef) {
        if (measureGroup.getPopulation().size() != groupDef.populations().size()) {
            throw new IllegalArgumentException("The MeasureGroup has a different number of populations defined than the GroupDef");
        }
        if (measureGroup.getStratifier().size() != groupDef.stratifiers().size()) {
            throw new IllegalArgumentException("The MeasureGroup has a different number of stratifiers defined than the GroupDef");
        }
        reportGroup.setId(measureGroup.getId());
        if (measureGroup.hasDescription()) {
            reportGroup.addExtension(this.createStringExtension(EXT_POPULATION_DESCRIPTION_URL, measureGroup.getDescription()));
        }
        for (Measure.MeasureGroupPopulationComponent mgpc : measureGroup.getPopulation()) {
            this.buildPopulation(measureDef, groupKey, mgpc, reportGroup.addPopulation(), groupDef.getSingle(MeasurePopulationType.fromCode(mgpc.getCode().getCodingFirstRep().getCode())));
        }
        for (int i = 0; i < measureGroup.getStratifier().size(); ++i) {
            this.buildStratifier(groupKey, i, (Measure.MeasureGroupStratifierComponent)measureGroup.getStratifier().get(i), reportGroup.addStratifier(), groupDef.stratifiers().get(i), measureGroup.getPopulation());
        }
    }

    protected String getKey(String prefix, String id, CodeableConcept code, Integer index) {
        if (id != null) {
            return prefix + "-" + id;
        }
        if (code != null && code.hasText()) {
            return prefix + "-" + this.escapeForFhirId(code.getText());
        }
        return prefix + "-" + Integer.toString(index + 1);
    }

    protected void buildStratifier(String groupKey, Integer stratIndex, Measure.MeasureGroupStratifierComponent measureStratifier, MeasureReport.MeasureReportGroupStratifierComponent reportStratifier, StratifierDef stratifierDef, List<Measure.MeasureGroupPopulationComponent> populations) {
        reportStratifier.setId(measureStratifier.getId());
        String stratifierKey = this.getKey("stratifier", measureStratifier.getId(), null, stratIndex);
        Map<String, CriteriaResult> subjectValues = stratifierDef.getResults();
        Map<ValueWrapper, List<String>> subjectsByValue = subjectValues.keySet().stream().collect(Collectors.groupingBy(x -> new ValueWrapper(((CriteriaResult)subjectValues.get(x)).rawValue())));
        for (Map.Entry<ValueWrapper, List<String>> stratValue : subjectsByValue.entrySet()) {
            this.buildStratum(groupKey, stratifierKey, reportStratifier.addStratum(), stratValue.getKey(), stratValue.getValue(), populations);
        }
    }

    protected void buildStratum(String groupKey, String stratifierKey, MeasureReport.StratifierGroupComponent stratum, ValueWrapper value, List<String> subjectIds, List<Measure.MeasureGroupPopulationComponent> populations) {
        String stratumKey = this.escapeForFhirId(value.getKey());
        stratum.setValue(value.getValueAsString());
        for (Measure.MeasureGroupPopulationComponent mgpc : populations) {
            this.buildStratumPopulation(groupKey, stratifierKey, stratumKey, stratum.addPopulation(), subjectIds, mgpc);
        }
    }

    protected void buildStratumPopulation(String groupKey, String stratifierKey, String stratumKey, MeasureReport.StratifierGroupPopulationComponent sgpc, List<String> subjectIds, Measure.MeasureGroupPopulationComponent population) {
        Set popSubjectIds;
        sgpc.setCode(population.getCode());
        sgpc.setId(population.getId());
        if (population.hasDescription()) {
            sgpc.addExtension(this.createStringExtension(EXT_POPULATION_DESCRIPTION_URL, population.getDescription()));
        }
        if ((popSubjectIds = (Set)population.getUserData(POPULATION_SUBJECT_SET)) == null) {
            sgpc.setCount(0);
            return;
        }
        HashSet<String> intersection = new HashSet<String>(subjectIds);
        intersection.retainAll(popSubjectIds);
        sgpc.setCount(intersection.size());
        if (intersection.size() > 0 && this.report.getType() == MeasureReport.MeasureReportType.PATIENTLIST) {
            ListResource popSubjectList = this.createIdList("subject-list-" + groupKey + "-" + stratifierKey + "-stratum-" + stratumKey + "-" + population.getCode().getCodingFirstRep().getCode(), intersection);
            this.report.addContained((Resource)popSubjectList);
            sgpc.setPatients(new Reference().setReference("#" + popSubjectList.getId()));
        }
    }

    protected void buildPopulation(MeasureDef measureDef, String groupKey, Measure.MeasureGroupPopulationComponent measurePopulation, MeasureReport.MeasureReportGroupPopulationComponent reportPopulation, PopulationDef populationDef) {
        reportPopulation.setCode(measurePopulation.getCode());
        reportPopulation.setId(measurePopulation.getId());
        if (!measureDef.groups().isEmpty() && !measureDef.groups().get(0).isBooleanBasis()) {
            reportPopulation.setCount(populationDef.getResources().size());
        } else {
            reportPopulation.setCount(populationDef.getSubjects().size());
        }
        if (measurePopulation.hasDescription()) {
            reportPopulation.addExtension(this.createStringExtension(EXT_POPULATION_DESCRIPTION_URL, measurePopulation.getDescription()));
        }
        this.addResourceReferences(populationDef.type(), populationDef.getEvaluatedResources());
        Set<String> populationSet = populationDef.getSubjects();
        measurePopulation.setUserData(POPULATION_SUBJECT_SET, populationSet);
        switch (this.report.getType()) {
            case PATIENTLIST: {
                if (populationSet.size() <= 0) break;
                ListResource subjectList = this.createIdList("subject-list-" + groupKey + "-" + populationDef.type().toCode(), populationSet);
                this.report.addContained((Resource)subjectList);
                reportPopulation.setPatients(new Reference("#" + subjectList.getId()));
                break;
            }
        }
        switch (populationDef.type()) {
            case MEASUREOBSERVATION: {
                this.buildMeasureObservations(populationDef.expression(), populationDef.getResources());
                break;
            }
        }
    }

    protected void buildMeasureObservations(String observationName, Set<Object> resources) {
        for (int i = 0; i < resources.size(); ++i) {
            Observation observation = this.createMeasureObservation("measure-observation-" + observationName + "-" + (i + 1), observationName);
            this.report.addContained((Resource)observation);
        }
    }

    protected ListResource createList(String id) {
        ListResource list = new ListResource();
        list.setId(id);
        return list;
    }

    protected ListResource createIdList(String id, Collection<String> ids) {
        return this.createReferenceList(id, ids.stream().map(x -> new Reference(x)).collect(Collectors.toList()));
    }

    protected ListResource createReferenceList(String id, Collection<Reference> references) {
        ListResource referenceList = this.createList(id);
        for (Reference reference : references) {
            referenceList.addEntry().setItem(reference);
        }
        return referenceList;
    }

    private void addResourceReferences(MeasurePopulationType measurePopulationType, Set<Object> evaluatedResources) {
        if (!evaluatedResources.isEmpty()) {
            for (Object object : evaluatedResources) {
                Resource resource = (Resource)object;
                String resourceId = resource.getId();
                Reference reference = this.getEvaluatedResourceReference(resourceId);
                Extension ext = this.createStringExtension("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-populationReference", measurePopulationType.toCode());
                this.addExtensionToReference(reference, ext);
            }
        }
    }

    protected HashMap<String, Reference> getEvaluatedResourceReferences() {
        if (this.evaluatedResourceReferences == null) {
            this.evaluatedResourceReferences = new HashMap();
        }
        return this.evaluatedResourceReferences;
    }

    protected Reference getEvaluatedResourceReference(String id) {
        return this.getEvaluatedResourceReferences().computeIfAbsent(id, x -> new Reference(id));
    }

    protected void processSdes(Measure measure, MeasureDef measureDef, List<String> subjectIds) {
        for (int i = 0; i < measure.getSupplementalData().size(); ++i) {
            Measure.MeasureSupplementalDataComponent msdc = (Measure.MeasureSupplementalDataComponent)measure.getSupplementalData().get(i);
            SdeDef sde = measureDef.sdes().get(i);
            this.processSdeEvaluatedResourceExtension(sde);
            Map accumulated = sde.getResults().values().stream().flatMap(x -> Lists.newArrayList(x.iterableValue()).stream()).map(x$0 -> new ValueWrapper(x$0)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            String sdeKey = this.getKey("sde-observation", msdc.getId(), null, i);
            String sdeId = sde.id();
            for (Map.Entry accumulator : accumulated.entrySet()) {
                String valueCode = ((ValueWrapper)accumulator.getKey()).getValueAsString();
                String valueKey = ((ValueWrapper)accumulator.getKey()).getKey();
                Long valueCount = accumulator.getValue();
                if (valueKey == null) {
                    valueKey = valueCode;
                }
                valueKey = this.escapeForFhirId(valueKey);
                Coding valueCoding = new Coding().setCode(valueCode);
                if (!sdeId.equalsIgnoreCase("sde-sex")) {
                    // empty if block
                }
                DomainResource obs = null;
                switch (this.report.getType()) {
                    case INDIVIDUAL: {
                        obs = this.createPatientObservation(sdeKey + "-" + valueKey, sdeId, valueCoding);
                        break;
                    }
                    default: {
                        obs = this.createPopulationObservation(sdeKey + "-" + valueKey, sdeId, valueCoding, valueCount);
                    }
                }
                this.report.addExtension(this.createReferenceExtension(EXT_SDE_REFERENCE_URL, "#" + obs.getId()));
                this.report.addContained((Resource)obs);
            }
        }
    }

    private void processSdeEvaluatedResourceExtension(SdeDef sdeDef) {
        for (CriteriaResult r : sdeDef.getResults().values()) {
            for (Object o : r.evaluatedResources()) {
                if (!(o instanceof IBaseResource)) continue;
                Extension extension = new Extension("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData");
                IBaseResource iBaseResource = (IBaseResource)o;
                extension.setValue((Type)new StringType(iBaseResource.getIdElement().getResourceType() + "/" + iBaseResource.getIdElement().getIdPart()));
                this.report.getExtension().add(extension);
            }
        }
    }

    protected Period getPeriod(Interval measurementPeriod) {
        if (measurementPeriod.getStart() instanceof DateTime) {
            DateTime dtStart = (DateTime)measurementPeriod.getStart();
            DateTime dtEnd = (DateTime)measurementPeriod.getEnd();
            return new Period().setStart(dtStart.toJavaDate()).setEnd(dtEnd.toJavaDate());
        }
        if (measurementPeriod.getStart() instanceof Date) {
            Date dStart = (Date)measurementPeriod.getStart();
            Date dEnd = (Date)measurementPeriod.getEnd();
            return new Period().setStart(dStart.toJavaDate()).setEnd(dEnd.toJavaDate());
        }
        throw new InvalidRequestException("Measurement period should be an interval of CQL DateTime or Date: " + String.valueOf(measurementPeriod));
    }

    protected MeasureReport createMeasureReport(Measure measure, MeasureDef measureDef, MeasureReportType type, List<String> subjectIds, Interval measurementPeriod) {
        MeasureReport report = new MeasureReport();
        report.setStatus(MeasureReport.MeasureReportStatus.fromCode((String)"complete"));
        report.setType(MeasureReport.MeasureReportType.fromCode((String)type.toCode()));
        if (type == MeasureReportType.INDIVIDUAL && !subjectIds.isEmpty()) {
            report.setPatient(new Reference(subjectIds.get(0)));
        }
        if (measurementPeriod != null) {
            report.setPeriod(this.getPeriod(measurementPeriod));
        } else if (measureDef.getDefaultMeasurementPeriod() != null) {
            report.setPeriod(this.getPeriod(measureDef.getDefaultMeasurementPeriod()));
        }
        report.setMeasure(new Reference(measure.getId()));
        report.setDate(new java.util.Date());
        report.setImplicitRules(measure.getImplicitRules());
        report.setLanguage(measure.getLanguage());
        if (measure.hasDescription()) {
            report.addExtension(this.createStringExtension(EXT_POPULATION_DESCRIPTION_URL, measure.getDescription()));
        }
        return report;
    }

    protected Extension createStringExtension(String url, String value) {
        Extension ext = new Extension().setUrl(url);
        ext.setValue((Type)new StringType(value));
        return ext;
    }

    protected Extension createReferenceExtension(String url, String reference) {
        Extension ext = new Extension().setUrl(url);
        ext.setValue((Type)new Reference(reference));
        return ext;
    }

    protected void addExtensionToReference(Reference reference, Extension extension) {
        List extensions = reference.getExtensionsByUrl(extension.getUrl());
        for (Extension e : extensions) {
            if (!e.getValue().equalsShallow((Base)extension.getValue())) continue;
            return;
        }
        reference.addExtension(extension);
    }

    protected Extension createMeasureInfoExtension(MeasureInfo measureInfo) {
        Extension extExtMeasure = new Extension().setUrl("measure").setValue((Type)new IdType(measureInfo.getMeasure()));
        Extension extExtPop = new Extension().setUrl("populationId").setValue((Type)new StringType(measureInfo.getPopulationId()));
        Extension obsExtension = new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/cqf-measureInfo");
        obsExtension.addExtension(extExtMeasure);
        obsExtension.addExtension(extExtPop);
        return obsExtension;
    }

    protected DomainResource createPopulationObservation(String id, String populationId, Coding valueCoding, Long sdeAccumulatorValue) {
        Observation obs = this.createObservation(id, populationId);
        CodeableConcept obsCodeableConcept = new CodeableConcept();
        obsCodeableConcept.setCoding(Collections.singletonList(valueCoding));
        obs.setCode(obsCodeableConcept);
        obs.setValue((Type)new Quantity().setValue(sdeAccumulatorValue.longValue()));
        return obs;
    }

    protected DomainResource createPatientObservation(String id, String populationId, Coding valueCoding) {
        Observation obs = this.createObservation(id, populationId);
        CodeableConcept codeCodeableConcept = new CodeableConcept().setText(populationId);
        obs.setCode(codeCodeableConcept);
        CodeableConcept valueCodeableConcept = new CodeableConcept();
        valueCodeableConcept.setCoding(Collections.singletonList(valueCoding));
        obs.setValue((Type)valueCodeableConcept);
        return obs;
    }

    protected Observation createObservation(String id, String populationId) {
        MeasureInfo measureInfo = new MeasureInfo().withMeasure((String)(this.measure.hasUrl() ? this.measure.getUrl() : (this.measure.hasId() ? "http://hl7.org/fhir/us/cqfmeasures/" + this.measure.getIdElement().getIdPart() : ""))).withPopulationId(populationId);
        Observation obs = new Observation();
        obs.setStatus(Observation.ObservationStatus.FINAL);
        obs.setId(id);
        obs.addExtension(this.createMeasureInfoExtension(measureInfo));
        return obs;
    }

    protected Observation createMeasureObservation(String id, String observationName) {
        Observation obs = this.createObservation(id, observationName);
        CodeableConcept cc = new CodeableConcept();
        cc.setText(observationName);
        obs.setCode(cc);
        return obs;
    }

    protected String escapeForFhirId(String value) {
        if (value == null) {
            return null;
        }
        return value.toLowerCase().trim().replace(" ", "-").replace("_", "-");
    }

    class ValueWrapper {
        protected Object value;

        public ValueWrapper(Object value) {
            this.value = value;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ValueWrapper other = (ValueWrapper)o;
            if (other.getValue() == null ^ this.getValue() == null) {
                return false;
            }
            if (other.getValue() == null && this.getValue() == null) {
                return true;
            }
            return this.getKey().equals(other.getKey());
        }

        public String getKey() {
            String key = null;
            if (this.value instanceof Coding) {
                Coding c = (Coding)this.value;
                key = this.joinValues("coding", c.getCode());
            } else if (this.value instanceof CodeableConcept) {
                CodeableConcept c = (CodeableConcept)this.value;
                key = this.joinValues("codeable-concept", c.getCodingFirstRep().getCode());
            } else if (this.value instanceof Code) {
                Code c = (Code)this.value;
                key = this.joinValues("code", c.getCode());
            } else if (this.value instanceof Enum) {
                Enum e = (Enum)this.value;
                key = this.joinValues("enum", e.toString());
            } else if (this.value instanceof IPrimitiveType) {
                IPrimitiveType p = (IPrimitiveType)this.value;
                key = this.joinValues("primitive", p.getValueAsString());
            } else if (this.value instanceof Identifier) {
                key = ((Identifier)this.value).getValue();
            } else if (this.value instanceof Resource) {
                key = ((Resource)this.value).getIdElement().toVersionless().getValue();
            } else if (this.value != null) {
                key = this.value.toString();
            }
            if (key == null) {
                throw new InvalidRequestException(String.format("found a null key for the wrapped value: %s", this.value));
            }
            return key;
        }

        public String getValueAsString() {
            if (this.value instanceof Coding) {
                Coding c = (Coding)this.value;
                return c.getCode();
            }
            if (this.value instanceof CodeableConcept) {
                CodeableConcept c = (CodeableConcept)this.value;
                return c.getCodingFirstRep().getCode();
            }
            if (this.value instanceof Code) {
                Code c = (Code)this.value;
                return c.getCode();
            }
            if (this.value instanceof Enum) {
                Enum e = (Enum)this.value;
                return e.toString();
            }
            if (this.value instanceof IPrimitiveType) {
                IPrimitiveType p = (IPrimitiveType)this.value;
                return p.getValueAsString();
            }
            if (this.value != null) {
                return this.value.toString();
            }
            return "<null>";
        }

        public String getDescription() {
            if (this.value instanceof Coding) {
                Coding c = (Coding)this.value;
                return c.hasDisplay() ? c.getDisplay() : c.getCode();
            }
            if (this.value instanceof CodeableConcept) {
                CodeableConcept c = (CodeableConcept)this.value;
                return c.getCodingFirstRep().hasDisplay() ? c.getCodingFirstRep().getDisplay() : c.getCodingFirstRep().getCode();
            }
            if (this.value instanceof Code) {
                Code c = (Code)this.value;
                return c.getDisplay() != null ? c.getDisplay() : c.getCode();
            }
            if (this.value instanceof Enum) {
                Enum e = (Enum)this.value;
                return e.toString();
            }
            if (this.value instanceof IPrimitiveType) {
                IPrimitiveType p = (IPrimitiveType)this.value;
                return p.getValueAsString();
            }
            if (this.value != null) {
                return this.value.toString();
            }
            return null;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getValueClass() {
            return this.value.getClass();
        }

        private String joinValues(String ... elements) {
            return String.join((CharSequence)"-", elements);
        }
    }
}

