/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.cr.measure.common.CodeDef;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierComponentDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;

public class R4MeasureDefBuilder
implements MeasureDefBuilder<Measure> {
    @Override
    public MeasureDef build(Measure measure) {
        this.checkId((Resource)measure);
        ArrayList<SdeDef> sdes = new ArrayList<SdeDef>();
        for (Measure.MeasureSupplementalDataComponent s : measure.getSupplementalData()) {
            this.checkId((Element)s);
            this.checkSDEUsage(measure, s);
            SdeDef sdeDef = new SdeDef(s.getId(), this.conceptToConceptDef(s.getCode()), s.getCriteria().getExpression());
            sdes.add(sdeDef);
        }
        MeasureScoring measureScoring = this.getMeasureScoring(measure);
        CodeDef measureBasis = this.getMeasureBasis(measure);
        CodeDef measureImpNotation = this.getMeasureImprovementNotation(measure);
        ArrayList<GroupDef> groups = new ArrayList<GroupDef>();
        for (Measure.MeasureGroupComponent group : measure.getGroup()) {
            MeasureScoring groupScoring = this.getGroupMeasureScoring(measure, group);
            CodeDef groupBasis = this.getGroupPopulationBasis(group);
            CodeDef groupImpNotation = this.getGroupImpNotation(measure, group);
            boolean hasGroupImpNotation = groupImpNotation != null;
            ArrayList<PopulationDef> populations = new ArrayList<PopulationDef>();
            for (Measure.MeasureGroupPopulationComponent pop : group.getPopulation()) {
                this.checkId((Element)pop);
                MeasurePopulationType populationType = MeasurePopulationType.fromCode(pop.getCode().getCodingFirstRep().getCode());
                populations.add(new PopulationDef(pop.getId(), this.conceptToConceptDef(pop.getCode()), populationType, pop.getCriteria().getExpression()));
            }
            if (group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression") != null && this.checkPopulationForCode(populations, MeasurePopulationType.DATEOFCOMPLIANCE) == null) {
                Expression expressionType = (Expression)group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression").getValue();
                if (!expressionType.hasExpression()) {
                    throw new InvalidRequestException(String.format("no expression was listed for extension: %s for Measure: %s", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression", measure.getUrl()));
                }
                String expression = expressionType.getExpression();
                populations.add(new PopulationDef("dateOfCompliance", this.totalConceptDefCreator(MeasurePopulationType.DATEOFCOMPLIANCE), MeasurePopulationType.DATEOFCOMPLIANCE, expression));
            }
            ArrayList<StratifierDef> stratifiers = new ArrayList<StratifierDef>();
            for (Measure.MeasureGroupStratifierComponent mgsc : group.getStratifier()) {
                this.checkId((Element)mgsc);
                ArrayList<StratifierComponentDef> components = new ArrayList<StratifierComponentDef>();
                for (Measure.MeasureGroupStratifierComponentComponent scc : mgsc.getComponent()) {
                    this.checkId((Element)scc);
                    StratifierComponentDef scd = new StratifierComponentDef(scc.getId(), this.conceptToConceptDef(scc.getCode()), scc.hasCriteria() ? scc.getCriteria().getExpression() : null);
                    components.add(scd);
                }
                StratifierDef stratifierDef = new StratifierDef(mgsc.getId(), this.conceptToConceptDef(mgsc.getCode()), mgsc.getCriteria().getExpression(), components);
                stratifiers.add(stratifierDef);
            }
            GroupDef groupDef = new GroupDef(group.getId(), this.conceptToConceptDef(group.getCode()), stratifiers, populations, this.getScoringDef(measure, measureScoring, groupScoring), hasGroupImpNotation, this.getImprovementNotation(measureImpNotation, groupImpNotation), this.getPopulationBasisDef(measureBasis, groupBasis));
            groups.add(groupDef);
        }
        return new MeasureDef(measure.getId(), measure.getUrl(), measure.getVersion(), groups, sdes);
    }

    private PopulationDef checkPopulationForCode(List<PopulationDef> populations, MeasurePopulationType measurePopType) {
        return populations.stream().filter(e -> e.code().first().code().equals(measurePopType.toCode())).findAny().orElse(null);
    }

    private ConceptDef totalConceptDefCreator(MeasurePopulationType measurePopulationType) {
        return new ConceptDef(Collections.singletonList(new CodeDef(measurePopulationType.getSystem(), measurePopulationType.toCode())), null);
    }

    private void checkSDEUsage(Measure measure, Measure.MeasureSupplementalDataComponent measureSupplementalDataComponent) {
        List hasUsage = measureSupplementalDataComponent.getUsage().stream().filter(t -> t.getCodingFirstRep().getCode().equals("supplemental-data")).collect(Collectors.toList());
        if (hasUsage == null || hasUsage.isEmpty()) {
            throw new InvalidRequestException(String.format("SupplementalDataComponent usage is missing code: %s for Measure: %s", "supplemental-data", measure.getUrl()));
        }
    }

    private ConceptDef conceptToConceptDef(CodeableConcept codeable) {
        if (codeable == null) {
            return null;
        }
        ArrayList<CodeDef> codes = new ArrayList<CodeDef>();
        for (Coding c : codeable.getCoding()) {
            codes.add(this.codeToCodeDef(c));
        }
        return new ConceptDef(codes, codeable.getText());
    }

    private CodeDef codeToCodeDef(Coding coding) {
        return new CodeDef(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay());
    }

    private void checkId(Element e) {
        if (e.getId() == null || StringUtils.isBlank((CharSequence)e.getId())) {
            throw new NullPointerException("id is required on all Elements of type: " + e.fhirType());
        }
    }

    private void checkId(Resource r) {
        if (r.getId() == null || StringUtils.isBlank((CharSequence)r.getId())) {
            throw new NullPointerException("id is required on all Resources of type: " + r.fhirType());
        }
    }

    private MeasureScoring getMeasureScoring(Measure measure, @Nullable String scoringCode) {
        if (scoringCode != null) {
            MeasureScoring code = MeasureScoring.fromCode(scoringCode);
            if (code == null) {
                throw new InvalidRequestException(String.format("Measure Scoring code: %s, is not a valid Measure Scoring Type for measure: %s.", scoringCode, measure.getUrl()));
            }
            return code;
        }
        return null;
    }

    private MeasureScoring getMeasureScoring(Measure measure) {
        String scoringCode = measure.getScoring().getCodingFirstRep().getCode();
        return this.getMeasureScoring(measure, scoringCode);
    }

    private void validateImprovementNotationCode(Measure measure, CodeDef improvementNotation) {
        boolean hasValidCode;
        String code = improvementNotation.code();
        String system = improvementNotation.system();
        boolean hasValidSystem = system.equals("http://terminology.hl7.org/CodeSystem/measure-improvement-notation");
        boolean bl = hasValidCode = "increase".equals(code) || "decrease".equals(code);
        if (!hasValidCode || !hasValidSystem) {
            throw new InvalidRequestException(String.format("ImprovementNotation Coding has invalid System: %s, code: %s, combination for Measure: %s", system, code, measure.getUrl()));
        }
    }

    public CodeDef getMeasureBasis(Measure measure) {
        Extension ext = measure.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis");
        if (ext != null) {
            return this.makeCodeDefFromExtension(ext);
        }
        return null;
    }

    private CodeDef makeCodeDefFromExtension(Extension extension) {
        String code = extension.getValue().toString();
        assert (Enumerations.FHIRAllTypes.fromCode((String)code) != null);
        return new CodeDef("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis", code);
    }

    public CodeDef getMeasureImprovementNotation(Measure measure) {
        if (measure.hasImprovementNotation()) {
            CodeableConcept improvementNotationValue = measure.getImprovementNotation();
            CodeDef codeDef = new CodeDef(improvementNotationValue.getCodingFirstRep().getSystem(), improvementNotationValue.getCodingFirstRep().getCode());
            this.validateImprovementNotationCode(measure, codeDef);
            return codeDef;
        }
        return null;
    }

    public CodeDef getGroupImpNotation(Measure measure, Measure.MeasureGroupComponent group) {
        Type value;
        Extension ext = group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-improvementNotation");
        if (ext != null && (value = ext.getValue()) instanceof CodeableConcept) {
            CodeableConcept coding = (CodeableConcept)value;
            CodeDef codeDef = new CodeDef(coding.getCodingFirstRep().getSystem(), coding.getCodingFirstRep().getCode());
            this.validateImprovementNotationCode(measure, codeDef);
            return codeDef;
        }
        return null;
    }

    public MeasureScoring getGroupMeasureScoring(Measure measure, Measure.MeasureGroupComponent group) {
        Extension ext = group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring");
        if (ext != null) {
            Type extVal = ext.getValue();
            assert (extVal instanceof CodeableConcept);
            CodeableConcept coding = (CodeableConcept)extVal;
            return this.getMeasureScoring(measure, coding.getCodingFirstRep().getCode());
        }
        return null;
    }

    public CodeDef getGroupPopulationBasis(Measure.MeasureGroupComponent group) {
        Extension ext = group.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis");
        if (ext != null) {
            return this.makeCodeDefFromExtension(ext);
        }
        return null;
    }

    private MeasureScoring getScoringDef(Measure measure, MeasureScoring measureScoring, MeasureScoring groupScoring) {
        if (groupScoring == null && measureScoring == null) {
            throw new InvalidRequestException("MeasureScoring must be specified on Group or Measure for Measure: " + measure.getUrl());
        }
        if (groupScoring != null) {
            return groupScoring;
        }
        return measureScoring;
    }

    private CodeDef getPopulationBasisDef(@Nullable CodeDef measureBasis, @Nullable CodeDef groupBasis) {
        if (measureBasis == null && groupBasis == null) {
            return new CodeDef("http://hl7.org/fhir/fhir-types", "boolean");
        }
        return this.defaultCodeDef(groupBasis, measureBasis);
    }

    private CodeDef getImprovementNotation(@Nullable CodeDef measureImpNotation, @Nullable CodeDef groupImpNotation) {
        if (measureImpNotation == null && groupImpNotation == null) {
            return new CodeDef("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase");
        }
        return this.defaultCodeDef(groupImpNotation, measureImpNotation);
    }

    private CodeDef defaultCodeDef(@Nullable CodeDef code, @Nullable CodeDef codeDefault) {
        if (code != null) {
            return code;
        }
        return codeDefault;
    }
}

