/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cqframework.cql.cql2elm.CqlIncludeException;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Parameters;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.fhir.model.R4FhirModelResolver;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.VersionedIdentifiers;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.SubjectProvider;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureEvaluation;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4DateHelper;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4MeasureServiceUtils;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;
import org.opencds.cqf.fhir.utility.search.Searches;

public class R4MeasureProcessor {
    private final Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private final SubjectProvider subjectProvider;
    private final R4MeasureServiceUtils r4MeasureServiceUtils;

    public R4MeasureProcessor(Repository repository, MeasureEvaluationOptions measureEvaluationOptions, SubjectProvider subjectProvider, R4MeasureServiceUtils r4MeasureServiceUtils) {
        this.repository = Objects.requireNonNull(repository);
        this.measureEvaluationOptions = measureEvaluationOptions != null ? measureEvaluationOptions : MeasureEvaluationOptions.defaultOptions();
        this.subjectProvider = subjectProvider;
        this.r4MeasureServiceUtils = r4MeasureServiceUtils;
    }

    public MeasureReport evaluateMeasure(Either3<CanonicalType, IdType, Measure> measure, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters) {
        MeasureEvalType evalType = this.r4MeasureServiceUtils.getMeasureEvalType(reportType, subjectIds);
        Repository actualRepo = this.repository;
        if (additionalData != null) {
            actualRepo = new FederatedRepository(this.repository, new Repository[]{new InMemoryFhirRepository(this.repository.fhirContext(), additionalData)});
        }
        List<String> subjects = this.subjectProvider.getSubjects(actualRepo, subjectIds).collect(Collectors.toList());
        return this.evaluateMeasure(measure, periodStart, periodEnd, reportType, subjects, additionalData, parameters, evalType);
    }

    public MeasureReport evaluateMeasure(Either3<CanonicalType, IdType, Measure> measure, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters, MeasureEvalType evalType) {
        Measure m = (Measure)measure.fold(this::resolveByUrl, this::resolveById, Function.identity());
        return this.evaluateMeasure(m, periodStart, periodEnd, reportType, subjectIds, additionalData, parameters, evalType);
    }

    protected MeasureReport evaluateMeasure(Measure measure, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData, Parameters parameters, MeasureEvalType evalType) {
        CompiledLibrary lib;
        String url;
        Bundle b;
        if (!measure.hasLibrary()) {
            throw new InvalidRequestException(String.format("Measure %s does not have a primary library specified", measure.getUrl()));
        }
        Interval measurementPeriod = null;
        if (periodStart != null && periodEnd != null) {
            R4DateHelper helper = new R4DateHelper();
            measurementPeriod = helper.buildMeasurementPeriodInterval(periodStart, periodEnd);
        }
        if ((b = (Bundle)this.repository.search(Bundle.class, Library.class, Searches.byCanonical((String)(url = ((CanonicalType)measure.getLibrary().get(0)).asStringValue())), null)).getEntry().isEmpty()) {
            String errorMsg = String.format("Unable to find Library with url: %s", url);
            throw new ResourceNotFoundException(errorMsg);
        }
        VersionedIdentifier id = VersionedIdentifiers.forUrl((String)url);
        CqlEngine context = Engines.forRepository((Repository)this.repository, (EvaluationSettings)this.measureEvaluationOptions.getEvaluationSettings(), (IBaseBundle)additionalData);
        try {
            lib = context.getEnvironment().getLibraryManager().resolveLibrary(id);
        }
        catch (CqlIncludeException e) {
            throw new IllegalStateException(String.format("Unable to load CQL/ELM for library: %s. Verify that the Library resource is available in your environment and has CQL/ELM content embedded.", id.getId()), e);
        }
        context.getState().init(lib.getLibrary());
        if (parameters != null) {
            Map<String, Object> paramMap = this.resolveParameterMap(parameters);
            context.getState().setParameters(lib.getLibrary(), paramMap);
            if (lib.getLibrary().getIncludes() != null) {
                lib.getLibrary().getIncludes().getDef().forEach(includeDef -> paramMap.forEach((paramKey, paramValue) -> context.getState().setParameter(includeDef.getLocalIdentifier(), paramKey, paramValue)));
            }
        }
        if (evalType == null) {
            evalType = MeasureEvalType.fromCode(reportType).orElse(subjectIds == null || subjectIds.isEmpty() || subjectIds.get(0) == null ? MeasureEvalType.POPULATION : MeasureEvalType.SUBJECT);
        }
        LibraryEngine libraryEngine = new LibraryEngine(this.repository, this.measureEvaluationOptions.getEvaluationSettings());
        R4MeasureEvaluation measureEvaluator = new R4MeasureEvaluation(context, measure, libraryEngine, id);
        return (MeasureReport)measureEvaluator.evaluate(evalType, subjectIds, measurementPeriod, libraryEngine, id);
    }

    protected Measure resolveByUrl(CanonicalType url) {
        Canonicals.CanonicalParts parts = Canonicals.getParts((IPrimitiveType)url);
        Bundle result = (Bundle)this.repository.search(Bundle.class, Measure.class, Searches.byNameAndVersion((String)parts.idPart(), (String)parts.version()));
        return (Measure)result.getEntryFirstRep().getResource();
    }

    protected Measure resolveById(IdType id) {
        return (Measure)this.repository.read(Measure.class, (IIdType)id);
    }

    private Map<String, Object> resolveParameterMap(Parameters parameters) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        R4FhirModelResolver modelResolver = new R4FhirModelResolver();
        parameters.getParameter().forEach(param -> {
            Object value;
            if (param.hasResource()) {
                value = param.getResource();
            } else {
                value = param.getValue();
                if (value instanceof IPrimitiveType) {
                    value = modelResolver.toJavaPrimitive(((IPrimitiveType)value).getValue(), value);
                }
            }
            if (parameterMap.containsKey(param.getName())) {
                if (parameterMap.get(param.getName()) instanceof List) {
                    if (value != null) {
                        List list = (List)parameterMap.get(param.getName());
                        list.add(value);
                    }
                } else {
                    parameterMap.put(param.getName(), Arrays.asList(parameterMap.get(param.getName()), value));
                }
            } else {
                parameterMap.put(param.getName(), value);
            }
        });
        return parameterMap;
    }
}

