/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.cr.measure.common.CodeDef;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.CriteriaResult;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureInfo;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4DateHelper;

public class R4MeasureReportBuilder
implements MeasureReportBuilder<Measure, MeasureReport, DomainResource> {
    protected static final String POPULATION_SUBJECT_SET = "POPULATION_SUBJECT_SET";
    private final MeasureReportScorer<MeasureReport> measureReportScorer = new R4MeasureReportScorer();
    private Coding supplementalDataCoding;

    @Override
    public MeasureReport build(Measure measure, MeasureDef measureDef, MeasureReportType measureReportType, Interval measurementPeriod, List<String> subjectIds) {
        MeasureReport report = this.createMeasureReport(measure, measureDef, measureReportType, subjectIds, measurementPeriod);
        BuilderContext bc = new BuilderContext(measure, measureDef, report);
        this.buildGroups(bc);
        this.buildSDEs(bc);
        this.addEvaluatedResource(bc);
        this.addSupplementalData(bc);
        bc.addOperationOutcomes();
        for (Resource r : bc.contained().values()) {
            bc.report().addContained(r);
        }
        this.measureReportScorer.score(measure.getUrl(), measureDef, bc.report());
        this.setReportStatus(bc);
        return bc.report();
    }

    private void setReportStatus(BuilderContext bc) {
        if (bc.report().hasContained() && bc.report().getContained().stream().anyMatch(t -> t.getResourceType().equals((Object)ResourceType.OperationOutcome))) {
            bc.report().setStatus(MeasureReport.MeasureReportStatus.ERROR);
        }
    }

    protected void addSupplementalData(BuilderContext bc) {
        MeasureReport report = bc.report();
        for (Reference r : bc.supplementalDataReferences().values()) {
            report.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.supplementalDataElement.reference", (Type)r);
        }
    }

    protected void addEvaluatedResource(BuilderContext bc) {
        MeasureReport report = bc.report();
        if (report.getType() == MeasureReport.MeasureReportType.INDIVIDUAL) {
            for (Reference r : bc.evaluatedResourceReferences().values()) {
                report.addEvaluatedResource(r);
            }
        }
    }

    protected void buildGroups(BuilderContext bc) {
        Measure measure = bc.measure();
        MeasureDef measureDef = bc.measureDef();
        MeasureReport report = bc.report();
        if (measure.getGroup().size() != measureDef.groups().size()) {
            throw new InvalidRequestException("The Measure has a different number of groups defined than the MeasureDef for Measure: " + measure.getUrl());
        }
        for (int i = 0; i < measure.getGroup().size(); ++i) {
            Measure.MeasureGroupComponent measureGroup = (Measure.MeasureGroupComponent)measure.getGroup().get(i);
            GroupDef defGroup = measureDef.groups().get(i);
            MeasureReport.MeasureReportGroupComponent reportGroup = report.addGroup();
            this.buildGroup(bc, measureGroup, reportGroup, defGroup);
        }
    }

    private PopulationDef getReportPopulation(GroupDef reportGroup, MeasurePopulationType measurePopType) {
        List<PopulationDef> populations = reportGroup.populations();
        return populations.stream().filter(e -> e.code().first().code().equals(measurePopType.toCode())).findAny().orElse(null);
    }

    protected void buildGroup(BuilderContext bc, Measure.MeasureGroupComponent measureGroup, MeasureReport.MeasureReportGroupComponent reportGroup, GroupDef groupDef) {
        Object docValue;
        PopulationDef docPopDef;
        int i;
        int groupDefSizeDiff = 0;
        if (groupDef.populations().stream().filter(x -> x.type().equals((Object)MeasurePopulationType.DATEOFCOMPLIANCE)).findFirst().orElse(null) != null) {
            groupDefSizeDiff = 1;
        }
        if (measureGroup.getPopulation().size() != groupDef.populations().size() - groupDefSizeDiff) {
            throw new InvalidRequestException("The MeasureGroup has a different number of populations defined than the GroupDef for Measure: " + bc.measure().getUrl());
        }
        if (measureGroup.getStratifier().size() != groupDef.stratifiers().size()) {
            throw new InvalidRequestException("The MeasureGroup has a different number of stratifiers defined than the GroupDef for Measure: " + bc.measure().getUrl());
        }
        reportGroup.setCode(measureGroup.getCode());
        reportGroup.setId(measureGroup.getId());
        this.addMeasureDescription(reportGroup, measureGroup);
        this.addExtensionImprovementNotation(reportGroup, groupDef);
        for (i = 0; i < measureGroup.getPopulation().size(); ++i) {
            Measure.MeasureGroupPopulationComponent measurePop = (Measure.MeasureGroupPopulationComponent)measureGroup.getPopulation().get(i);
            PopulationDef defPop = null;
            for (int x2 = 0; x2 < groupDef.populations().size(); ++x2) {
                PopulationDef groupDefPop = groupDef.populations().get(x2);
                if (!groupDefPop.code().first().code().equals(measurePop.getCode().getCodingFirstRep().getCode())) continue;
                defPop = groupDefPop;
                break;
            }
            MeasureReport.MeasureReportGroupPopulationComponent reportPop = reportGroup.addPopulation();
            this.buildPopulation(bc, measurePop, reportPop, defPop, groupDef);
        }
        if ((groupDef.measureScoring().equals((Object)MeasureScoring.PROPORTION) || groupDef.measureScoring().equals((Object)MeasureScoring.RATIO)) && bc.measureReport.getType().equals((Object)MeasureReport.MeasureReportType.INDIVIDUAL) && (docPopDef = this.getReportPopulation(groupDef, MeasurePopulationType.DATEOFCOMPLIANCE)) != null && docPopDef.getResources() != null && !docPopDef.getResources().isEmpty() && (docValue = docPopDef.getResources().iterator().next()) != null) {
            assert (docValue instanceof Interval);
            Interval docInterval = (Interval)docValue;
            R4DateHelper helper = new R4DateHelper();
            reportGroup.addExtension().setUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-care-gap-date-of-compliance-expression").setValue((Type)helper.buildMeasurementPeriod(docInterval));
        }
        for (i = 0; i < measureGroup.getStratifier().size(); ++i) {
            Measure.MeasureGroupStratifierComponent groupStrat = (Measure.MeasureGroupStratifierComponent)measureGroup.getStratifier().get(i);
            MeasureReport.MeasureReportGroupStratifierComponent reportStrat = reportGroup.addStratifier();
            StratifierDef defStrat = groupDef.stratifiers().get(i);
            this.buildStratifier(bc, groupStrat, reportStrat, defStrat, measureGroup.getPopulation(), groupDef);
        }
    }

    protected void buildStratifier(BuilderContext bc, Measure.MeasureGroupStratifierComponent measureStratifier, MeasureReport.MeasureReportGroupStratifierComponent reportStratifier, StratifierDef stratifierDef, List<Measure.MeasureGroupPopulationComponent> populations, GroupDef groupDef) {
        reportStratifier.setCode(Collections.singletonList(measureStratifier.getCode()));
        reportStratifier.setId(measureStratifier.getId());
        if (measureStratifier.hasDescription()) {
            reportStratifier.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.population.description", (Type)new StringType(measureStratifier.getDescription()));
        }
        Map<String, CriteriaResult> subjectValues = stratifierDef.getResults();
        if (groupDef.isBooleanBasis()) {
            Map<ValueWrapper, List<String>> subjectsByValue = subjectValues.keySet().stream().collect(Collectors.groupingBy(x -> new ValueWrapper(((CriteriaResult)subjectValues.get(x)).rawValue())));
            for (Map.Entry<ValueWrapper, List<String>> stratValue : subjectsByValue.entrySet()) {
                MeasureReport.StratifierGroupComponent reportStratum = reportStratifier.addStratum();
                List<String> patients = stratValue.getValue().stream().map(t -> ResourceType.Patient.toString().concat("/").concat((String)t)).collect(Collectors.toList());
                this.buildStratum(bc, reportStratum, stratValue.getKey(), patients, populations, groupDef);
            }
        } else {
            List values = subjectValues.values().stream().map(CriteriaResult::rawValue).filter(Resource.class::isInstance).map(Resource.class::cast).map(x -> x.getResourceType().toString().concat("/").concat(x.getIdPart())).collect(Collectors.toList());
            for (String value : values) {
                this.buildStratum(bc, reportStratifier.addStratum(), new ValueWrapper(value), Collections.singletonList(value), populations, groupDef);
            }
        }
    }

    protected void addMeasureDescription(MeasureReport.MeasureReportGroupComponent reportGroup, Measure.MeasureGroupComponent measureGroup) {
        if (measureGroup.hasDescription()) {
            reportGroup.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.population.description", (Type)new StringType(measureGroup.getDescription()));
        }
    }

    protected void addExtensionImprovementNotation(MeasureReport.MeasureReportGroupComponent reportGroup, GroupDef groupDef) {
        if (groupDef.isGroupImprovementNotation()) {
            if (groupDef.isIncreaseImprovementNotation()) {
                reportGroup.addExtension("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-improvementNotation", (Type)new CodeableConcept(new Coding("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase", "Increase")));
            } else {
                reportGroup.addExtension("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-improvementNotation", (Type)new CodeableConcept(new Coding("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "decrease", "Decrease")));
            }
        }
    }

    protected void buildStratum(BuilderContext bc, MeasureReport.StratifierGroupComponent stratum, ValueWrapper value, List<String> subjectIds, List<Measure.MeasureGroupPopulationComponent> populations, GroupDef groupDef) {
        if (value.getValueClass().equals(CodeableConcept.class)) {
            stratum.setValue((CodeableConcept)value.getValue());
        } else {
            stratum.setValue(new CodeableConcept().setText(value.getValueAsString()));
        }
        for (Measure.MeasureGroupPopulationComponent mgpc : populations) {
            MeasureReport.StratifierGroupPopulationComponent stratumPopulation = stratum.addPopulation();
            this.buildStratumPopulation(bc, stratumPopulation, subjectIds, mgpc);
        }
    }

    protected void buildStratumPopulation(BuilderContext bc, MeasureReport.StratifierGroupPopulationComponent sgpc, List<String> subjectIds, Measure.MeasureGroupPopulationComponent population) {
        Set popSubjectIds;
        sgpc.setCode(population.getCode());
        sgpc.setId(population.getId());
        if (population.hasDescription()) {
            sgpc.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.population.description", (Type)new StringType(population.getDescription()));
        }
        if ((popSubjectIds = (Set)population.getUserData(POPULATION_SUBJECT_SET)) == null) {
            sgpc.setCount(0);
            return;
        }
        HashSet<String> intersection = new HashSet<String>(subjectIds);
        intersection.retainAll(popSubjectIds);
        sgpc.setCount(intersection.size());
        if (!intersection.isEmpty() && bc.report().getType() == MeasureReport.MeasureReportType.SUBJECTLIST) {
            ListResource popSubjectList = this.createIdList(UUID.randomUUID().toString(), intersection);
            bc.addContained((Resource)popSubjectList);
            sgpc.setSubjectResults(new Reference("#" + popSubjectList.getId()));
        }
    }

    protected String getPopulationResourceIds(Object resourceObject) {
        Resource resource = (Resource)resourceObject;
        return resource.getId();
    }

    protected void buildPopulation(BuilderContext bc, Measure.MeasureGroupPopulationComponent measurePopulation, MeasureReport.MeasureReportGroupPopulationComponent reportPopulation, PopulationDef populationDef, GroupDef groupDef) {
        reportPopulation.setCode(measurePopulation.getCode());
        reportPopulation.setId(measurePopulation.getId());
        if (groupDef.isBooleanBasis()) {
            reportPopulation.setCount(populationDef.getSubjects().size());
        } else {
            reportPopulation.setCount(populationDef.getResources().size());
        }
        if (measurePopulation.hasDescription()) {
            reportPopulation.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.population.description", (Type)new StringType(measurePopulation.getDescription()));
        }
        this.addEvaluatedResourceReferences(bc, populationDef.id(), populationDef.getEvaluatedResources());
        Set<String> populationSet = groupDef.isBooleanBasis() ? populationDef.getSubjects().stream().map(t -> ResourceType.Patient.toString().concat("/").concat((String)t)).collect(Collectors.toSet()) : populationDef.getResources().stream().filter(Resource.class::isInstance).map(this::getPopulationResourceIds).collect(Collectors.toSet());
        measurePopulation.setUserData(POPULATION_SUBJECT_SET, populationSet);
        if (Objects.requireNonNull(bc.report().getType()) == MeasureReport.MeasureReportType.SUBJECTLIST && !populationSet.isEmpty()) {
            ListResource subjectList = this.createIdList(UUID.randomUUID().toString(), populationSet);
            bc.addContained((Resource)subjectList);
            reportPopulation.setSubjectResults(new Reference("#" + subjectList.getId()));
        }
        if (Objects.requireNonNull(populationDef.type()) == MeasurePopulationType.MEASUREOBSERVATION) {
            this.buildMeasureObservations(bc, populationDef.expression(), populationDef.getResources());
        }
    }

    protected void buildMeasureObservations(BuilderContext bc, String observationName, Set<Object> resources) {
        for (int i = 0; i < resources.size(); ++i) {
            Observation observation = this.createMeasureObservation(bc, "measure-observation-" + observationName + "-" + (i + 1), observationName);
            bc.addContained((Resource)observation);
        }
    }

    protected ListResource createList(String id) {
        ListResource list = new ListResource();
        list.setId(id);
        return list;
    }

    protected ListResource createIdList(String id, Collection<String> ids) {
        return this.createReferenceList(id, ids.stream().map(Reference::new).collect(Collectors.toList()));
    }

    protected ListResource createReferenceList(String id, Collection<Reference> references) {
        ListResource referenceList = this.createList(id);
        for (Reference reference : references) {
            referenceList.addEntry().setItem(reference);
        }
        return referenceList;
    }

    protected void addEvaluatedResourceReferences(BuilderContext bc, String criteriaId, Set<Object> evaluatedResources) {
        if (evaluatedResources == null || evaluatedResources.isEmpty()) {
            return;
        }
        for (Object object : evaluatedResources) {
            Resource resource = (Resource)object;
            bc.addCriteriaExtensionToEvaluatedResource(resource, criteriaId);
        }
    }

    protected void buildSDE(BuilderContext bc, SdeDef sde) {
        MeasureReport report = bc.report();
        if (sde.getResults().isEmpty()) {
            return;
        }
        for (Map.Entry<String, CriteriaResult> e : sde.getResults().entrySet()) {
            this.addEvaluatedResourceReferences(bc, sde.id(), e.getValue().evaluatedResources());
        }
        CodeableConcept concept = this.conceptDefToConcept(sde.code());
        Map accumulated = sde.getResults().values().stream().flatMap(x -> Lists.newArrayList(x.iterableValue()).stream()).filter(Objects::nonNull).map(x$0 -> new ValueWrapper(x$0)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        for (Map.Entry accumulator : accumulated.entrySet()) {
            if (!(((ValueWrapper)accumulator.getKey()).getValue() instanceof Resource)) {
                String valueCode = ((ValueWrapper)accumulator.getKey()).getValueAsString();
                Long valueCount = accumulator.getValue();
                Coding valueCoding = new Coding().setCode(valueCode);
                DomainResource obs = Objects.requireNonNull(report.getType()) == MeasureReport.MeasureReportType.INDIVIDUAL ? this.createPatientObservation(bc, UUID.randomUUID().toString(), sde.id(), valueCoding, concept) : this.createPopulationObservation(bc, UUID.randomUUID().toString(), sde.id(), valueCoding, valueCount, concept);
                bc.addCriteriaExtensionToSupplementalData((Resource)obs, sde.id());
                continue;
            }
            Resource r = (Resource)((ValueWrapper)accumulator.getKey()).getValue();
            bc.addCriteriaExtensionToSupplementalData(r, sde.id());
        }
    }

    protected void buildSDEs(BuilderContext bc) {
        Measure measure = bc.measure();
        MeasureDef measureDef = bc.measureDef();
        for (int i = 0; i < measure.getSupplementalData().size(); ++i) {
            SdeDef sde = measureDef.sdes().get(i);
            this.buildSDE(bc, sde);
        }
    }

    private CodeableConcept conceptDefToConcept(ConceptDef c) {
        CodeableConcept cc = new CodeableConcept().setText(c.text());
        for (CodeDef cd : c.codes()) {
            cc.addCoding(this.codeDefToCoding(cd));
        }
        return cc;
    }

    private Coding codeDefToCoding(CodeDef c) {
        Coding cd = new Coding();
        cd.setSystem(c.system());
        cd.setCode(c.code());
        cd.setVersion(c.version());
        cd.setDisplay(c.display());
        return cd;
    }

    protected MeasureReport createMeasureReport(Measure measure, MeasureDef measureDef, MeasureReportType type, List<String> subjectIds, Interval measurementPeriod) {
        MeasureReport report = new MeasureReport();
        report.setStatus(MeasureReport.MeasureReportStatus.COMPLETE);
        report.setType(MeasureReport.MeasureReportType.fromCode((String)type.toCode()));
        if (type == MeasureReportType.INDIVIDUAL && !subjectIds.isEmpty()) {
            report.setSubject(new Reference(subjectIds.get(0)));
        }
        R4DateHelper helper = new R4DateHelper();
        if (measurementPeriod != null) {
            report.setPeriod(helper.buildMeasurementPeriod(measurementPeriod));
        }
        report.setMeasure(this.getMeasure(measure));
        report.setDate(new Date());
        report.setImplicitRules(measure.getImplicitRules());
        if (measureDef.groups().isEmpty() || !measureDef.groups().get(0).isGroupImprovementNotation()) {
            report.setImprovementNotation(measure.getImprovementNotation());
        }
        report.setLanguage(measure.getLanguage());
        if (measure.hasDescription()) {
            report.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-MeasureReport.population.description", (Type)new StringType(measure.getDescription()));
        }
        return report;
    }

    protected Extension createMeasureInfoExtension(MeasureInfo measureInfo) {
        Extension extExtMeasure = new Extension().setUrl("measure").setValue((Type)new CanonicalType(measureInfo.getMeasure()));
        Extension obsExtension = new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/cqf-measureInfo");
        obsExtension.addExtension(extExtMeasure);
        return obsExtension;
    }

    private String getMeasure(Measure measure) {
        if (StringUtils.isNotBlank((CharSequence)measure.getUrl()) && !measure.getUrl().contains("|") && measure.hasVersion()) {
            return measure.getUrl() + "|" + measure.getVersion();
        }
        return measure.getUrl();
    }

    private Coding geSupplementalDataCoding() {
        if (this.supplementalDataCoding == null) {
            this.supplementalDataCoding = new Coding().setCode("supplemental-data").setSystem("http://terminology.hl7.org/CodeSystem/measure-data-usage");
        }
        return this.supplementalDataCoding;
    }

    private CodeableConcept getMeasureUsageConcept(CodeableConcept originalConcept) {
        CodeableConcept measureUsageConcept = new CodeableConcept();
        ArrayList<Coding> list = new ArrayList<Coding>();
        list.add(this.geSupplementalDataCoding());
        measureUsageConcept.setCoding(list);
        if (originalConcept != null) {
            if (originalConcept.hasText() && StringUtils.isNotBlank((CharSequence)originalConcept.getText())) {
                measureUsageConcept.setText(originalConcept.getText());
            }
            if (originalConcept.hasCoding()) {
                measureUsageConcept.getCoding().add(originalConcept.getCodingFirstRep());
            }
        }
        return measureUsageConcept;
    }

    protected DomainResource createPopulationObservation(BuilderContext bc, String id, String populationId, Coding valueCoding, Long sdeAccumulatorValue, CodeableConcept originalConcept) {
        Observation obs = this.createObservation(bc, id, populationId);
        CodeableConcept obsCodeableConcept = new CodeableConcept();
        ArrayList<Coding> list = new ArrayList<Coding>();
        list.add(valueCoding);
        if (originalConcept != null && originalConcept.hasCoding()) {
            list.add(originalConcept.getCodingFirstRep());
        }
        obsCodeableConcept.setCoding(list);
        obs.setCode(obsCodeableConcept);
        obs.setValue((Type)new IntegerType(sdeAccumulatorValue));
        return obs;
    }

    protected DomainResource createPatientObservation(BuilderContext bc, String id, String populationId, Coding valueCoding, CodeableConcept originalConcept) {
        Observation obs = this.createObservation(bc, id, populationId);
        obs.setCode(this.getMeasureUsageConcept(originalConcept));
        CodeableConcept valueCodeableConcept = new CodeableConcept();
        valueCodeableConcept.setCoding(Collections.singletonList(valueCoding));
        obs.setValue((Type)valueCodeableConcept);
        return obs;
    }

    protected Observation createObservation(BuilderContext bc, String id, String populationId) {
        Measure measure = bc.measure();
        MeasureInfo measureInfo = new MeasureInfo().withMeasure((String)(measure.hasUrl() ? measure.getUrl() : (measure.hasId() ? "http://hl7.org/fhir/us/cqfmeasures/" + measure.getIdElement().getIdPart() : ""))).withPopulationId(populationId);
        Observation obs = new Observation();
        obs.setStatus(Observation.ObservationStatus.FINAL);
        obs.setId(id);
        obs.addExtension(this.createMeasureInfoExtension(measureInfo));
        return obs;
    }

    protected Observation createMeasureObservation(BuilderContext bc, String id, String observationName) {
        Observation obs = this.createObservation(bc, id, observationName);
        CodeableConcept cc = new CodeableConcept();
        cc.setText(observationName);
        obs.setCode(cc);
        return obs;
    }

    private static class BuilderContext {
        private final Measure measure;
        private final MeasureDef measureDef;
        private final MeasureReport measureReport;
        private final HashMap<String, Reference> evaluatedResourceReferences = new HashMap();
        private final HashMap<String, Reference> supplementalDataReferences = new HashMap();
        private final Map<String, Resource> contained = new HashMap<String, Resource>();

        public BuilderContext(Measure measure, MeasureDef measureDef, MeasureReport measureReport) {
            this.measure = measure;
            this.measureDef = measureDef;
            this.measureReport = measureReport;
        }

        public Map<String, Resource> contained() {
            return this.contained;
        }

        public void addContained(Resource r) {
            this.contained.putIfAbsent(this.getId(r), r);
        }

        public Measure measure() {
            return this.measure;
        }

        public MeasureReport report() {
            return this.measureReport;
        }

        public MeasureDef measureDef() {
            return this.measureDef;
        }

        public Map<String, Reference> evaluatedResourceReferences() {
            return this.evaluatedResourceReferences;
        }

        public Map<String, Reference> supplementalDataReferences() {
            return this.supplementalDataReferences;
        }

        public Reference addSupplementalDataReference(String id) {
            this.validateReference(id);
            return this.supplementalDataReferences().computeIfAbsent(id, x -> new Reference(id));
        }

        public Reference addEvaluatedResourceReference(String id) {
            this.validateReference(id);
            return this.evaluatedResourceReferences().computeIfAbsent(id, x -> new Reference(id));
        }

        public boolean hasEvaluatedResource(String id) {
            this.validateReference(id);
            return this.evaluatedResourceReferences().containsKey(id);
        }

        public void addCriteriaExtensionToReference(Reference reference, String criteriaId) {
            if (criteriaId == null) {
                throw new AssertionError((Object)"CriteriaId is required for extension references");
            }
            Extension ext = new Extension("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-criteriaReference", (IBaseDatatype)new StringType(criteriaId));
            this.addExtensionIfNotExists((Element)reference, ext);
        }

        public void addCriteriaExtensionToSupplementalData(Resource resource, String criteriaId) {
            Object id = this.getId(resource);
            if (!this.hasEvaluatedResource((String)id)) {
                this.addContained(resource);
                id = "#" + resource.getIdElement().getIdPart();
            }
            Reference ref = this.addSupplementalDataReference((String)id);
            this.addCriteriaExtensionToReference(ref, criteriaId);
        }

        public void addCriteriaExtensionToEvaluatedResource(Resource resource, String criteriaId) {
            String id = this.getId(resource);
            Reference ref = this.addEvaluatedResourceReference(id);
            this.addCriteriaExtensionToReference(ref, criteriaId);
        }

        private String getId(Resource resource) {
            return resource.fhirType() + "/" + resource.getIdElement().getIdPart();
        }

        private void addExtensionIfNotExists(Element element, Extension ext) {
            for (Extension e : element.getExtension()) {
                if (!e.getUrl().equals(ext.getUrl()) || !e.getValue().equalsShallow((Base)ext.getValue())) continue;
                return;
            }
            element.addExtension(ext);
        }

        private void validateReference(String reference) {
            if (reference == null) {
                throw new NullPointerException("validated reference is null");
            }
            if (reference.startsWith("#") && reference.contains("/")) {
                throw new InvalidRequestException("Invalid contained reference: " + reference);
            }
            if (!reference.startsWith("#") && reference.split("/").length != 2) {
                throw new InvalidRequestException("Invalid full reference: " + reference);
            }
        }

        public void addOperationOutcomes() {
            List<String> errorMsgs = this.measureDef.errors();
            for (String error : errorMsgs) {
                this.addContained((Resource)this.createOperationOutcome(error));
            }
        }

        private OperationOutcome createOperationOutcome(String errorMsg) {
            OperationOutcome op = new OperationOutcome();
            op.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setCode(OperationOutcome.IssueType.EXCEPTION).setDiagnostics(errorMsg);
            return op;
        }
    }

    class ValueWrapper {
        protected Object value;

        public ValueWrapper(Object value) {
            this.value = value;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ValueWrapper other = (ValueWrapper)o;
            if (other.getValue() == null ^ this.getValue() == null) {
                return false;
            }
            if (other.getValue() == null && this.getValue() == null) {
                return true;
            }
            return this.getKey().equals(other.getKey());
        }

        public String getKey() {
            String key = null;
            if (this.value instanceof Coding) {
                Coding c = (Coding)this.value;
                key = this.joinValues("coding", c.getCode());
            } else if (this.value instanceof CodeableConcept) {
                CodeableConcept c = (CodeableConcept)this.value;
                key = this.joinValues("codeable-concept", c.getCodingFirstRep().getCode());
            } else if (this.value instanceof Code) {
                Code c = (Code)this.value;
                key = this.joinValues("code", c.getCode());
            } else if (this.value instanceof Enum) {
                Enum e = (Enum)this.value;
                key = this.joinValues("enum", e.toString());
            } else if (this.value instanceof IPrimitiveType) {
                IPrimitiveType p = (IPrimitiveType)this.value;
                key = this.joinValues("primitive", p.getValueAsString());
            } else if (this.value instanceof Identifier) {
                key = ((Identifier)this.value).getValue();
            } else if (this.value instanceof Resource) {
                key = ((Resource)this.value).getIdElement().toVersionless().getValue();
            } else if (this.value != null) {
                key = this.value.toString();
            }
            if (key == null) {
                throw new InvalidRequestException(String.format("found a null key for the wrapped value: %s", this.value));
            }
            return key;
        }

        public String getValueAsString() {
            if (this.value instanceof Coding) {
                Coding c = (Coding)this.value;
                return c.getCode();
            }
            if (this.value instanceof CodeableConcept) {
                CodeableConcept c = (CodeableConcept)this.value;
                return c.getCodingFirstRep().getCode();
            }
            if (this.value instanceof Code) {
                Code c = (Code)this.value;
                return c.getCode();
            }
            if (this.value instanceof Enum) {
                Enum e = (Enum)this.value;
                return e.toString();
            }
            if (this.value instanceof IPrimitiveType) {
                IPrimitiveType p = (IPrimitiveType)this.value;
                return p.getValueAsString();
            }
            if (this.value instanceof Identifier) {
                return ((Identifier)this.value).getValue();
            }
            if (this.value instanceof Resource) {
                return ((Resource)this.value).getIdElement().toVersionless().getValue();
            }
            if (this.value != null) {
                return this.value.toString();
            }
            return "<null>";
        }

        public String getDescription() {
            if (this.value instanceof Coding) {
                Coding c = (Coding)this.value;
                return c.hasDisplay() ? c.getDisplay() : c.getCode();
            }
            if (this.value instanceof CodeableConcept) {
                CodeableConcept c = (CodeableConcept)this.value;
                return c.getCodingFirstRep().hasDisplay() ? c.getCodingFirstRep().getDisplay() : c.getCodingFirstRep().getCode();
            }
            if (this.value instanceof Code) {
                Code c = (Code)this.value;
                return c.getDisplay() != null ? c.getDisplay() : c.getCode();
            }
            if (this.value instanceof Enum) {
                Enum e = (Enum)this.value;
                return e.toString();
            }
            if (this.value instanceof IPrimitiveType) {
                IPrimitiveType p = (IPrimitiveType)this.value;
                return p.getValueAsString();
            }
            if (this.value instanceof Identifier) {
                return ((Identifier)this.value).getValue();
            }
            if (this.value instanceof Resource) {
                return ((Resource)this.value).getIdElement().toVersionless().getValue();
            }
            if (this.value != null) {
                return this.value.toString();
            }
            return null;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getValueClass() {
            if (this.value == null) {
                return String.class;
            }
            return this.value.getClass();
        }

        private String joinValues(String ... elements) {
            return String.join((CharSequence)"-", elements);
        }
    }
}

