/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Quantity;
import org.opencds.cqf.fhir.cr.measure.common.BaseMeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;

public class R4MeasureReportScorer
extends BaseMeasureReportScorer<MeasureReport> {
    private static final String NUMERATOR = "numerator";
    private static final String DENOMINATOR = "denominator";

    @Override
    public void score(String measureUrl, MeasureDef measureDef, MeasureReport measureReport) {
        if (measureDef == null) {
            throw new InvalidRequestException("MeasureDef is required in order to score a Measure for Measure: " + measureUrl);
        }
        if (measureReport.getGroup().isEmpty()) {
            return;
        }
        for (MeasureReport.MeasureReportGroupComponent mrgc : measureReport.getGroup()) {
            this.scoreGroup(this.getGroupMeasureScoring(mrgc, measureDef), mrgc, this.getGroupDef(measureDef, mrgc).isIncreaseImprovementNotation());
        }
    }

    protected GroupDef getGroupDef(MeasureDef measureDef, MeasureReport.MeasureReportGroupComponent mrgc) {
        List<GroupDef> groupDefs = measureDef.groups();
        if (groupDefs.size() == 1) {
            return groupDefs.get(0);
        }
        return groupDefs.stream().filter(t -> t.id().equals(mrgc.getId())).findFirst().orElse(null);
    }

    protected MeasureScoring checkMissingScoringType(MeasureDef measureDef, MeasureScoring measureScoring) {
        if (measureScoring == null) {
            throw new InvalidRequestException("Measure does not have a scoring methodology defined. Add a \"scoring\" property to the measure definition or the group definition for MeasureDef: " + measureDef.url());
        }
        return measureScoring;
    }

    protected void groupHasValidId(MeasureDef measureDef, String id) {
        if (id == null || id.isEmpty()) {
            throw new InvalidRequestException("Measure resources with more than one group component require a unique group.id() defined to score appropriately for MeasureDef: " + measureDef.url());
        }
    }

    protected MeasureScoring getGroupMeasureScoring(MeasureReport.MeasureReportGroupComponent mrgc, MeasureDef measureDef) {
        MeasureScoring groupScoringType = null;
        if (measureDef.groups().size() == 1) {
            groupScoringType = measureDef.groups().get(0).measureScoring();
        } else {
            for (GroupDef groupDef : measureDef.groups()) {
                MeasureScoring groupDefMeasureScoring = groupDef.measureScoring();
                this.groupHasValidId(measureDef, mrgc.getId());
                this.groupHasValidId(measureDef, groupDef.id());
                if (!groupDef.id().equals(mrgc.getId())) continue;
                groupScoringType = groupDefMeasureScoring;
            }
        }
        return this.checkMissingScoringType(measureDef, groupScoringType);
    }

    protected void scoreGroup(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupComponent mrgc, boolean isIncreaseImprovementNotation) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getCountFromGroupPopulation(mrgc.getPopulation(), NUMERATOR), this.getCountFromGroupPopulation(mrgc.getPopulation(), DENOMINATOR));
                if (score == null) break;
                if (isIncreaseImprovementNotation) {
                    mrgc.setMeasureScore(new Quantity(score.doubleValue()));
                    break;
                }
                mrgc.setMeasureScore(new Quantity(1.0 - score));
                break;
            }
        }
        for (MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent : mrgc.getStratifier()) {
            this.scoreStratifier(measureScoring, stratifierComponent);
        }
    }

    protected void scoreStratum(MeasureScoring measureScoring, MeasureReport.StratifierGroupComponent stratum) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getCountFromStratifierPopulation(stratum.getPopulation(), NUMERATOR), this.getCountFromStratifierPopulation(stratum.getPopulation(), DENOMINATOR));
                if (score == null) break;
                stratum.setMeasureScore(new Quantity(score.doubleValue()));
                break;
            }
        }
    }

    protected void scoreStratifier(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent) {
        for (MeasureReport.StratifierGroupComponent sgc : stratifierComponent.getStratum()) {
            this.scoreStratum(measureScoring, sgc);
        }
    }

    private int getCountFromGroupPopulation(List<MeasureReport.MeasureReportGroupPopulationComponent> populations, String populationName) {
        return populations.stream().filter(population -> populationName.equals(population.getCode().getCodingFirstRep().getCode())).map(MeasureReport.MeasureReportGroupPopulationComponent::getCount).findAny().orElse(0);
    }

    private int getCountFromStratifierPopulation(List<MeasureReport.StratifierGroupPopulationComponent> populations, String populationName) {
        return populations.stream().filter(population -> populationName.equals(population.getCode().getCodingFirstRep().getCode())).map(MeasureReport.StratifierGroupPopulationComponent::getCount).findAny().orElse(0);
    }
}

