/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import com.google.common.base.Strings;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePeriodValidator;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureEvaluatorMultiple;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureProcessor;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4MeasureServiceUtils;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.builder.BundleBuilder;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4MultiMeasureService
implements R4MeasureEvaluatorMultiple {
    private static final Logger log = LoggerFactory.getLogger(R4MultiMeasureService.class);
    private Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private final MeasurePeriodValidator measurePeriodValidator;
    private String serverBase;
    private final R4RepositorySubjectProvider subjectProvider;
    private R4MeasureProcessor r4Processor;
    private R4MeasureServiceUtils r4MeasureServiceUtils;

    public R4MultiMeasureService(Repository repository, MeasureEvaluationOptions measureEvaluationOptions, String serverBase, MeasurePeriodValidator measurePeriodValidator) {
        this.repository = repository;
        this.measureEvaluationOptions = measureEvaluationOptions;
        this.measurePeriodValidator = measurePeriodValidator;
        this.serverBase = serverBase;
        this.subjectProvider = new R4RepositorySubjectProvider(measureEvaluationOptions.getSubjectProviderOptions());
        this.r4Processor = new R4MeasureProcessor(repository, this.measureEvaluationOptions, this.subjectProvider, this.r4MeasureServiceUtils);
        this.r4MeasureServiceUtils = new R4MeasureServiceUtils(repository);
    }

    @Override
    public Bundle evaluate(List<IdType> measureId, List<String> measureUrl, List<String> measureIdentifier, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, String subject, Endpoint contentEndpoint, Endpoint terminologyEndpoint, Endpoint dataEndpoint, Bundle additionalData, Parameters parameters, String productLine, String reporter) {
        this.measurePeriodValidator.validatePeriodStartAndEnd(periodStart, periodEnd);
        if (dataEndpoint != null && contentEndpoint != null && terminologyEndpoint != null) {
            this.repository = Repositories.proxy((Repository)this.repository, (Boolean)true, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
            this.r4Processor = new R4MeasureProcessor(this.repository, this.measureEvaluationOptions, this.subjectProvider, this.r4MeasureServiceUtils);
            this.r4MeasureServiceUtils = new R4MeasureServiceUtils(this.repository);
        }
        this.r4MeasureServiceUtils.ensureSupplementalDataElementSearchParameter();
        List<Measure> measures = this.r4MeasureServiceUtils.getMeasures(measureId, measureIdentifier, measureUrl);
        log.info("multi-evaluate-measure, measures to evaluate: {}", (Object)measures.size());
        MeasureEvalType evalType = this.r4MeasureServiceUtils.getMeasureEvalType(reportType, subject);
        List<String> subjects = this.getSubjects(this.subjectProvider, subject);
        Bundle bundle = (Bundle)new BundleBuilder(Bundle.class).withType(Bundle.BundleType.SEARCHSET.toString()).build();
        if (evalType.equals((Object)MeasureEvalType.POPULATION) || evalType.equals((Object)MeasureEvalType.SUBJECTLIST)) {
            this.populationMeasureReport(bundle, measures, periodStart, periodEnd, reportType, evalType, subject, subjects, parameters, additionalData, productLine, reporter);
        } else {
            this.subjectMeasureReport(bundle, measures, periodStart, periodEnd, reportType, evalType, subjects, parameters, additionalData, productLine, reporter);
        }
        return bundle;
    }

    protected void populationMeasureReport(Bundle bundle, List<Measure> measures, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, MeasureEvalType evalType, String subjectParam, List<String> subjects, Parameters parameters, Bundle additionalData, String productLine, String reporter) {
        int totalMeasures = measures.size();
        for (Measure measure : measures) {
            MeasureReport measureReport = this.r4Processor.evaluateMeasure(measure, periodStart, periodEnd, reportType, subjects, (IBaseBundle)additionalData, parameters, evalType);
            measureReport = this.r4MeasureServiceUtils.addProductLineExtension(measureReport, productLine);
            measureReport = this.r4MeasureServiceUtils.addSubjectReference(measureReport, null, subjectParam);
            if (reporter != null && !reporter.isEmpty()) {
                measureReport.setReporter((Reference)this.r4MeasureServiceUtils.getReporter(reporter).orElse(null));
            }
            this.initializeReport(measureReport);
            bundle.addEntry(this.getBundleEntry(this.serverBase, (Resource)measureReport));
            String measureUrl = measureReport.getMeasure();
            if (measureUrl.isEmpty()) continue;
            log.debug("Completed evaluation for Measure: {}, Measures remaining to evaluate: {}", (Object)measureUrl, (Object)totalMeasures--);
        }
    }

    protected void subjectMeasureReport(Bundle bundle, List<Measure> measures, @Nullable ZonedDateTime periodStart, @Nullable ZonedDateTime periodEnd, String reportType, MeasureEvalType evalType, List<String> subjects, Parameters parameters, Bundle additionalData, String productLine, String reporter) {
        int totalReports = subjects.size() * measures.size();
        int totalMeasures = measures.size();
        log.debug("Evaluating individual MeasureReports for {} patients, and {} measures", (Object)subjects.size(), (Object)measures.size());
        for (Measure measure : measures) {
            for (String subject : subjects) {
                MeasureReport measureReport = this.r4Processor.evaluateMeasure(measure, periodStart, periodEnd, reportType, Collections.singletonList(subject), (IBaseBundle)additionalData, parameters, evalType);
                measureReport = this.r4MeasureServiceUtils.addProductLineExtension(measureReport, productLine);
                if (reporter != null && !reporter.isEmpty()) {
                    measureReport.setReporter((Reference)this.r4MeasureServiceUtils.getReporter(reporter).orElse(null));
                }
                this.initializeReport(measureReport);
                bundle.addEntry(this.getBundleEntry(this.serverBase, (Resource)measureReport));
                String measureUrl = measureReport.getMeasure();
                if (measureUrl.isEmpty()) continue;
                log.debug("MeasureReports remaining to evaluate {}", (Object)totalReports--);
            }
            if (!measure.hasUrl()) continue;
            log.info("Completed evaluation for Measure: {}, Measures remaining to evaluate: {}", (Object)measure.getUrl(), (Object)totalMeasures--);
        }
    }

    protected List<String> getSubjects(R4RepositorySubjectProvider subjectProvider, String subjectId) {
        return subjectProvider.getSubjects(this.repository, subjectId).collect(Collectors.toList());
    }

    protected void initializeReport(MeasureReport measureReport) {
        if (Strings.isNullOrEmpty((String)measureReport.getId())) {
            IIdType id = Ids.newId(MeasureReport.class, (String)UUID.randomUUID().toString());
            measureReport.setId(id);
        }
    }

    protected Bundle.BundleEntryComponent getBundleEntry(String serverBase, Resource resource) {
        return new Bundle.BundleEntryComponent().setResource(resource).setFullUrl(R4MeasureServiceUtils.getFullUrl(serverBase, (IBaseResource)resource));
    }
}

