/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4.utils;

import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.util.BundleBuilder;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.constant.MeasureReportConstants;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureEvalType;
import org.opencds.cqf.fhir.utility.Ids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4MeasureServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(R4MeasureServiceUtils.class);
    private final Repository repository;
    public static final List<ContactDetail> CQI_CONTACTDETAIL = Collections.singletonList(new ContactDetail().addTelecom(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.URL).setValue("http://www.hl7.org/Special/committees/cqi/index.cfm")));
    public static final List<CodeableConcept> US_JURISDICTION_CODING = Collections.singletonList(new CodeableConcept().addCoding(new Coding("urn:iso:std:iso:3166", "US", "United States of America")));
    public static final SearchParameter SUPPLEMENTAL_DATA_SEARCHPARAMETER = (SearchParameter)new SearchParameter().setUrl("http://hl7.org/fhir/us/davinci-deqm/SearchParameter/measurereport-supplemental-data").setVersion("0.1.0").setName("DEQMMeasureReportSupplementalData").setStatus(Enumerations.PublicationStatus.ACTIVE).setDate((Date)MeasureReportConstants.MEASUREREPORT_SUPPLEMENTALDATA_SEARCHPARAMETER_DEFINITION_DATE).setPublisher("HL7 International - Clinical Quality Information Work Group").setContact(CQI_CONTACTDETAIL).setDescription(String.format("Returns resources (supplemental data) from references on extensions on the MeasureReport with urls matching %s.", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setJurisdiction(US_JURISDICTION_CODING).addBase("MeasureReport").setCode("supplemental-data").setType(Enumerations.SearchParamType.REFERENCE).setExpression(String.format("MeasureReport.extension('%s').value", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpath(String.format("f:MeasureReport/f:extension[@url='%s'].value", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpathUsage(SearchParameter.XPathUsageType.NORMAL).setTitle("Supplemental Data").setId("deqm-measurereport-supplemental-data");

    public R4MeasureServiceUtils(Repository repository) {
        this.repository = repository;
    }

    public MeasureReport addProductLineExtension(MeasureReport measureReport, String productLine) {
        if (productLine != null) {
            Extension ext = new Extension();
            ext.setUrl("http://hl7.org/fhir/us/cqframework/cqfmeasures/StructureDefinition/cqfm-productLine");
            ext.setValue((Type)new StringType(productLine));
            measureReport.addExtension(ext);
        }
        return measureReport;
    }

    public static String getFullUrl(String serverAddress, IBaseResource resource) {
        Preconditions.checkArgument((boolean)resource.getIdElement().hasIdPart(), (Object)"Cannot generate a fullUrl because the resource does not have an id.");
        return R4MeasureServiceUtils.getFullUrl(serverAddress, resource.fhirType(), Ids.simplePart((IBaseResource)resource));
    }

    public static String getFullUrl(String serverAddress, String fhirType, String elementId) {
        return String.format("%s%s/%s", serverAddress + (serverAddress.endsWith("/") ? "" : "/"), fhirType, elementId);
    }

    public void ensureSupplementalDataElementSearchParameter() {
        BundleBuilder builder = new BundleBuilder(this.repository.fhirContext());
        builder.addTransactionCreateEntry((IBaseResource)SUPPLEMENTAL_DATA_SEARCHPARAMETER).conditional("code=supplemental-data");
        try {
            this.repository.transaction(builder.getBundle());
        }
        catch (NotImplementedOperationException e) {
            log.warn("Error creating supplemental data search parameter. This may be due to the server not supporting transactions.", (Throwable)e);
        }
    }

    public MeasureReport addSubjectReference(MeasureReport measureReport, String practitioner, String subjectId) {
        if ((StringUtils.isNotBlank((CharSequence)practitioner) || StringUtils.isNotBlank((CharSequence)subjectId)) && (measureReport.getType().name().equals(MeasureReportType.SUMMARY.name()) || measureReport.getType().name().equals(MeasureReportType.SUBJECTLIST.name()))) {
            if (StringUtils.isNotBlank((CharSequence)practitioner)) {
                if (!practitioner.contains("/")) {
                    practitioner = "Practitioner/".concat(practitioner);
                }
                measureReport.setSubject(new Reference(practitioner));
            } else {
                if (!subjectId.contains("/")) {
                    subjectId = "Patient/".concat(subjectId);
                }
                measureReport.setSubject(new Reference(subjectId));
            }
        }
        return measureReport;
    }

    public Optional<Reference> getReporter(String reporter) {
        if (reporter != null && !reporter.isEmpty() && !reporter.contains("/")) {
            throw new IllegalArgumentException("R4MultiMeasureService requires '[ResourceType]/[ResourceId]' format to set MeasureReport.reporter reference.");
        }
        Reference reference = null;
        if (reporter != null && !reporter.isEmpty()) {
            if (reporter.startsWith("PractitionerRole")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"PractitionerRole"));
            } else if (reporter.startsWith("Practitioner")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"Practitioner"));
            } else if (reporter.startsWith("Organization")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"Organization"));
            } else if (reporter.startsWith("Location")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"Location"));
            } else {
                throw new IllegalArgumentException("MeasureReport.reporter does not accept ResourceType: " + reporter);
            }
        }
        return Optional.ofNullable(reference);
    }

    public Measure resolveById(IdType id) {
        return (Measure)this.repository.read(Measure.class, (IIdType)id);
    }

    public Measure resolveByUrl(String url) {
        HashMap<String, List<Object>> searchParameters = new HashMap<String, List<Object>>();
        if (url.contains("|")) {
            String[] splitId = url.split("\\|");
            String uri = splitId[0];
            String version = splitId[1];
            searchParameters.put("url", Collections.singletonList(new UriParam(uri)));
            searchParameters.put("version", Collections.singletonList(new TokenParam(version)));
        } else {
            searchParameters.put("url", Collections.singletonList(new UriParam(url)));
        }
        Bundle result = (Bundle)this.repository.search(Bundle.class, Measure.class, searchParameters);
        return (Measure)result.getEntryFirstRep().getResource();
    }

    public Measure resolveByIdentifier(String identifier) {
        String msg;
        ArrayList<TokenParam> params = new ArrayList<TokenParam>();
        HashMap<String, ArrayList<TokenParam>> searchParams = new HashMap<String, ArrayList<TokenParam>>();
        if (identifier.contains("|")) {
            String[] splitId = identifier.split("\\|");
            String system = splitId[0];
            String code = splitId[1];
            params.add(new TokenParam(system, code));
        } else {
            params.add(new TokenParam(identifier));
        }
        searchParams.put("identifier", params);
        Bundle bundle = (Bundle)this.repository.search(Bundle.class, Measure.class, searchParams);
        if (bundle != null && !bundle.getEntry().isEmpty()) {
            if (bundle.getEntry().size() > 1) {
                msg = String.format("Measure Identifier: %s, found more than one matching measure resource", identifier);
                throw new InvalidRequestException(msg);
            }
            return (Measure)bundle.getEntryFirstRep().getResource();
        }
        msg = String.format("Measure Identifier: %s, found no matching measure resources", identifier);
        throw new InvalidRequestException(msg);
    }

    public List<Measure> getMeasures(List<IdType> measureIds, List<String> measureIdentifiers, List<String> measureCanonicals) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        if (measureIds != null && !measureIds.isEmpty()) {
            for (IdType measureId : measureIds) {
                Measure measureById = this.resolveById(measureId);
                measures.add(measureById);
            }
        }
        if (measureCanonicals != null && !measureCanonicals.isEmpty()) {
            for (String measureCanonical : measureCanonicals) {
                Measure measureByUrl = this.resolveByUrl(measureCanonical);
                measures.add(measureByUrl);
            }
        }
        if (measureIdentifiers != null && !measureIdentifiers.isEmpty()) {
            for (String measureIdentifier : measureIdentifiers) {
                Measure measureByIdentifier = this.resolveByIdentifier(measureIdentifier);
                measures.add(measureByIdentifier);
            }
        }
        return R4MeasureServiceUtils.distinctByKey(measures, Measure::getUrl);
    }

    public static <T> List<T> distinctByKey(List<T> list, Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return list.stream().filter(element -> seen.add(keyExtractor.apply(element))).collect(Collectors.toList());
    }

    public List<MeasureScoring> getMeasureGroupScoringTypes(Measure measure) {
        List groupScoringCodes = measure.getGroup().stream().map(t -> (CodeableConcept)t.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring").getValue()).collect(Collectors.toList());
        return groupScoringCodes.stream().map(t -> MeasureScoring.fromCode(t.getCodingFirstRep().getCode())).collect(Collectors.toList());
    }

    public boolean hasGroupScoringDef(Measure measure) {
        return !measure.getGroup().stream().filter(t -> t.getExtensionByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring") != null).collect(Collectors.toList()).isEmpty();
    }

    public List<MeasureScoring> getMeasureScoringDef(Measure measure) {
        if (this.hasGroupScoringDef(measure)) {
            return this.getMeasureGroupScoringTypes(measure);
        }
        if (!measure.hasScoring()) {
            throw new InvalidRequestException(String.format("Measure: %s, does not have a defined Measure Scoring Type.", measure.getIdPart()));
        }
        return Collections.singletonList(MeasureScoring.fromCode(measure.getScoring().getCodingFirstRep().getCode()));
    }

    public void listThrowIllegalArgumentIfEmpty(List<String> value, String parameterName) {
        if (value == null || value.isEmpty()) {
            throw new InvalidRequestException(parameterName + " parameter requires a value.");
        }
    }

    public MeasureEvalType getMeasureEvalType(String reportType, @Nullable String subjectId) {
        return this.convertToNonVersionedMeasureEvalTypeOrDefault(this.getR4MeasureEvalType(reportType, Collections.singletonList(subjectId)));
    }

    public MeasureEvalType getMeasureEvalType(String reportType, List<String> subjectIds) {
        return this.convertToNonVersionedMeasureEvalTypeOrDefault(this.getR4MeasureEvalType(reportType, subjectIds));
    }

    @Nonnull
    public R4MeasureEvalType getR4MeasureEvalType(String reportType, List<String> subjectIds) {
        return R4MeasureEvalType.fromCode(reportType).orElse(this.isSubjectListEffectivelyEmpty(subjectIds) ? R4MeasureEvalType.POPULATION : R4MeasureEvalType.SUBJECT);
    }

    @Nonnull
    public MeasureEvalType convertToNonVersionedMeasureEvalTypeOrDefault(R4MeasureEvalType r4MeasureEvalType) {
        return MeasureEvalType.fromCode(r4MeasureEvalType.toCode()).orElse(MeasureEvalType.SUBJECT);
    }

    public boolean isSubjectListEffectivelyEmpty(List<String> subjectIds) {
        return subjectIds == null || subjectIds.isEmpty() || subjectIds.get(0) == null;
    }
}

